<?php
	include_once "../dap-config.php";
	
	$queryString = $_SERVER['QUERY_STRING'];
	//echo $queryString; exit;
	
	$a = isset($_REQUEST['a']) ? $_REQUEST['a'] : ""; //a = affiliate id
	$p = isset($_REQUEST['p']) ? $_REQUEST['p'] : ""; //p = URL to which user to be redirected - any valid URL
	
	//logToFile("aff: p: $p  , a: $a"); 
	
	//If $p is set, redirect to that page - else redir to site home page
	if($p == "") {
		$p = Dap_Config::get('DEFAULT_AFF_LANDING');
		if($p == "") {
			$p = SITE_URL_DAP;
		}
	} else if ( (substr($p, 0, 7) != "http://") && (substr($p, 0, 8) != "https://") ){
		$p = "http://" . $p;
	}
	
	//echo Dap_Config::get("NO_FREE_AFFILIATES"); exit;
						  
	//Store affiliate id in cookie
	if($a != "") { //set cookie for one year : 31536000 seconds
		//First, do some checks on affiliate
		$user = Dap_User::loadUserById($a); //Load User
		//echo $user->isPaidUser(); exit;
		if( 
		   	(!isset($user)) //Either user is not set 
			|| 
			( (Dap_Config::get("NO_FREE_AFFILIATES") == "Y") && (!$user->isPaidUser()) ) //No free affiliates
			||
			( $user->getIs_affiliate() == "N" ) //Affiliate feature disabled
		)
		{
			//echo "in here"; exit;
			header( "HTTP/1.1 301 Moved Permanently" ); 
			//header("Location: $p" . "?" . $queryString);
			header("Location: $p");
			exit;
		}		
		
		//Checks are ok, now set affiliate cookie
		//AFF_COOKIE_LENGTH in days multiplied by 24 * 60 * 60 to convert into seconds
		$cookieLifetime = intval(Dap_Config::get('AFF_COOKIE_LENGTH')) * 24 * 60 * 60;
		
		/**
			If last-cookie, then blindly create-new or overwrite-existing cookie
			If first-cookie, then set only if no existing cookie
		*/
		$firstOrLast = Dap_Config::get('FIRST_LAST_COOKIE');
		//logToFile("firstOrLast: " . $firstOrLast); 
		
		if($firstOrLast == "Last-Cookie") {
			setcookie("dapa",$a,time()+$cookieLifetime,"/",str_replace("www.", "", "." . $_SERVER['HTTP_HOST']));
		} else if($firstOrLast == "First-Cookie") {
			if(!isset($_COOKIE['dapa'])) {
				setcookie("dapa",$a,time()+$cookieLifetime,"/",str_replace("www.", "", "." . $_SERVER['HTTP_HOST']));
			}
		}
		
		//only allow whitelisted domains in p tag
		$whiteListedDomains = Dap_Config::get("WHITELISTED_DOMAINS");
		
		if($whiteListedDomains != ''){
			$whiteListedDomains = explode(',' , $whiteListedDomains);
	
			$redirect = false;
			
			foreach($whiteListedDomains as $url){
				$domain = get_domain($url); 
				if (strpos($p, $domain) !== false) {
					$redirect = true;
				}
			}
			
			if($redirect == false){
				// domain in p tag not whitelisted, redirect to default page
				$p = Dap_Config::get('DEFAULT_AFF_LANDING');
				if($p == "") {
					$p = SITE_URL_DAP;
				}
			}
		}
		
		
		//write affiliate referral details into db
		$http_referer = "";
		$ip = getIpOfUser();
		$useragent = $_SERVER['HTTP_USER_AGENT'];
		
		if(isset($_SERVER['HTTP_REFERER'])) {
			$http_referer = $_SERVER['HTTP_REFERER'];
		}
		
		Dap_AffStats::saveAffiliateStats($a, $http_referer, date("Y-m-d H:i:s"), $useragent, $ip, $p);

	}
	header( "HTTP/1.1 301 Moved Permanently" );
	
	//logToFile("redirect to : " . $p . "?" . $queryString); 
	
	header("Location: $p");
	
	
	function get_domain($url){
		  $pieces = parse_url($url);
		  $domain = isset($pieces['host']) ? $pieces['host'] : $pieces['path'];
		  if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)) {
			return $regs['domain'];
		  }
		  return false;
		}	
?>
