jQuery(document).ready(function(){	
	jQuery('#manage_progress_bar_table').DataTable({order: [[2, 'desc']]});  
	dap_course_progress_bar_customize_template_style_option();
});	


function dap_course_progress_bar_customize_template_style_option(){
	
	var temp_class = '#pb_customize_template';
	
	
	//Template Style
	jQuery('#pb_tmp_wid').bootstrapSlider().change(function() {
		jQuery(temp_class).css('max-width', this.value + 'px');
	});
	
	
	jQuery('#pb_temp_align').change(function(){
		var style = jQuery(this).val();
		jQuery('.pb_frontent_template_wrapper').css('text-align', style);
	});

	jQuery('#pb_tmp_background,#pb_tmp_background_div').colorpicker().on('changeColor', function() {
		jQuery(temp_class).css('background-color', jQuery(this).colorpicker('getValue'));
	});
	
	jQuery('#pb_tmp_bdr_style').change(function(){
		var style = jQuery(this).val();
		jQuery(temp_class).css('border-style', style);
	});
	jQuery('#pb_tmp_bdr_wid').bootstrapSlider().change(function() {
		jQuery(temp_class).css('border-width', this.value + 'px');
	});
	jQuery('#pb_tmp_br_radius').bootstrapSlider().change(function() {
		jQuery(temp_class).css('border-radius', this.value + 'px');
	});
	
	jQuery('#pb_tmp_border_color,#pb_tmp_border_color_div').colorpicker().on('changeColor', function() {
		jQuery(temp_class).css('border-color', jQuery(this).colorpicker('getValue'));
	});
	
	//Progress Bar Style
	jQuery('#pb_wid').bootstrapSlider().change(function() {
		jQuery(temp_class).find('.porgress_bar_outer').css('max-width', this.value + 'px');
	});
	
	jQuery('#pb_background,#pb_background_div').colorpicker().on('changeColor', function() {
		jQuery(temp_class).find('.porgress_bar_grey').css('background-color', jQuery(this).colorpicker('getValue'));
	});

   
	jQuery('#pb_br_radius').bootstrapSlider().change(function() {
		jQuery(temp_class).find('.porgress_bar_grey').css('border-radius', this.value + 'px');
		jQuery(temp_class).find('.porgress_bar_green').css('border-radius', this.value + 'px');
	});
	
	
	jQuery('#pb_height').bootstrapSlider().change(function() {
		jQuery(temp_class).find('.porgress_bar_grey').css('height', this.value + 'px');
		jQuery(temp_class).find('.porgress_bar_green').css('height', this.value + 'px');
	});
	
	
	
	jQuery('#pb_compelete_bar_background,#pb_compelete_bar_background_div').colorpicker().on('changeColor', function() {
		jQuery(temp_class).find('.porgress_bar_green').css('background-color', jQuery(this).colorpicker('getValue'));
	});

	 
	//External Shadow Customizer
    jQuery('#pb_spread_radius').bootstrapSlider().change(function() {
		dap_pb_box_shadow();
	});
	
	jQuery('#pb_blur_radius').bootstrapSlider().change(function() {
		dap_pb_box_shadow();
	});
	
	jQuery('#pb_hor_lnth').bootstrapSlider().change(function() {
		dap_pb_box_shadow();
	});
	
	jQuery('#pb_ver_lnth').bootstrapSlider().change(function() {
		dap_pb_box_shadow(); 
	});
	
    jQuery('#pb_shad_clr,#pb_shad_clr_div').colorpicker().on('changeColor', function() {
		dap_pb_box_shadow();
	});
    
}

function dap_pb_box_shadow(colorval) {
	var hor_lnth = parseFloat(jQuery('#pb_hor_lnth').val());
	var ver_lnth = parseFloat(jQuery('#pb_ver_lnth').val());
	var blur_radius = parseFloat(jQuery('#pb_blur_radius').val());
	var sprd_radius = parseFloat(jQuery('#pb_spread_radius').val());
	var shad_clr = jQuery('#pb_shad_clr').val();
	
	hor_lnth = hor_lnth + 'px';
	ver_lnth = ver_lnth + 'px';
	blur_radius = blur_radius + 'px';
	sprd_radius = sprd_radius + 'px';
	var box_shadow = hor_lnth + ' ' + ver_lnth + ' ' + blur_radius + ' ' + sprd_radius + ' ' + shad_clr;
	var temp_class = '#pb_customize_template';
	jQuery(temp_class).css('-webkit-box-shadow', box_shadow);
	jQuery(temp_class).css('-moz-box-shadow', box_shadow);
	jQuery(temp_class).css('box-shadow', box_shadow);
}

function dap_progress_bar_save(){
	var cid = jQuery('#pb_course_name').val();
	if(cid == 0 || cid == ''){
		swal("Please select course name");
		jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
		return false;
	} 
	var pb_display_course = jQuery('#pb_display_course').val();
	
	var html = jQuery('.pb_customize_template_wrapper').html();
	// Template Style
	var pb_tmp_wid = jQuery('#pb_tmp_wid').val();
	var pb_temp_align = jQuery('#pb_temp_align').val();
	var pb_tmp_background = jQuery('#pb_tmp_background').val();
	var pb_tmp_bdr_style = jQuery('#pb_tmp_bdr_style').val();
	var pb_tmp_bdr_wid = jQuery('#pb_tmp_bdr_wid').val();
	var pb_tmp_br_radius = jQuery('#pb_tmp_br_radius').val();
	var pb_tmp_border_color = jQuery('#pb_tmp_border_color').val();
	var template_values = pb_tmp_wid+'||'+pb_temp_align+'||'+pb_tmp_background+'||'+pb_tmp_bdr_style+'||'+pb_tmp_bdr_wid+'||'+pb_tmp_br_radius+'||'+pb_tmp_border_color;
	//Progress Bar Style
	var pb_wid = jQuery('#pb_wid').val();
	var pb_background = jQuery('#pb_background').val();
	var pb_br_radius = jQuery('#pb_br_radius').val();
	var pb_height = jQuery('#pb_height').val();
	var pb_compelete_bar_background = jQuery('#pb_compelete_bar_background').val();
	
	var progress_bar_values = pb_wid+'||'+pb_background+'||'+pb_br_radius+'||'+pb_height+'||'+pb_compelete_bar_background;
	//External Shadow Customizer
    var pb_spread_radius = jQuery('#pb_spread_radius').val();
    var pb_blur_radius = jQuery('#pb_blur_radius').val();
    var pb_hor_lnth = jQuery('#pb_hor_lnth').val();
    var pb_ver_lnth = jQuery('#pb_ver_lnth').val();
    var pb_shad_clr = jQuery('#pb_shad_clr').val();
    var shadow_values = pb_spread_radius+'||'+pb_blur_radius+'||'+pb_hor_lnth+'||'+pb_ver_lnth+'||'+pb_shad_clr;
    var customiz_values = pb_display_course+'|||'+template_values+'|||'+progress_bar_values+'|||'+shadow_values;
    var name  = 'courseprogressbar'; 		 
    var id  = jQuery('#progress_bar_id').val();
    
    
    dap_product_show_loader();
    var ajax_url = 'ajax/manageProductsAjax.php';
    
	jQuery.ajax({
		url: ajax_url,
			type:'POST',
			data:{
				operation_name : 'add_progress_bar',		
				data :{"id":id, "name":name, "cid":cid, "html":html, "customize_data":customiz_values},
			} ,
			success: function(response){
				dap_product_hide_loader();
				var response = JSON.parse(response);
				if(response.id){
					jQuery('#progress_bar_id').val(response.id);
				}
				if(response.success){
					//swal("", response.success, "success"); 
					jQuery(".pb_info_div_wrapper").show();	
					jQuery(".pb_info_div").html("<p>"+response.success+"</p>");	
				}
                
                if(response.progress_bar_list){
						var table = jQuery('#manage_progress_bar_table').DataTable();
						table.clear().draw();
						table.rows.add(response.progress_bar_list).draw();
				}
				
			}
	});		
}

function dap_show_create_progress_bar_button_hit(){
	dapEditProgressBar('');
}
function dap_show_create_progress_bar(){

	jQuery('.dap_manage_progress_bar_wrapper').hide(1000,function(){
		jQuery('.dap_create_progress_bar_wrapper').show('swing');
	});
	
}

function dap_show_manage_progress_bar(){
	jQuery('.dap_create_progress_bar_wrapper').hide(1000,function(){
		jQuery('.dap_manage_progress_bar_wrapper').show('swing');
	});
	
}


function dapEditProgressBar(obj = ''){
	
	jQuery('.pb_info_div_wrapper').hide();
	if(obj == ''){
		var pb_id  = 'create_new_pb';
		
		jQuery('.progress_bar_create_heading').show();
		jQuery('.progress_bar_update_heading').hide();
	}else{
		var pb_id = jQuery(obj).attr('data-id');
		jQuery('.progress_bar_create_heading').hide();
		jQuery('.progress_bar_update_heading').show();
	}
	
	dap_product_show_loader();
    var ajax_url = 'ajax/manageProductsAjax.php';
    
	jQuery.ajax({
		url: ajax_url,
			type:'POST',
			data:{
				operation_name : 'get_progress_bar_info',		
				pb_id:pb_id,
			} ,
			success: function(response){
				dap_product_hide_loader();
				var response = JSON.parse(response);

				if(response.success){
					if(response.text_array){
						jQuery.each( response.text_array, function( index, value ){
							jQuery('#'+index).val(value);
						});	
					}
					
					if(response.color_array){
						jQuery.each( response.color_array, function( index, value ){
							jQuery('#'+index).colorpicker('setValue',value);
						});	
					}
					
					if(response.int_array){
						jQuery.each( response.int_array, function( index, value ){
							
							jQuery('#'+index).bootstrapSlider('setValue',value);
						});	
					}
					
					if(response.html){
						jQuery('.pb_customize_template_wrapper').html(response.html);
					}
					
					dap_show_create_progress_bar();
					dap_member_tiny_editor();
				}else if(response.error){
					swal("", response.error, "error"); 
					jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
				}

			}
	});		
	
}


function dapDeleteProgressBar(obj){
	var pb_id = jQuery(obj).attr('data-id');
	jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
    swal({
			title: "Are you sure you want to delete this progress bar?", 
			text: "",
			type: "warning",
			showCancelButton: true,
			confirmButtonClass: "btn-danger",
			confirmButtonText: "Yes, delete it!",
			closeOnConfirm: false,
		},
		function(){
			dap_product_show_loader();
			var ajax_url = 'ajax/manageProductsAjax.php';
		jQuery.ajax({
			url: ajax_url,
				type:'POST',
				data:{
					operation_name : 'delete_progress_bar',		
					pb_id:pb_id,
				} ,
				success: function(response){
					dap_product_hide_loader();
					var response = JSON.parse(response);
					var table = jQuery('#manage_progress_bar_table').DataTable();
					table.row(jQuery(obj).closest('tr')).remove().draw(); 
					swal("Delete!", "", "success");
					jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
				}
			  });  	
	  });
}

function pbcopyToClipboard(obj){ 
	jQuery(obj).text('Copied');
	var elementId = jQuery(obj).attr("data-id");
	var aux = document.createElement("input");
	aux.setAttribute("value", document.getElementById(elementId).innerHTML);
	document.body.appendChild(aux);
	aux.select();  
	document.execCommand("copy"); 
	document.body.removeChild(aux);
}
