jQuery(window).load(function(){
	var url1 = window.parent.location.href;
	var url2 = 'dapHome';
	var url = 'no';	
	if(url1.indexOf(url2) != -1){
		url = 'yes';	
	}	
	jQuery('.create_new_mapping').click(function(){
		jQuery('#product_plan_mapping').show();
	});
	
	jQuery('.remove_product_plan').click(function(){
		jQuery('#product_plan_mapping').hide();
	});
	
	jQuery('.save_product_plan').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var mapId = '';
		var product_id = jQuery('#all_products').val();
		var mode = jQuery('#stripe_mode').val(); 
		if(mode == 'live'){
			var stripe_plan = jQuery('#select_stripe_plan_live').val(); 
		}else{
			var stripe_plan = jQuery('#select_stripe_plan_test').val(); 
		}	
		jQuery.ajax({
			type: 'POST',
			url: '/dap/admin/ajax/dapProductPlanMappingAjax.php',
			data: {'whatRequest':'saveProductPlanMap','mapId':mapId,'product_id':product_id , 'stripe_plan':stripe_plan, 'mode':mode},
			success: function(resource) {	
				if(resource == 'product_exists'){
					swal("You already have a mapping for this product.");
				}else{
					location.reload();
				}	
			},
			complete: function(){
				
			}
		});
		if(url == 'yes'){
			jQuery('.swal-modal').css('top' , top_height);
		} 
	});
	
	jQuery('.update_product_plan_map').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var mapId = jQuery(this).attr('data-id');
		jQuery('#update_product_plan_map'+mapId).text('Saving..');
		var product_id = jQuery('#all_products_'+mapId).val();
		var mode = jQuery('#stripe_mode_'+mapId).val(); 
		if(mode == 'live'){
			var stripe_plan = jQuery('#select_stripe_plan_live_'+mapId).val(); 
		}else{
			var stripe_plan = jQuery('#select_stripe_plan_sandbox_'+mapId).val(); 
		}	
		jQuery.ajax({
			type: 'POST',
			url: '/dap/admin/ajax/dapProductPlanMappingAjax.php',
			data: {'whatRequest':'updateProductPlanMap','mapId':mapId,'product_id':product_id , 'stripe_plan':stripe_plan, 'mode':mode},
			success: function(resource) {	
				if(resource == 'product_exists'){
					jQuery('#update_product_plan_map'+mapId).text('Save');
					swal("You already have a mapping for this product.");
				}else{
					swal("Saved Successfully.");
			//		jQuery('#all_products_'+mapId).attr('disabled' , true);
			//		jQuery('#select_stripe_plan_sandbox_'+mapId).attr('disabled' , true);
			//		jQuery('#select_stripe_plan_live_'+mapId).attr('disabled' , true);
			//		jQuery('#stripe_mode_'+mapId).attr('disabled' , true);
				//	jQuery('#update_product_plan_map'+mapId).hide();
				//	jQuery('#edit_product_plan_map'+mapId).show();
					jQuery('#update_product_plan_map'+mapId).text('Save');
				}
			},
			complete: function(){
				
			}
		});
		if(url == 'yes'){
			jQuery('.swal-modal').css('top' , top_height);
		} 
	});
	
	jQuery('#stripe_plan_save').click(function(){
		var name = jQuery('#stripe_plan_name').val();
		var currency = jQuery('#stripe_plan_currency').val();
		var price = jQuery('#stripe_plan_price').val();
		var billing_interval = jQuery('#stripe_plan_billing_interval').val();
		var trial_period = jQuery('#stripe_plan_trial_period').val();
		var mode = jQuery('#stripe_mode').val();
		var key = jQuery('#stripe_'+mode+'_creds').val();
		if(key == ''){
			return false;
		}
		if(mode == 'live'){
			var checkSelect = 'select_stripe_plan_live';
		}else{
			var checkSelect = 'select_stripe_plan_test';
		}
		jQuery("#"+checkSelect+" > option").each(function() {
			if(jQuery(this).val() == name){
				swal('The plan is already there in Stripe with this name');
				jQuery('#stripePlanModal').modal('toggle');
				if(url == 'yes'){
					jQuery('.swal-modal').css('top' , top_height);
				} 
				return false;
			}
			if(jQuery(this).is('option:last-child')){
				jQuery.ajax({
					type: 'POST',
					url: '/dap/admin/ajax/dapProductPlanMappingAjax.php',
					data: {'whatRequest':'createStripePlan','name':name,'currency':currency , 'price':price , 'billing_interval':billing_interval , 'trial_period':trial_period, 'key':key},
					success: function(resource) {	
					if(mode == 'live'){
						jQuery('#select_stripe_plan_live').append('<option value="'+name+'" selected="selected">'+name+'</option>');
					}else{
						jQuery('#select_stripe_plan_test').append('<option value="'+name+'" selected="selected">'+name+'</option>');
					}
						jQuery('#stripePlanModal').modal('toggle');
					},
					complete: function(){

					}
				});
			}
		});
		
	});
	
	jQuery('.del_product_plan_map').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var id = jQuery(this).attr('data-id');
		swal({
			title: "Are you sure?",
			text: "Do you really want to delete this Mapping?",
			icon: "warning",
			buttons: true,
			dangerMode: true,
		})
		.then((willDelete) => {
			if (willDelete) {
				jQuery.ajax({
					type: 'POST',
					url: '/dap/admin/ajax/dapProductPlanMappingAjax.php',
					data: {'whatRequest':'deleteProductPlanMap','id':id},
					success: function(resource) {	
						location.reload();
					},
					complete: function(){
						
					}
				});
			}
		});
		
		if(url == 'yes'){
			jQuery('.swal-modal').css('top' , top_height);
		} 
	});
	
	jQuery('.edit_product_plan_map').click(function(){
		var id = jQuery(this).attr('data-id');
		jQuery('#all_products_'+id).attr('disabled' , false);
		jQuery('#select_stripe_plan_live_'+id).attr('disabled' , false);
		jQuery('#select_stripe_plan_sandbox_'+id).attr('disabled' , false);
		jQuery('#stripe_mode_'+id).attr('disabled' , false);
		jQuery('#update_product_plan_map'+id).show();
		jQuery('#edit_product_plan_map'+id).hide();
	});
	
	jQuery('.create_new_stripe_plan').click(function(){
		var id = jQuery('#all_products').val();
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		if(id != ''){
			jQuery.ajax({
				type: 'POST',
				url: '/dap/admin/ajax/dapProductPlanMappingAjax.php',
				data: {'whatRequest':'getDapProductDetails','id':id},
				success: function(resource) {	
					resource = JSON.parse(resource);
					jQuery('#stripe_plan_name').val(resource.name);
					jQuery('#stripe_plan_price').val(resource.price);
					jQuery('#stripe_plan_billing_interval').val(resource.billing_interval);
					jQuery('#stripe_plan_trial_period').val(resource.trial_period);
					jQuery('.billing_terms_label').text(resource.msg);
					jQuery('#create_stripe_plan_modal').trigger('click');
				},
				complete: function(){
					
				}
			});
		}else{
			swal("Please select a product.");
			if(url == 'yes'){
				jQuery('.swal-modal').css('top' , top_height);
			} 
			return false;
		}
		
	});

	
/*	jQuery('#all_products').click(function(){
		if(jQuery(this).val() != ''){
			jQuery('#select_stripe_plan_test').addClass('form_control_custom');
			jQuery('#select_stripe_plan_live').addClass('form_control_custom');
			jQuery('.create_new_stripe_plan').show();
			
		}else{
			jQuery('#select_stripe_plan_test').removeClass('form_control_custom');
			jQuery('#select_stripe_plan_live').removeClass('form_control_custom');
			jQuery('.create_new_stripe_plan').hide();
		}
	});*/
	
	
	jQuery('#stripe_mode').change(function(){
		var mode = jQuery(this).val();
		if(mode == 'live'){
			if(jQuery('#stripe_live_creds').val() == ''){
				swal('Sorry could not find Stripe Live Credentials in DAP Admin >> Setup >> Config page >> Stripe section.');
				if(url == 'yes'){
					jQuery('.swal-modal').css('top' , top_height);
				} 
				jQuery('#stripe_mode').val('sandbox');
				return false;
			}
			jQuery('#select_stripe_plan_test').hide();
			jQuery('#select_stripe_plan_live').show();
		}else{
			if(jQuery('#stripe_sandbox_creds').val() == ''){
				swal('Sorry could not find Stripe Test Credentials in SPC >> Settings Page >> Sandbox tab.');
				jQuery('#stripe_mode').val('live');
				if(url == 'yes'){
					jQuery('.swal-modal').css('top' , top_height);
				} 
				return false;
			}
			jQuery('#select_stripe_plan_live').hide();
			jQuery('#select_stripe_plan_test').show();
		}
	});
	
	jQuery('.stripe_plan_type').change(function(){
		var type = jQuery(this).val();
		var id = jQuery(this).attr('data-id');
		if(type == 'live'){
			jQuery('#select_stripe_plan_live_'+id).show();
			jQuery('#select_stripe_plan_sandbox_'+id).hide();
		}else{
			jQuery('#select_stripe_plan_live_'+id).hide();
			jQuery('#select_stripe_plan_sandbox_'+id).show();
		}
	})
	
	
	jQuery('.save_blog_path').click(function(){
		var spc_blog_path = jQuery('#spc_blog_path').val();
		jQuery(this).text('Saving..');
		jQuery.ajax({
			type: 'POST',
			url: '/dap/admin/ajax/dapProductPlanMappingAjax.php',
			data: {'whatRequest':'saveSPCBlogPath','spc_blog_path':spc_blog_path},
			success: function(resource) {	
				resource = JSON.parse(resource);
				if(resource != ''){
					swal(resource);
					jQuery('.save_blog_path').text('Save');
				}
				else{
					jQuery('.save_blog_path').text('Save');
				}
			},
			complete: function(){
				
			}
		});
	});
	
	
});
