<?php
class DAP_CourseModule{
	
	var $id;
	var $module_name;
	var $module_desc;	
	var $course_id;	 
	var $module_display_order;	 
	var $date;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getModuleName() {
		return $this->module_name;
	}
	
	function setModuleName($o) {
		$this->module_name = $o;
	}
	
	function getModuleDesc() {
		return $this->module_desc;
	}
	
	function setModuleDesc($o) {
		$this->module_desc = $o;
	}
	
	function getCourseId() {
		return $this->course_id;
	}
	
	function setCourseId($o) {
		$this->course_id = $o;
	}
	function getModuleDisplayOrder() {
		return $this->module_display_order;
	}
	
	function setModuleDisplayOrder($o) {
		$this->module_display_order = $o;
	}
	function getDate() {
		return $this->date;
	}
	
	function setDate($o) {
		$this->date = $o;
	}
 
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_course_module
						(module_name, module_desc, course_id, module_display_order, date)
					values
						(:module_name, :module_desc, :course_id, :module_display_order, now())";			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':module_name', $this->getModuleName(), PDO::PARAM_STR);
 			$stmt->bindParam(':module_desc', $this->getModuleDesc(), PDO::PARAM_STR);
			$stmt->bindParam(':course_id', $this->getCourseId(), PDO::PARAM_INT);			 	
			$stmt->bindParam(':module_display_order', $this->getModuleDisplayOrder(), PDO::PARAM_INT);			 	

			$stmt->execute();
 
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();			
			
			$sql = "update dap_course_module set
						module_name = :module_name,
						module_desc = :module_desc,
						course_id = :course_id,						
						module_display_order = :module_display_order,						
						date  = now() 
					where
						id = :id";
		 
	
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':module_name', $this->getModuleName(), PDO::PARAM_STR);
 			$stmt->bindParam(':module_desc', $this->getModuleDesc(), PDO::PARAM_STR);
			$stmt->bindParam(':course_id', $this->getCourseId(), PDO::PARAM_INT);
			$stmt->bindParam(':module_display_order', $this->getModuleDisplayOrder(), PDO::PARAM_INT);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_STR);

			$stmt->execute();		
			
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_course_module ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CourseModule(); 

				$data->setId( $row["id"] );
				$data->setModuleName( $row["module_name"] );
				$data->setModuleDesc( $row["module_desc"] );
				$data->setCourseId( $row["course_id"] ); 
				$data->setModuleDisplayOrder( $row["module_display_order"] ); 
				$data->setDate( $row["date"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
 
	//Load  
	public static function loadByCourseId($course_id) {
		$LoadList = array(); 
		$sql = "select * from dap_course_module where course_id = ".$course_id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CourseModule(); 

				$data->setId( $row["id"] );
				$data->setModuleName( $row["module_name"] );
				$data->setModuleDesc( $row["module_desc"] );
				$data->setCourseId( $row["course_id"] ); 
				$data->setModuleDisplayOrder( $row["module_display_order"] ); 
				$data->setDate( $row["date"] ); 
				$LoadList[] = $data;
			}		
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	 
	 
	//Load  
	public static function loadById($id = 0) {
		
		$sql = "select * from dap_course_module where id = ".$id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CourseModule(); 

				$data->setId( $row["id"] );
				$data->setModuleName( $row["module_name"] );
				$data->setModuleDesc( $row["module_desc"] );
				$data->setCourseId( $row["course_id"] ); 
				$data->setModuleDisplayOrder( $row["module_display_order"] ); 
				$data->setDate( $row["date"] ); 
				return   $data;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
 
  public static function deleteById($id = ''){

		$sql = "delete from `dap_course_module` where `id` =:id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_STR);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
	public static function deleteByCourseId($course_id = ''){

		$sql = "delete from `dap_course_module` where `course_id` =:course_id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':course_id', $course_id, PDO::PARAM_STR);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
	 public static function delete(){

		$sql = "delete from dap_course_module";
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
				
		} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
		}
       	 
	}  
	
	
}
