<?php
class DAP_CreditsHistory{
	
	var $id;
	var $user_id;
	var $action;
	
	var $credits_earned;
	var $credits_spent;
	var $ip;
	var $country;
	var $page_id;
	var $product_id;
	var $value;
	var $course_id;
	var $course_data;
	var $comments;
	var $timestamp;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getUserId() {
		return $this->user_id;
	}
	
	function setUserId($o) {
		$this->user_id = $o;
	}
	
	
	function getAction() {
		return $this->action;
	}
	
	function setAction($o) {
		$this->action = $o;
	}
	

	function getCreditsEarned() {
		return $this->credits_earned;
	}
	function setCreditsEarned($o) {
		$this->credits_earned = $o;
	}
	
	function getCreditsSpent() {
		return $this->credits_spent;
	}
	function setCreditsSpent($o) {
		$this->credits_spent = $o;
	}
	
	function getIp() {
		return $this->ip;
	}
	function setIp($o) {
		$this->ip = $o;
	}
	
	function getCountry() {
		return $this->country;
	}
	function setCountry($o) {
		$this->country = $o;
	}
	
	function getPageId() {
		return $this->page_id;
	}
	function setPageId($o) {
		$this->page_id = $o;
	}
	
	function getProductId() {
		return $this->product_id;
	}
	function setProductId($o) {
		$this->product_id = $o;
	}
	
	
	function getValue() {
		return $this->value;
	}
	function setValue($o) {
		$this->value = $o;
	}
	
	function getCourseId() {
		return $this->course_id;
	}
	function setCourseId($o) {
		$this->course_id = $o;
	}
	function getCourseData() {
		return $this->course_data;
	}
	function setCourseData($o) {
		$this->course_data = $o;
	}
	
	function getComments() {
		return $this->comments;
	}
	function setComments($o) {
		$this->comments = $o;
	}
	function getTimeStamp() {
		return $this->timestamp;
	}
	
	function setTimeStamp($o) {
		$this->timestamp = $o;
	}
	
	
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_credit_history
						(user_id, action, credits_earned, credits_spent,ip,country,page_id,product_id,value,comments,timestamp, course_id, course_data)
					values
						(:user_id, :action, :credits_earned, :credits_spent, :ip, :country,:page_id, :product_id, :value, :comments, :timestamp,:course_id, :course_data)";
			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':credits_earned', $this->getCreditsEarned(), PDO::PARAM_STR);
			$stmt->bindParam(':credits_spent', $this->getCreditsSpent(), PDO::PARAM_STR);
			$stmt->bindParam(':ip', $this->getIp(), PDO::PARAM_STR);
			$stmt->bindParam(':country', $this->getCountry(), PDO::PARAM_STR);
			$stmt->bindParam(':page_id', $this->getPageId(), PDO::PARAM_STR);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':course_id', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':course_data', $this->getCourseData(), PDO::PARAM_STR);
			$stmt->bindParam(':comments', $this->getComments(), PDO::PARAM_STR);
			$stmt->bindParam(':timestamp', $this->getTimeStamp(), PDO::PARAM_STR);
			

			$stmt->execute();

			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			
			
			
			
			
			$sql = "update dap_credit_history set
						user_id = :user_id,
						action = :action,
						credits_earned = :credits_earned,
						credits_spent = :credits_spent,
						ip = :ip,
						country = :country,
						page_id = :page_id,
						product_id = :product_id,
						value = :value,
						comments = :comments,
						timestamp = :timestamp,
					where
						id = :id";
		 
	
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':credits_earned', $this->getCreditsEarned(), PDO::PARAM_STR);
			$stmt->bindParam(':credits_spent', $this->getCreditsSpent(), PDO::PARAM_STR);
			$stmt->bindParam(':ip', $this->getIp(), PDO::PARAM_STR);
			$stmt->bindParam(':country', $this->getCountry(), PDO::PARAM_STR);
			$stmt->bindParam(':page_id', $this->getPageId(), PDO::PARAM_STR);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':course_id', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':course_data', $this->getCourseData(), PDO::PARAM_STR);
			$stmt->bindParam(':comments', $this->getComments(), PDO::PARAM_STR);
			$stmt->bindParam(':timestamp', $this->getTimeStamp(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_STR);

			$stmt->execute();
			
			
			
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_credit_history ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setCreditsEarned( $row["credits_earned"] );
				$data->setCreditsSpent( $row["credits_spent"] ); 
				$data->setIp( $row["ip"] ); 
				$data->setCountry( $row["country"] ); 
				$data->setPageId( $row["page_id"] ); 
				$data->setProductId( $row["product_id"] ); 
				$data->setValue( $row["value"] ); 
				$data->setCourseId( $row["course_id"] ); 
				$data->setCourseData( $row["course_data"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setTimeStamp( $row["timestamp"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
    
    function loadAllUser(){
		
		//$sql = "select DISTINCT t1.id,t1.email,t1.credits_available,t3.credits_earned,t3.credits_spent,t3.product_id,sum(t2.credits_spent) as total_spent,sum(t2.credits_earned) as total_earned from dap_users as t1 join dap_users_credits as t2 on t1.id = t2.user_id  join dap_credit_history as t3 on t2.user_id=t3.user_id group by t2.user_id";
		//$sql = "select t1.id as id,t1.email,t1.credits_available,sum(t2.credits_spent) as total_spent,sum(t2.credits_earned) as total_earned from dap_users as t1 join dap_users_credits as t2 on t1.id = t2.user_id group by t2.user_id having id in (select user_id from dap_credit_history ) order by t1.id desc";
		
		$sql ="select t3.id,t3.timestamp as time,t1.id as id,t1.first_name,t1.last_name,t1.email,t1.credits_available,sum(t2.credits_spent) as total_spent from dap_users as t1 left join dap_users_credits as t2 on t1.id = t2.user_id  join (SELECT t1.* FROM dap_credit_history t1 JOIN (SELECT user_id, MAX(timestamp) timestamp FROM dap_credit_history GROUP BY user_id) t2   ON t1.user_id = t2.user_id AND t1.timestamp = t2.timestamp )  t3 on t3.user_id = t1.id group by t1.id  ORDER BY t3.timestamp desc";
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$LoadList[] = $row;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	
	function loadAllUsersInDap(){ 
		
		//$sql = "select DISTINCT t1.id,t1.email,t1.credits_available,t3.credits_earned,t3.credits_spent,t3.product_id,sum(t2.credits_spent) as total_spent,sum(t2.credits_earned) as total_earned from dap_users as t1 join dap_users_credits as t2 on t1.id = t2.user_id  join dap_credit_history as t3 on t2.user_id=t3.user_id group by t2.user_id";
		//$sql = "select t1.id as id,t1.email,t1.credits_available,sum(t2.credits_spent) as total_spent,sum(t2.credits_earned) as total_earned from dap_users as t1 join dap_users_credits as t2 on t1.id = t2.user_id group by t2.user_id ";
		
		//$sql = "select t1.id as id,t1.email,t1.credits_available,sum(t2.credits_spent) as total_spent,sum(t2.credits_earned) as total_earned from dap_users as t1 left join dap_users_credits as t2 on t1.id = t2.user_id group by t1.id order by t1.id desc";
        
        
        $sql = "select t2.datetime as time,t1.first_name,t1.last_name,t1.id as  id,t1.email,t1.credits_available,sum(t2.credits_spent) as total_spent,sum(t2.credits_earned) as total_earned from dap_users as t1 left join dap_users_credits as t2 on t1.id = t2.user_id    group by t1.id order by t1.last_update_date desc";
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$LoadList[] = $row;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	//Load  
	public static function loadByUserId($user_id = 0) {
		$LoadList = array(); 
		$sql = "select * from dap_credit_history where user_id = ".$user_id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setCreditsEarned( $row["credits_earned"] );
				$data->setCreditsSpent( $row["credits_spent"] ); 
				$data->setIp( $row["ip"] ); 
				$data->setCountry( $row["country"] ); 
				$data->setPageId( $row["page_id"] ); 
				$data->setProductId( $row["product_id"] ); 
				$data->setValue( $row["value"] ); 
				$data->setCourseId( $row["course_id"] ); 
				$data->setCourseData( $row["course_data"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setTimeStamp( $row["timestamp"] ); 
				$LoadList[] =  $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	
	//Load  
	public static function loadByUserIdEarnCredits($user_id = 0) {
		$LoadList = array(); 
		$sql = "select * from dap_credit_history where action !='redeemed_product' and action != 'redeemed_resource' and user_id = ".$user_id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setCreditsEarned( $row["credits_earned"] );
				$data->setCreditsSpent( $row["credits_spent"] ); 
				$data->setIp( $row["ip"] ); 
				$data->setCountry( $row["country"] ); 
				$data->setPageId( $row["page_id"] ); 
				$data->setProductId( $row["product_id"] ); 
				$data->setValue( $row["value"] ); 
				$data->setCourseId( $row["course_id"] ); 
				$data->setCourseData( $row["course_data"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setTimeStamp( $row["timestamp"] ); 
				$LoadList[] =  $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	//Load  
	public static function loadById($id = 0) {
		
		$sql = "select * from dap_credit_history where id = ".$id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setCreditsEarned( $row["credits_earned"] );
				$data->setCreditsSpent( $row["credits_spent"] ); 
				$data->setIp( $row["ip"] ); 
				$data->setCountry( $row["country"] ); 
				$data->setPageId( $row["page_id"] ); 
				$data->setProductId( $row["product_id"] ); 
				$data->setValue( $row["value"] );
				$data->setCourseId( $row["course_id"] ); 
				$data->setCourseData( $row["course_data"] );  
				$data->setComments( $row["comments"] ); 
				$data->setTimeStamp( $row["timestamp"] ); 
				return   $data;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	 
	public static function loadByUserIdAndActionTypeAndStartDateAndEndDate($user_id = 0,$action_type = '',$start_date='',$end_date='') {
		$LoadList = array(); 
		$sql = "select * from dap_credit_history where action = '".$action_type."' and user_id = ".$user_id;	
		
		if($action_type == "product_resources_redeem"){
			$sql = "select * from dap_credit_history where (action = 'redeemed_resource' or action='redeemed_product') and user_id = ".$user_id;	
		}
			 
        if($start_date != ''){
			$sql .= " and timestamp	>= '".$start_date."'"; 
		}
		
		 if($end_date != ''){
			$sql .= " and timestamp	<= '".$end_date."'"; 
		}
      
	   try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setCreditsEarned( $row["credits_earned"] );
				$data->setCreditsSpent( $row["credits_spent"] ); 
				$data->setIp( $row["ip"] ); 
				$data->setCountry( $row["country"] ); 
				$data->setPageId( $row["page_id"] ); 
				$data->setProductId( $row["product_id"] ); 
				$data->setValue( $row["value"] ); 
				$data->setCourseId( $row["course_id"] ); 
				$data->setCourseData( $row["course_data"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setTimeStamp( $row["timestamp"] ); 
				$LoadList[] =  $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
		
	public static function loadByActionTypeAndStartDateAndEndDate($action_type,$start_date,$end_date , $limit, $groupBy = 'user_id', $userId = 0){
		
		$userIds = DAP_LeaderboadDisabledUsers::loadAllUser();
		
		$userIds = implode(',' , $userIds);
		
		$LoadList = array(); 
		
		//$sql = "select user_id, SUM(credits_earned) as earned from dap_credit_history where action = '".$action_type."'";	
		$sql = "select t1.user_id, t2.id, SUM(credits_earned) as earned, action, timestamp from dap_credit_history as t1 JOIN dap_users as t2 ON t1.user_id = t2.id  where t1.user_id = t2.id  AND  action IN ('".$action_type."')";	
		
		if($action_type == "product_resources_redeem"){
			$sql = "select t1.user_id, t2.id, SUM(credits_earned) as earned  from dap_credit_history as t1 JOIN dap_users as t2 ON t1.user_id = t2.id where t1.user_id = t2.id AND (action = 'redeemed_resource' or action='redeemed_product')  ";	
		}
		
		if($userIds != ''){
			$sql .=" AND user_id NOT IN($userIds)"	;
		}
			 
        if($start_date != ''){
			$sql .= " and timestamp	>= '".$start_date."'"; 
		}
		
		if($end_date != ''){
			$sql .= " and timestamp	<= '".$end_date."'"; 
		}
		
		if($userId != 0){
			$sql .= " and user_id = '".$userId."'";
		}
		
		if($groupBy == 'user_id'){
			$sql .= ' GROUP BY user_id';
			$sql .= ' ORDER BY earned DESC';
		
			$sql .= ' LIMIT '.$limit;
		}
		
	   try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 
				$data->setUserId( $row["user_id"] );
				$data->setCreditsEarned( $row["earned"] );
				$data->setTimeStamp( $row["timestamp"] );
				$LoadList[] =  $data;
			}
			
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadUsersCoursesPoints($action_type,$start_date,$end_date , $limit, $courses, $groupBy = 'user_id', $userId = 0 ){
		
		$userIds = DAP_LeaderboadDisabledUsers::loadAllUser();
		
		$userIds = implode(',' , $userIds);
		
		$LoadList = array(); 
		
		//$sql = "select user_id, SUM(credits_earned) as earned from dap_credit_history where action = '".$action_type."'";	
		$sql = "select t1.user_id, t2.id, SUM(credits_earned) as earned, action, timestamp from dap_credit_history as t1 JOIN dap_users as t2 ON t1.user_id = t2.id  where t1.user_id = t2.id  AND  action IN (".$action_type.")";	
		
		if($userIds != ''){
			$sql .=" AND user_id NOT IN($userIds)"	;
		}
		
		if($courses != ''){
			$sql .=" AND course_id IN($courses)"	;	
		}
			 
        if($start_date != ''){
			$sql .= " and timestamp	>= '".$start_date."'"; 
		}
		
		if($end_date != ''){
			$sql .= " and timestamp	<= '".$end_date."'"; 
		}
		
		if($userId != 0){
			$sql .= " and user_id = '".$userId."'";
		}
		
		if($groupBy == 'user_id'){
			$sql .= ' GROUP BY user_id';
			$sql .= ' ORDER BY earned DESC';
		
			$sql .= ' LIMIT '.$limit;
		}
		
				
	
	   try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsHistory(); 
				$data->setUserId( $row["user_id"] );
				$data->setCreditsEarned( $row["earned"] );
				$data->setTimeStamp( $row["timestamp"] );
				$LoadList[] =  $data;
			}
			
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadByActionTypeAndStartDateAndEndDateAndUserId($action_type = '',$start_date = '',$end_date = '',$user_id = 0 ){
	
		$sql = "select * from dap_credit_history where action = '".$action_type."'";	
		
		if($action_type == "product_resources_redeem"){
			$sql = "select * from dap_credit_history where (action = 'redeemed_resource' or action='redeemed_product') ";	
		}
			 
        if($start_date != ''){
			$sql .= " and timestamp	>= '".$start_date."'"; 
		}
		
		 if($end_date != ''){
			$sql .= " and timestamp	<= '".$end_date."'"; 
		}
			 
       
		
		if($user_id != 0 && $user_id != ''){
			
			$sql .= " and user_id	= '".$user_id."'"; 
		}
		 
		//logToFile("sql: SQL EXCEPTION: " . $sql, LOG_DEBUG_DAP);
       $LoadList = array(); 
	   try{
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while($row = $stmt->fetch()){
				$data = new DAP_CreditsHistory(); 
				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setCreditsEarned( $row["credits_earned"] );
				$data->setCreditsSpent( $row["credits_spent"] ); 
				$data->setIp( $row["ip"] ); 
				$data->setCountry( $row["country"] ); 
				$data->setPageId( $row["page_id"] ); 
				$data->setProductId( $row["product_id"] ); 
				$data->setValue( $row["value"] );
				$data->setCourseId( $row["course_id"] ); 
				$data->setCourseData( $row["course_data"] );  
				$data->setComments( $row["comments"] ); 
				$data->setTimeStamp( $row["timestamp"] ); 
				$LoadList[] =  $data;
			}
			
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
    public static function deleteByActionTypeAndTimestamp($action_type = '',$timestamp = ''){

		$sql = "delete from dap_credit_history where `action` =:action and `timestamp`	<= :timestamp ";
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action_type, PDO::PARAM_STR);
			$stmt->bindParam(':timestamp', $timestamp, PDO::PARAM_STR);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
				
		} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
		}
       	 
	}  
	
	public static function deleteByActionType($action_type = ''){

		$sql = "delete from `dap_credit_history` where `action` =:action";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action_type, PDO::PARAM_STR);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
	 public static function deleteByUserId($user_id = 0){

		$sql = "delete from dap_credit_history where `user_id` =:user_id";
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
				
		} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
		}
       	 
	}  
	
	public static function dapGetUsersCreditsByUserID($user_id){
		
		$sql ="SELECT sum(credits_earned) as total_earned FROM dap_credit_history WHERE `user_id` = ".$user_id." GROUP BY user_id ORDER BY timestamp desc";
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			if($row = $stmt->fetch()) {
				return $row;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		
		
	}
	
	
}
