<?php
class DAP_UserCourseProgress{
	
	var $id;
	var $user_id;
	var $product_id;	
	var $module_id;	 
	var $unit_id;	 
	var $completed;	 
	var $date;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getUserId() {
		return $this->user_id;
	}
	
	function setUserId($o) {
		$this->user_id = $o;
	}
	
	function getProductId() {
		return $this->product_id;
	}
	
	function setProductId($o) {
		$this->product_id = $o;
	}
	
	function getModuleId() {
		return $this->module_id;
	}
	
	function setModuleId($o) {
		$this->module_id = $o;
	}
	
	
	function getUnitId() {
		return $this->unit_id;
	}
	
	function setUnitId($o) {
		$this->unit_id = $o;
	}
	
	
	function getCompleted() {
		return $this->completed;
	}
	
	function setCompleted($o) {
		$this->completed = $o;
	}
 
	function getDate() {
		return $this->date;
	}
	
	function setDate($o) {
		$this->date = $o;
	}
 
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_user_course_progress
						(user_id, product_id, module_id, unit_id, completed, date)
					values
						(:user_id, :product_id, :module_id, :unit_id, :completed, now())";			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_INT);
 			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
			$stmt->bindParam(':module_id', $this->getModuleId(), PDO::PARAM_INT);
			$stmt->bindParam(':unit_id', $this->getUnitId(), PDO::PARAM_INT);
			$stmt->bindParam(':completed', $this->getCompleted(), PDO::PARAM_STR);
			 
			$stmt->execute();

			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();			
			
			$sql = "update dap_user_course_progress set
						user_id = :user_id,
						product_id = :product_id,
						module_id = :module_id,
						unit_id = :unit_id,
						completed = :completed,						
						date  = now() 
					where
						id = :id";
		 
	
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_INT);
 			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
			$stmt->bindParam(':module_id', $this->getModuleId(), PDO::PARAM_INT);
			$stmt->bindParam(':unit_id', $this->getUnitId(), PDO::PARAM_INT);
			$stmt->bindParam(':completed', $this->getCompleted(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);	
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);

			$stmt->execute();		
			
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	 public static function getCourseProgressDetailsByUserIdAndProductId($userId =0,$productId=0){ 
		
		$output = array();
		try {
			$dap_dbh = Dap_Connection::getConnection(); 

			$sql = "select * from dap_user_course_progress as ucp		
					where
						ucp.user_id = :userId and
						ucp.product_id = :productId 
					";

			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			
			$stmt->execute();
            $output = array();
			while($row = $stmt->fetch()){
				$dataFound = true;
				$output[] =$row;
			}
            $stmt = null;
			$dap_dbh = null;
			return $output;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}   
	
	
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_user_course_progress ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCourseProgress(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setProductId( $row["product_id"] );
				$data->setModuleId( $row["module_id"] ); 
				$data->setUnitId( $row["unit_id"] ); 
				$data->setCompleted( $row["completed"] ); 
				$data->setDate( $row["date"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
 
	
	 
	 
	//Load  
	public static function loadById($id = 0) {
		
		$sql = "select * from dap_user_course_progress where id = ".$id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCourseProgress(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setProductId( $row["product_id"] );
				$data->setModuleId( $row["module_id"] ); 
				$data->setUnitId( $row["unit_id"] ); 
				$data->setCompleted( $row["completed"] ); 
				$data->setDate( $row["date"] );
				return   $data;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadByCourseId($product_id = 0) {
		
		$sql = "select * from dap_user_course_progress where product_id = ".$product_id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCourseProgress(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setProductId( $row["product_id"] );
				$data->setModuleId( $row["module_id"] ); 
				$data->setUnitId( $row["unit_id"] ); 
				$data->setCompleted( $row["completed"] ); 
				$data->setDate( $row["date"] );
				return   $data;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	public static function loadByModuleId($module_id = 0) {
		
		$sql = "select * from dap_user_course_progress where module_id = ".$module_id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCourseProgress(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setProductId( $row["product_id"] );
				$data->setModuleId( $row["module_id"] ); 
				$data->setUnitId( $row["unit_id"] ); 
				$data->setCompleted( $row["completed"] ); 
				$data->setDate( $row["date"] );
				return   $data;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
  
	public static function loadByCourseIdModuleIdlessonIduserId($product_id= 0 , $module_id = 0, $unit_id = 0, $user_id =0) {
	  
	   $data = null;
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "select * from dap_user_course_progress  						
					where
						product_id = :product_id AND
						module_id = :module_id AND
						unit_id = :unit_id AND
						user_id = :user_id 						
					";
					
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_INT);
			$stmt->bindParam(':unit_id', $unit_id, PDO::PARAM_INT);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);		
			 
			$stmt->execute();

			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$data = new DAP_UserCourseProgress(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setProductId( $row["product_id"] );
				$data->setModuleId( $row["module_id"] ); 
				$data->setUnitId( $row["unit_id"] ); 
				$data->setCompleted( $row["completed"] ); 
				$data->setDate( $row["date"] );
				 
				
			}
			$stmt = null;
			$dap_dbh = null;
			return $data;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
  
	public static function loadByCourseIdlessonIduserId($product_id= 0 , $unit_id = 0, $user_id =0) {
	  
	   $data = null;
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "select * from dap_user_course_progress  						
					where
						product_id = :product_id AND						 
						unit_id = :unit_id AND
						user_id = :user_id 						
					";
					
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			$stmt->bindParam(':unit_id', $unit_id, PDO::PARAM_INT);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);		
			 
			$stmt->execute();

			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$data = new DAP_UserCourseProgress(); 

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setProductId( $row["product_id"] );
				$data->setModuleId( $row["module_id"] ); 
				$data->setUnitId( $row["unit_id"] ); 
				$data->setCompleted( $row["completed"] ); 
				$data->setDate( $row["date"] );
				 
				
			}
			$stmt = null;
			$dap_dbh = null;
			return $data;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
  
  
  function lessonCountByCourseIduserId($product_id= 0 , $user_id =0) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
 
			//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							count(*) as count
						from
						dap_user_course_progress  
					where
						product_id = :product_id AND						 
						user_id = :user_id 		
					
						";						
						
					 
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
				$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);	
				$stmt->execute();
		
				if ($row = $stmt->fetch()) {
					$count = $row["count"];
				}
				 			 
			//return $displayHTML;
			return $count;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function lessonDetailsByCourseIduserId($product_id= 0 , $user_id =0) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$data = array();
			//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							*
						from
						dap_user_course_progress  
					where
						product_id = :product_id AND						 
						user_id = :user_id 		
					
						";						
						
					 
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
				$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);	
				$stmt->execute();
		
				while ($row = $stmt->fetch()) {
					$data[] = $row['unit_id'];
				}
				 			 
			//return $displayHTML;
			return $data;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
 function lessonDetailsByCourseIdModuleIduserId($product_id= 0 , $module_id =0, $user_id =0) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$data = array();
			//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							*
						from
						dap_user_course_progress  
					where
						product_id = :product_id AND						 
						module_id = :module_id AND						 
						user_id = :user_id 		
					
						";						
						
					 
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
				$stmt->bindParam(':module_id', $module_id, PDO::PARAM_INT);	
				$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);	
				$stmt->execute();
		
				while ($row = $stmt->fetch()) {
					$data[] = $row['unit_id'];
				}
				 			 
			//return $displayHTML;
			return $data;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function lessonCountByCourseIdModuleIduserId($product_id= 0 , $module_id = 0, $user_id =0) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
 
			//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							count(*) as count
						from
						dap_user_course_progress  
					where
						product_id = :product_id AND
						module_id = :module_id AND
						user_id = :user_id 		
					
						";						
						
					 
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
				$stmt->bindParam(':module_id', $module_id, PDO::PARAM_INT);
				$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);	
				$stmt->execute();
		
				if ($row = $stmt->fetch()) {
					$count = $row["count"];
				}
				 			 
			//return $displayHTML;
			return $count;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	public static function deleteByModuleId($module_id = ''){

		$sql = "delete from `dap_user_course_progress` where `module_id` =:module_id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_STR);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
	public static function deleteByUserIdAndProductId($user_id = 0,$product_id = 0){

		$sql = "delete from `dap_user_course_progress` where `user_id` =:user_id and `product_id` =:product_id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	return false;
	}
	
	 public static function delete(){

		$sql = "delete from dap_user_course_progress";
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			return true;
	    } catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
				
		} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
		}
       	 
	}  
	
	
}
