<?php
class DAP_UsersBadges{
	
	var $id;
	var $userid;
	var $badge_id;
	var $date;
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getUserId() {
		return $this->userid;
	}	
	function setUserId($o) {
		$this->userid = $o;
	}	
	
	function getBadgeId() {
		return $this->badge_id;
	}	
	function setBadgeId($o) {
		$this->badge_id = $o;
	}
	
	function getDate() {
		return $this->date;
	}	
	function setDate($o) {
		$this->date = $o;
	}	 
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			 $sql = "insert into dap_users_badge
						(userid, badge_id)
					values
						(:userid, :badge_id)";
			
			//logToFile("DAP_UserCreditsLimit. php create(): sql=".$sql,LOG_DEBUG_DAP); 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userid', $this->getUserId(), PDO::PARAM_STR);
 			$stmt->bindParam(':badge_id', $this->getBadgeId(), PDO::PARAM_STR);
		
			$stmt->execute();
			$last_insert_id = $dap_dbh->lastInsertId();
			 
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;	

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadByUserIdAndBadgeId($userid, $badge_id) {				 
	
	
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "select * from dap_users_badge where userid=:userid and badge_id=:badge_id";	
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userid', $userid, PDO::PARAM_STR);
			$stmt->bindParam(':badge_id', $badge_id, PDO::PARAM_STR);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UsersBadges();

				$data->setId( $row["id"] );
				$data->setUserId( $row["userid"] );
				$data->setBadgeId( $row["badge_id"] );
				$data->setDate( $row["date"] );
				return $data;
			}

		 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadByUserId($userid) {				 
	
	
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "select * from dap_users_badge where userid=:userid";	
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userid', $userid, PDO::PARAM_STR);
			$stmt->execute();
			$allData = array();
			while ($row = $stmt->fetch()) {
				$data = new DAP_UsersBadges();

				$data->setId( $row["id"] );
				$data->setUserId( $row["userid"] );
				$data->setBadgeId( $row["badge_id"] );
				$data->setDate( $row["date"] );
				$allData[] = $data;
			}
			return $allData;
		 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
}
