<?php
class DAP_UsersProductsFailedPayments{
	var $id;
	var $user_id;
	var $product_id;	
	var $payment_processor;	 
	var $transaction_type;	 
	var $reason;
	var $action;
	var $transaction_date;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getUserId() {
		return $this->user_id;
	}
	
	function setUserId($o) {
		$this->user_id = $o;
	}
	
	function getProductId() {
		return $this->product_id;
	}
	
	function setProductId($o) {
		$this->product_id = $o;
	}
	
	function getPaymentProcessor() {
		return $this->payment_processor;
	}
	
	function setPaymentProcessor($o) {
		$this->payment_processor = $o;
	}
	
	function getTransactionType() {
		return $this->transaction_type;
	}
	
	function setTransactionType($o) {
		$this->transaction_type = $o;
	}
	
	function getReason() {
		return $this->reason;
	}
	
	function setReason($o) {
		$this->reason = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	
	function setAction($o) {
		$this->action = $o;
	}
	
	function getTransactionDate() {
		return $this->transaction_date;
	}
	
	function setTransactionDate($o) {
		$this->transaction_date = $o;
	}
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_users_products_failed_payments
						(user_id, product_id, payment_processor, transaction_type, reason, action)
					values
						(:user_id, :product_id, :payment_processor, :transaction_type, :reason, :action)";			
		 	
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_INT);
 			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
			$stmt->bindParam(':payment_processor', $this->getPaymentProcessor(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':transaction_type', $this->getTransactionType(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':reason', $this->getReason(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);		
		//	$stmt->bindParam(':transaction_date', $this->getTransactionDate(), PDO::PARAM_STR);			 	

			$stmt->execute();
 
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	
	public static function load() {
		$dap_dbh = Dap_Connection::getConnection();

		$sql = "select *
			from
				dap_users_products_failed_payments" ;
		
		logToFile("load: ENTER", LOG_DEBUG_DAP);
		
		try {
			
		$stmt = $dap_dbh->prepare($sql);
		
		$stmt->execute();
		
		//$row = $stmt->fetch(PDO::FETCH_ASSOC);
		$userFailedArray = array();
		while ($row = $stmt->fetch()) {
			$userFailed = new DAP_UsersProductsFailedPayments();
			$userFailed->setUserId( $row["user_id"] );
			$userFailed->setProductId($row["product_id"]);
			$userFailed->setPaymentProcessor($row["payment_processor"]);
			$userFailed->setTransactionType($row["transaction_type"]);
			$userFailed->setReason($row["reason"]);
			$userFailed->setAction( $row["action"] );
			$userFailed->setTransactionDate( $row["transaction_date"] );
			$userFailedArray[] = $userFailed;
		}
		
		return $userFailedArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

		return;
	}

    
    public static function loadByFilter($userIdFilter, $productIdFilter, $startDateFilter, $endDateFilter, $paymentProcessorFilter) {
		$whereQuery = 'where ';
		$whereAnd = '';
		
		if($userIdFilter != ''){
			$whereQuery .= $whereAnd.' user_id=:userIdFilter ';
			$whereAnd =' AND'; 
		}
		
		if($productIdFilter != ''){
			$whereQuery .= $whereAnd.' product_id=:productIdFilter ';
			$whereAnd =' AND'; 
		}
		
		if($startDateFilter != ''){
			$whereQuery .= $whereAnd.' transaction_date >=:startDateFilter ';
			$whereAnd =' AND'; 
		}
		
		if($endDateFilter != ''){
			$whereQuery .= $whereAnd.' transaction_date <=:endDateFilter ';
			$whereAnd =' AND'; 
		}
		
		if($paymentProcessorFilter != ''){
			$whereQuery .= $whereAnd.' payment_processor LIKE :paymentProcessorFilter ';
			$whereAnd =' AND'; 
		}
		
		
		$dap_dbh = Dap_Connection::getConnection();

		$sql = "select *
			from
				dap_users_products_failed_payments $whereQuery" ;
		
		
		
		try {
			
		$stmt = $dap_dbh->prepare($sql);
		if($userIdFilter != ''){
			$stmt->bindParam(':userIdFilter', $userIdFilter, PDO::PARAM_INT);
		}
		if($productIdFilter != ''){
			$stmt->bindParam(':productIdFilter', $productIdFilter, PDO::PARAM_INT);
		}
		if($startDateFilter != ''){
			$stmt->bindParam(':startDateFilter', $startDateFilter, PDO::PARAM_STR);
		}
		
		if($endDateFilter != ''){
			$stmt->bindParam(':endDateFilter', $endDateFilter, PDO::PARAM_STR);
		}
		
		if($paymentProcessorFilter != ''){
			$paymentProcessorFilter = '%'.$paymentProcessorFilter.'%';
			$stmt->bindParam(':paymentProcessorFilter', $paymentProcessorFilter, PDO::PARAM_STR);
		}
		
		
		
		$stmt->execute();
		
		//$row = $stmt->fetch(PDO::FETCH_ASSOC);
		$userFailedArray = array();
		while ($row = $stmt->fetch()) {
			$userFailed = new DAP_UsersProductsFailedPayments();
			$userFailed->setUserId( $row["user_id"] );
			$userFailed->setProductId($row["product_id"]);
			$userFailed->setPaymentProcessor($row["payment_processor"]);
			$userFailed->setTransactionType($row["transaction_type"]);
			$userFailed->setReason($row["reason"]);
			$userFailed->setAction( $row["action"] );
			$userFailed->setTransactionDate( $row["transaction_date"] );
			$userFailedArray[] = $userFailed;
		}
		
		return $userFailedArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

		return;
	}

	
	
	
}
