<?php

class Dap_BulkEmail extends Dap_Resource {

	public static function bulkEmailInsert($actionType,$payload,$schedule_type=1,$schedule_date=NULL,$schedule_timezone=NULL) {
		//  SEQ/BE-COLLECTIONCODE/SUBJECT||BODY||ATTACHMENTS(multiple attachments separated by commas)
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
			//Insert into dap_mass_actions

			$sql = "insert into dap_mass_actions
						(actionType, actionKey, payload, status,schedule_type,schedule_date,schedule_timezone)
						values
						(:actionType, :key, :payload, 'NEW',:schedule_type,:schedule_date,:schedule_timezone)";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
			$stmt->bindParam(':key', $key, PDO::PARAM_STR);
			$stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
			$stmt->bindParam(':schedule_type', $schedule_type, PDO::PARAM_INT);
			$stmt->bindParam(':schedule_date', $schedule_date, PDO::PARAM_STR);
			$stmt->bindParam(':schedule_timezone', $schedule_timezone, PDO::PARAM_STR);
			
			
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			return $key;
		} catch (PDOException $e) {
			logToFile("bulkEmailInsertCollectionCode: " . $e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("bulkEmailInsertCollectionCode: " . $e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}


	public static function bulkEmailInsertXP($actionType,$payload,$schedule_type=1,$schedule_date=NULL,$schedule_timezone=NULL) {
		//  SEQ/BE-COLLECTIONCODE/SUBJECT||BODY||ATTACHMENTS(multiple attachments separated by commas)
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
			//Insert into dap_mass_actions

			$sql = "insert into dap_mass_actions
						(actionType, actionKey, payload, status,schedule_type,schedule_date,schedule_timezone)
						values
						(:actionType, :key, :payload, 'NEW',:schedule_type,:schedule_date,:schedule_timezone)";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
			$stmt->bindParam(':key', $key, PDO::PARAM_STR);
			$stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
			$stmt->bindParam(':schedule_type', $schedule_type, PDO::PARAM_INT);
			$stmt->bindParam(':schedule_date', $schedule_date, PDO::PARAM_STR);
			$stmt->bindParam(':schedule_timezone', $schedule_timezone, PDO::PARAM_STR);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			return $key;
		} catch (PDOException $e) {
			logToFile("bulkEmailInsertXP: " . $e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("bulkEmailInsertXP: " . $e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

}
?>
