<?php 

class Dap_EmailBroadcasts{
	
	var $id;
	var $tracking_id;
	var $subject;
	var $plain_message;
	var $html_message;
	var $payload;
	var $payload1;
	var $email_group;
	var $broadcast_name;
	var $date_sent;
	
	function getDate_sent()  {
	   return $this->date_sent;
	}
	function setDate_sent($o) {
	  $this->date_sent = $o;
	}
	
	function getBroadcast_name()  {
	   return $this->broadcast_name;
	}
	function setBroadcast_name($o) {
	  $this->broadcast_name = $o;
	}
	
	function getHTML_message()  {
	   return $this->html_message;
	}
	function setHTML_message($o) {
	  $this->html_message = $o;
	}
	
	function getPayload()  {
	   return $this->payload;
	}
	function setPayload($o) {
	  $this->payload = $o;
	}
	
	function getPayload1()  {
	   return $this->payload1;
	}
	function setPayload1($o) {
	  $this->payload1 = $o;
	}
	
	function getEmail_group()  { 
	   return $this->email_group;
	}
	function setEmail_group($o) {
	  $this->email_group = $o;
	}
	
	function getSubject()  {
	   return $this->subject;
	}
	function setSubject($o) {
	  $this->subject = $o;
	}
	
	function getPlain_message()  {
	   return $this->plain_message;
	}
	function setPlain_message($o) {
	  $this->plain_message = $o;
	}
	
	function getId()  {
	   return $this->id;
	}
	function setId($o) {
	  $this->id = $o;
	}
	
	function getTracking_id()  {
	   return $this->tracking_id;
	}
	function setTracking_id($o) {
	  $this->tracking_id = $o;
	}
	
	public function create(){
		try {
			$dap_dbh = Dap_Connection::getConnection(); 
		 
			$sql = "INSERT INTO
					dap_email_broadcasts
						(tracking_id, subject, message ,payload,payload1,email_group,last_updated,broadcast_name,date_sent)
					VALUES
						(:tracking_id, :subject, :message, :payload, :payload1, :email_group,'".date("Y-m-d h:i:s")."',:broadcast_name, :date_sent)";

			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':tracking_id', $this->getTracking_id(), PDO::PARAM_INT);
			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);
			
			if($this->getPlain_message() != "")
				$stmt->bindParam(':message', $this->getPlain_message(), PDO::PARAM_STR);
			else
				$stmt->bindParam(':message', $this->getHTML_message(), PDO::PARAM_STR);
			
			$stmt->bindParam(':payload', $this->getPayload(), PDO::PARAM_STR);
			$stmt->bindParam(':payload1', $this->getPayload1(), PDO::PARAM_STR);
			$stmt->bindParam(':email_group', $this->getEmail_group(), PDO::PARAM_STR);
			$stmt->bindParam(':broadcast_name', $this->getBroadcast_name(), PDO::PARAM_STR);
			$stmt->bindParam(':date_sent', $this->getDate_sent(), PDO::PARAM_STR);
			
			$stmt->execute();

			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:create()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:create()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function checkIfBroadcastExists($id){
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT id FROM dap_email_broadcasts WHERE id = $id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return true;
			}
			$stmt = null;
			$dap_dbh = null;
			return false;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:checkIfBroadcastExists()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:checkIfBroadcastExists()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function checkIfBroadcastNameExists($name){
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT id FROM dap_email_broadcasts WHERE broadcast_name = '$name'";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return true;
			}
			$stmt = null;
			$dap_dbh = null;
			return false;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:checkIfBroadcastExists()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:checkIfBroadcastExists()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function load(){
		$data = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT * FROM dap_email_broadcasts ORDER BY id desc";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] = $row;
			}
			$stmt = null;
			$dap_dbh = null;
			return $data;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:load()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:load()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function deleteBroadcast($id){
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "DELETE FROM dap_email_broadcasts WHERE id IN($id)";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			$stmt = null;
			$dap_dbh = null;
		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:deleteBroadcast()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:deleteBroadcast()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadBroadcastById($id){
		$data = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT * FROM dap_email_broadcasts WHERE id = '".$id."'";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return $row;
			}
			$stmt = null;
			$dap_dbh = null;
			return $data;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:loadBroadcastById()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:loadBroadcastById()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public function update(){
		logToFile("Dap_EmailBroadcasts.class:update()",LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "UPDATE dap_email_broadcasts SET last_updated = '".date("Y-m-d h:i:s")."',subject=:subject,message=:message,payload=:payload,payload1=:payload1,email_group=:email_group,broadcast_name=:broadcast_name";
			
			if($this->getTracking_id() != "")
				$sql .= ",tracking_id=:tracking_id";
			
			if($this->getDate_sent() != "")
				$sql .= ",date_sent=:date_sent";
			
			$sql .= " WHERE id = :id";
			

			$stmt = $dap_dbh->prepare($sql);
			
			if($this->getTracking_id() != "")
				$stmt->bindParam(':tracking_id', $this->getTracking_id(), PDO::PARAM_INT);
				
			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);
			
			
			if($this->getPlain_message() != "")
				$stmt->bindParam(':message', $this->getPlain_message(), PDO::PARAM_STR);
			else
				$stmt->bindParam(':message', $this->getHTML_message(), PDO::PARAM_STR);
			
			
			$stmt->bindParam(':payload', $this->getPayload(), PDO::PARAM_STR);
			$stmt->bindParam(':payload1', $this->getPayload1(), PDO::PARAM_STR);
			$stmt->bindParam(':email_group', $this->getEmail_group(), PDO::PARAM_STR);
			$stmt->bindParam(':broadcast_name', $this->getBroadcast_name(), PDO::PARAM_STR);
			
			if($this->getDate_sent() != "")
				$stmt->bindParam(':date_sent', $this->getDate_sent(), PDO::PARAM_STR);
				
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);

			$stmt->execute();
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:update()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:update()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadDrafts(){
		$data = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT * FROM dap_email_broadcasts WHERE tracking_id = '' OR tracking_id IS NULL  ORDER BY id desc";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] = $row;
			}
			$stmt = null;
			$dap_dbh = null;
			return $data;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:loadDrafts()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:loadDrafts()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadSentBroadcasts(){
		$data = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT * FROM dap_email_broadcasts WHERE tracking_id != '' AND tracking_id IS NOT NULL  
					ORDER BY `dap_email_broadcasts`.`tracking_id`  DESC";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] = $row;
			}
			$stmt = null;
			$dap_dbh = null;
			return $data;

		} catch (PDOException $e) {
			logToFile("Dap_EmailBroadcasts.class:loadSentBroadcasts()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailBroadcasts.class:loadSentBroadcasts()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
}//class
