<?php 

class Dap_EmailReports{
	
	var $id;
	var $tracking_id;
	var $event_type;
	var $total_emails;
	var $delivered;
	var $opens;
	var $clicks;
	var $bounced;
	var $unsubscribed;
	var $complained;
	var $last_updated;
	var $email;
	var $link;
	var $count;
	var $date;
	var $source;
	var $subject;
	
	
	function getSource()  {
	   return $this->source;
	}
	function setSource($o) {
	  $this->source = $o;
	}
	
	function getSubject()  {
	   return $this->subject;
	}
	function setSubject($o) {
	  $this->subject = $o;
	}
	
	function getDate()  {
	   return $this->date;
	}
	function setDate($o) {
	  $this->date = $o;
	}
	
	function getCount()  {
	   return $this->count;
	}
	function setCount($o) {
	  $this->count = $o;
	}
	
	function getLink()  {
	   return $this->link;
	}
	function setLink($o) {
	  $this->link = $o;
	}
	
	function getEmail()  {
	   return $this->email;
	}
	function setEmail($o) {
	  $this->email = $o;
	}
	
	function getLast_updated()  {
	   return $this->last_updated;
	}
	function setLast_updated($o) {
	  $this->last_updated = $o;
	}
	
	function getComplained()  {
	   return $this->complained;
	}
	function setComplained($o) {
	  $this->complained = $o;
	}
	
	function getUnsubscribed()  {
	   return $this->unsubscribed;
	}
	function setUnsubscribed($o) {
	  $this->unsubscribed = $o;
	}
	
	function getBounced()  {
	   return $this->bounced;
	}
	function setBounced($o) {
	  $this->bounced = $o;
	}
	
	function getClicks()  {
	   return $this->clicks;
	}
	function setClicks($o) {
	  $this->clicks = $o;
	}
	
	function getOpens()  {
	   return $this->opens;
	}
	function setOpens($o) {
	  $this->opens = $o;
	}
	
	function getDelivered()  {
	   return $this->delivered;
	}
	function setDelivered($o) {
	  $this->delivered = $o;
	}
	
	function getTotal_emails()  {
	   return $this->total_emails;
	}
	function setTotal_emails($o) {
	  $this->total_emails = $o;
	}
	
	function getEvent_type()  {
	   return $this->event_type;
	}
	function setEvent_type($o) {
	  $this->event_type = $o;
	}
	
	function getId()  {
	   return $this->id;
	}
	function setId($o) {
	  $this->id = $o;
	}
	
	function getTracking_id()  {
	   return $this->tracking_id;
	}
	function setTracking_id($o) {
	  $this->tracking_id = $o;
	}
	
	public function create(){
		//~ logToFile("Dap_EmailReports.class:create()",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "INSERT INTO
					dap_email_reports
						(tracking_id, event_type, total_emails,last_updated,source,subject)
					VALUES
						(:tracking_id, :event_type, :total_emails,'".date("Y-m-d h:i:s")."', :source, :subject)";

			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':tracking_id', $this->getTracking_id(), PDO::PARAM_INT);
			$stmt->bindParam(':event_type', $this->getEvent_type(), PDO::PARAM_STR);
			$stmt->bindParam(':total_emails', $this->getTotal_emails(), PDO::PARAM_INT);
			$stmt->bindParam(':source', $this->getSource(), PDO::PARAM_STR);
			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);
			
			$stmt->execute();

			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:create()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:create()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function storeClicksData($tracking_id,$email,$link,$date){
		//~ logToFile("Dap_EmailReports.class:update()",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT id 
					FROM
						dap_email_reports_clicks
					WHERE
						tracking_id = '".$tracking_id."' && email='".$email."' && link='".$link."' && DATE(date) = '".$date."'";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				logToFile("Dap_EmailReports.class:storeClicksData(), old entry, so update",LOG_DEBUG_DAP);
				$sql1 = "UPDATE
					dap_email_reports_clicks
						SET count = count+1 
					WHERE
						id = ".$row['id'];
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt1->execute();
			}else{
				logToFile("Dap_EmailReports.class:storeClicksData(), new entry, so insert",LOG_DEBUG_DAP);
				
				$sql1 = "INSERT INTO
					dap_email_reports_clicks
						(tracking_id,email,link,count,date)
					VALUES
						('".$tracking_id."','".$email."','".$link."',1,'".date("Y-m-d h:i:s")."')
					";
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt1->execute();
				
			}
			//logToFile("Dap_EmailReports.class:update()".$sql,LOG_DEBUG_DAP);
			
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:storeClicksData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:storeClicksData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadCompleteTrackingData($start="",$end="",$tracking_id=""){
		try{
			$data;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT 
					sum(delivered) as delivered,sum(opens) as opens,sum(clicks)as clicks,sum(bounced) as bounced,sum(unsubscribed) as unsubscribed,sum(complained) as complained ,
					DATE(last_updated) as date,subject,source
					FROM
						dap_email_reports ";
			if($start != "" && $end != "")
				$sql .= "WHERE DATE(last_updated) BETWEEN '".$start."' AND '".$end."'";
				
			if($tracking_id != "")
				$sql .= " && tracking_id = '".$tracking_id."' ";
			
			$sql .= " GROUP BY DATE(`last_updated`),subject,source";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] = $row;
			}

			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadCompleteTrackingData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadCompleteTrackingData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
		
	public static function loadAllTrackingData($start="",$end="",$tracking_id=""){
		try{
			$data;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT 
					id,tracking_id,event_type,total_emails,sum(delivered) as delivered,sum(opens) as opens,sum(clicks)as clicks,sum(bounced) as bounced,sum(unsubscribed) as unsubscribed,sum(complained) as complained ,subject,source
					FROM
						dap_email_reports ";
			if($start != "" && $end != "")
				$sql .= "WHERE DATE(last_updated) BETWEEN '".$start."' AND '".$end."'";
				
			if($tracking_id != "")
				$sql .= " && tracking_id = '".$tracking_id."' ";
			
			$sql .= " GROUP BY id,tracking_id,event_type,total_emails ,subject,source ORDER BY id DESC";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				 
				$data[] = $row;
			}
			 
			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadAllTrackingData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadAllTrackingData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadUniqueClicksBYTrackingId($tracking_id,$start,$end){
		try{
			$data = 0;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT count(id) as unique_clicks 
					FROM
						dap_email_reports_clicks
					WHERE
						tracking_id = '".$tracking_id."'";
			if($start != "" && $end != "")
				$sql .= " && DATE(date) BETWEEN '".$start."' AND '".$end."'";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return $row['unique_clicks'];
			}
			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadUniqueClicksBYTrackingId()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadUniqueClicksBYTrackingId()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadUniqueClicksdata($start="",$end="",$tracking_id=""){
		try{
			$data;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT 
					id,count(id) as unique_clicks,tracking_id,email,link,sum(`count`) as `count`,date
					FROM
						dap_email_reports_clicks
					";
			if($start != "" && $end != "")
				$sql .= " WHERE DATE(date) BETWEEN '".$start."' AND '".$end."'";
			
			if($tracking_id != "")
				$sql .= " && tracking_id = '".$tracking_id."' ";
				
			$sql .= " group by id,tracking_id,email,link, date ORDER BY id DESC";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] = $row;
			}
			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadUniqueClicksdata()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadUniqueClicksdata()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadUniqueClicksDetails($start="",$end="",$tracking_id=""){
		try{
			$data;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT 
					*,Date(date) as date,count(id) as unique_clicks
					FROM
						dap_email_reports_clicks
					";
			if($start != "" && $end != "")
				$sql .= " WHERE DATE(date) BETWEEN '".$start."' AND '".$end."'";
			
			if($tracking_id != "")
				$sql .= " && tracking_id = '".$tracking_id."' ";
				
			$sql .= " GROUP BY  DATE(date) ORDER BY date";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] = $row;
			}
			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadUniqueClicksDetails()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadUniqueClicksDetails()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadTrackingDataByTrackingId($tracking_id,$date=""){
		try{
			$data;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT id,event_type,total_emails,subject,source
					FROM
						dap_email_reports
					WHERE
						tracking_id = '".$tracking_id."'";
			if($date != "")
				$sql .= "&& DATE(last_updated) = '".$date."' ORDER BY id LIMIT 1";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return $row;
			}
			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadTrackingDataByTrackingId()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadTrackingDataByTrackingId()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadTrackingDetailsForTrackingId($tracking_id,$start="",$end=""){
		try{
			$data;
			$dap_dbh = Dap_Connection::getConnection();
		 
			$sql = "SELECT * , DATE(last_updated) as date
					FROM
						dap_email_reports
					WHERE
						tracking_id = '".$tracking_id."'";
			if($start != "" && $end != "")
				$sql .= " && DATE(last_updated) BETWEEN '".$start."' AND '".$end."'";
				
			$sql .= " ORDER BY last_updated";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$data[] =  $row;
			}
			return $data;
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:loadTrackingDetailsForTrackingId()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:loadTrackingDetailsForTrackingId()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function update($tracking_id,$coloumn,$date){
		//~ logToFile("Dap_EmailReports.class:update()",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
		  
			$sql = "UPDATE
					dap_email_reports
						SET $coloumn = $coloumn+1 
					WHERE
						tracking_id = '".$tracking_id."' && DATE(last_updated) = '".$date."'";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			//logToFile("Dap_EmailReports.class:update()".$sql,LOG_DEBUG_DAP);
			
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:update()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:update()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function clearReportsData(){
		try{
			logToFile("Dap_EmailReports.class:clearReportsData(),today is ".date('Y-m-d'),LOG_DEBUG_DAP);
			logToFile("Dap_EmailReports.class:clearReportsData(),going to remove the data before ".date('Y-m-d', strtotime("-90 day")),LOG_DEBUG_DAP);
			
			$date = date('Y-m-d', strtotime("-90 day"));
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "DELETE FROM
						dap_email_reports	
					WHERE
						DATE(last_updated) < '".$date."'";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			//logToFile("Dap_EmailReports.class:update()".$sql,LOG_DEBUG_DAP);
			
			$stmt = null;
			$dap_dbh = null;
			
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:clearReportsData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:clearReportsData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function clearClicksData(){
		try{
			logToFile("Dap_EmailReports.class:clearClicksData(),today is ".date('Y-m-d'),LOG_DEBUG_DAP);
			logToFile("Dap_EmailReports.class:clearClicksData(),going to remove the data before ".date('Y-m-d', strtotime("-30 day")),LOG_DEBUG_DAP);
			
			$date = date('Y-m-d', strtotime("-30 day"));
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "DELETE FROM
						dap_email_reports_clicks	
					WHERE
						DATE(date) < '".$date."'";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			//logToFile("Dap_EmailReports.class:update()".$sql,LOG_DEBUG_DAP);
			
			$stmt = null;
			$dap_dbh = null;
			
		}
		catch (PDOException $e) {
			logToFile("Dap_EmailReports.class:clearClicksData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_EmailReports.class:clearClicksData()".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

}// class ends
