<?php 

class Dap_ExternalConnections {
	var $api_key;
	function getApi_key() {
		return $this->api_key;
	}
	function setApi_key($o) {
		$this->api_key = $o;
	}
	
	public static function loadKeys($systemName, $key) {
	
		
		$dap_dbh = Dap_Connection::getConnection();
		$connection = null;

		//Load product details from database
		$sql = "select *
			from
				dap_external_connections
			where
				connection_destination = :systemName AND 
				connection_meta_key = :key";
		
		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':systemName', $systemName, PDO::PARAM_STR);
		$stmt->bindParam(':key', $key, PDO::PARAM_STR);
		$stmt->execute();
		
		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$connection = new Dap_ExternalConnections();
			$connection->setApi_key( $row["connection_meta_value"] );
			
		}

		return $connection;
	}
	
	
} //end class

?>
