<?php 
class Dap_GDPRCountries{
	var $id;
	var $country_name;
	var $country_code;
	var $status;
	
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }
    
    function getCountry_name() {
        return $this->country_name;
    }
    function setCountry_name($o) {
        $this->country_name = $o;
    }
    
    function getCountry_code() {
        return $this->country_code;
    }
    function setCountry_code($o) {
        $this->country_code = $o;
    }

	function getStatus() {
        return $this->status;
    }
    function setStatus($o) {
        $this->status = $o;
    }
    
    function create(){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "INSERT INTO dap_gdpr_countries
					(country_name,country_code, status) VALUES
					(:country_name, :country_code, :status)";
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':country_name', $this->getCountry_name(), PDO::PARAM_STR);
			$stmt->bindParam(':country_code', $this->getCountry_code(), PDO::PARAM_STR);
			$stmt->bindParam(':status', $this->getStatus(), PDO::PARAM_STR);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPRCountries.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPRCountries.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	function delete(){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "DELETE FROM  dap_gdpr_countries WHERE country_code = :country_code";	
			$stmt = $dap_dbh->prepare($sql);			
			$stmt->bindParam(':country_code', $this->getCountry_code(), PDO::PARAM_STR);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPRCountries.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPRCountries.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	public static function updateStatus($status,$country_code){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE  dap_gdpr_countries 
					set status =  $status WHERE country_code = '".$country_code."'";	
			$stmt = $dap_dbh->prepare($sql);			
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPRCountries.class.php: updateStatus(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPRCountries.class.php: updateStatus(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	public static function loadGDPRCountries(){
		try{
			$country = array();
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM  dap_gdpr_countries";	
			$stmt = $dap_dbh->prepare($sql);			
			$stmt->execute();
			
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$country[$row['country_name']] = $row['country_code'];
			}
			return $country;
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPRCountries.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPRCountries.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	public static function getGDPRCountryStatus($code){
		try{
			$status = "";
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM  dap_gdpr_countries 
					WHERE country_code = '".strtoupper($code)."'";	
			$stmt = $dap_dbh->prepare($sql);			
			$stmt->execute();
			
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$status = $row['status'];
			}
			return $status;
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPRCountries.class.php: getGDPRCountryStatus(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPRCountries.class.php: getGDPRCountryStatus(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
}
?>
