<?php

class Dap_Product {
	var $id;
	var $name;
	var $description;
	var $error_page_url;
	var $is_recurring;
	var $price;
	var $trial_price;
	var $price_increment;
	var $price_increment_ceil;
	var $quantity;
	var $num_sales;
	var $num_days;
	var $timed_pricing_start_date;
	var $selfservice_start_date;
	var $selfservice_end_date;
	var $total_occur;
	var $recurring_cycle_1;
	var $recurring_cycle_2;
	var $recurring_cycle_3;
	var $status; //Status can be "A": Active, "I": Inactive, "S": Suspended
	var $notification_id;
	var $thankyou_page_url;
	var $thirdPartyEmailIds;
	var $subscribeTo;
	var $unsubscribeFrom;
   	var $sales_page_url;
   	var $self_service_allowed;
	var $is_master;
   	var $product_image_url = "";
	var $credits;
	var $double_optin_subject;
	var $double_optin_body;
	var $thankyou_email_subject;
	var $thankyou_email_body;
	var $logged_in_url;
	var $getContentLevelCredit;
	var $is_free_product;
	var $allow_free_signup;
	//added on 080412 for SSS
	var $short_description = "";
	var $long_description = "";
	var $resell_product = "";
	var $future_content_access = "";
	var $product_image_url_linkedto = "";
	var $recurring_credits = "";
	var $access_expiration_action = "";
	var $access_upon_final_payment = "";
	
	
	//added for SPC
	var $stripe_payment_retry_subject;
	var $stripe_payment_retry_body;
	var $stripe_final_retry_subject;
	var $stripe_final_retry_body;
	var $stripe_failed_payment_cancellation_subject;
	var $stripe_failed_payment_cancellation_body;
		
	//08/11
	var $show_buy_link;
	var $buy_link;
	var $drip_type;

	var $member_product_links_url;
	
	var $free_trial;
	var $last_payment_access;
	var $last_payment_days;
	var $access_after_final_payment;
	var $access_limit;
	var $product_type;
	var $product_structure;
	var $course_email_subject;
	var $course_email_body;
	var $module_email_subject;
	var $module_email_body;
	var $lesson_email_subject;
	var $lesson_email_body;
	var $offer_trial;
	var $course_progress;
	var $course_complete_message;
	var $module_complete_message;
	var $lesson_complete_message;
	var $send_course_complete;
	var $send_module_complete;
	var $send_lesson_complete;
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}

	function getName() {
		return $this->name;
	}
	function setName($o) {
		$this->name = $o;
	}

	function getDescription() {
		return $this->description;
	}
	function setDescription($o) {
		$this->description = $o;
	}

	function getError_page_url() {
		return $this->error_page_url;
	}
	function seterror_page_url($o) {
		$this->error_page_url = $o;
	}

	function getIs_recurring() {
		return $this->is_recurring;
	}
	function setIs_recurring($o) {
		$this->is_recurring = $o;
	}

	function getPrice() {
		return $this->price;
	}
	function setPrice($o) {
		$this->price = $o;
	}
	
	function getTrial_price() {
		return $this->trial_price;
	}
	function setTrial_price($o) {
		$this->trial_price = $o;
	}
	
	function getPrice_increment() {
		return $this->price_increment;
	}
	function setPrice_increment($o) {
		$this->price_increment = $o;
	}
	
	function getPrice_increment_ceil() {
		return $this->price_increment_ceil;
	}
	function setPrice_increment_ceil($o) {
		$this->price_increment_ceil = $o;
	}

	function getQuantity() {
		return $this->quantity;
	}
	function setQuantity($o) {
		$this->quantity = $o;
	}
	
	function getNum_sales() {
		return $this->num_sales;
	}
	function setNum_sales($o) {
		$this->num_sales = $o;
	}
	
	function getNum_days() {
		return $this->num_days;
	}
	function setNum_days($o) {
		$this->num_days = $o;
	}
	function getTimed_pricing_start_date() {
		return $this->timed_pricing_start_date;
	}
	function setTimed_pricing_start_date($o) {
		$this->timed_pricing_start_date = $o;
	}
	
	function getSelfservice_start_date() {
		return $this->selfservice_start_date;
	}
	function setSelfservice_start_date($o) {
		$this->selfservice_start_date = $o;
	}
	
	function getSelfservice_end_date() {
		return $this->selfservice_end_date;
	}
	function setSelfservice_end_date($o) {
		$this->selfservice_end_date = $o;
	}
	
	function getTotal_occur() {
		return $this->total_occur;
	}
	function setTotal_occur($o) {
		$this->total_occur = $o;
	}

	function getRecurring_cycle_1() {
		return $this->recurring_cycle_1;
	}
	function setRecurring_cycle_1($o) {
		$this->recurring_cycle_1 = $o;
	}

	function getRecurring_cycle_2() {
		return $this->recurring_cycle_2;
	}
	function setRecurring_cycle_2($o) {
		$this->recurring_cycle_2 = $o;
	}

	function getRecurring_cycle_3() {
		return $this->recurring_cycle_3;
	}
	function setRecurring_cycle_3($o) {
		$this->recurring_cycle_3 = $o;
	}

	function getStatus() {
		return $this->status;
	}
	function setStatus($o) {
		$this->status = $o;
	}

	function getNotification_id() {
		return $this->notification_id;
	}
	function setNotification_id($o) {
		$this->notification_id = $o;
	}

	function getThankyou_page_url() {
		return $this->thankyou_page_url;
	}
	function setThankyou_page_url($o) {
		$this->thankyou_page_url = $o;
	}

	function getSubscribeTo() {
		return $this->subscribeTo;
	}
	function setSubscribeTo($o) {
		$this->subscribeTo = $o;
	}
	
	function getUnsubscribeFrom() {
		return $this->unsubscribeFrom;
	}
	function setUnsubscribeFrom($o) {
		$this->unsubscribeFrom = $o;
	}
	
	function getThirdPartyEmailIds() {
		return $this->thirdPartyEmailIds;
	}
	function setThirdPartyEmailIds($o) {
		$this->thirdPartyEmailIds = $o;
	}
	
	function getSales_page_url() {
		return $this->sales_page_url;
	}
	function setSales_page_url($o) {
		$this->sales_page_url = $o;
	}

	function getSelf_service_allowed() {
		return $this->self_service_allowed;
	}
	function setSelf_service_allowed($o) {
		$this->self_service_allowed = $o;
	}

	function getIs_master() {
		return $this->is_master;
	}
	function setIs_master($o) {
		$this->is_master = $o;
	}

	function getShowBuyLink() {
		return $this->show_buy_link;
	}
	function setShowBuyLink($o) {
		$this->show_buy_link = $o;
	}
	
	function getBuyLink() {
		return $this->buy_link;
	}
	function setBuyLink($o) {
		$this->buy_link = $o;
	}

	function getProduct_image_url() {
		return $this->product_image_url;
	}
	function setProduct_image_url($o) {
		$this->product_image_url = $o;
	}
	
	function getMember_product_links_url() {
		return $this->member_product_links_url;
	}
	function setMember_product_links_url($o) {
		$this->member_product_links_url = $o;
	}
	

	function getCredits() {
		return $this->credits;
	}
	function setCredits($o) {
		$this->credits = $o;
	}


	function getDouble_optin_subject() {
		return $this->double_optin_subject;
	}
	function setDouble_optin_subject($o) {
		$this->double_optin_subject = $o;
	}


	function getDouble_optin_body() {
		return $this->double_optin_body;
	}
	function setDouble_optin_body($o) {
		$this->double_optin_body = $o;
	}


	function getThankyou_email_subject() {
		return $this->thankyou_email_subject;
	}
	function setThankyou_email_subject($o) {
		$this->thankyou_email_subject = $o;
	}


	function getThankyou_email_body() {
		return $this->thankyou_email_body;
	}
	function setThankyou_email_body($o) {
		$this->thankyou_email_body = $o;
	}
	
	
	function getLogged_in_url() {
		return $this->logged_in_url;
	}
	function setLogged_in_url($o) {
		$this->logged_in_url = $o;
	}


	function getAllowContentLevelCredits() {
		return $this->allowContentLevelCredits;
	}
	function setAllowContentLevelCredits($o) {
		$this->allowContentLevelCredits = $o;
	}
	
	
	function getIs_free_product() {
		return $this->is_free_product;
	}
	function setIs_free_product($o) {
		$this->is_free_product = $o;
	}
	
	
	function getAllow_free_signup() {
		return $this->allow_free_signup;
	}
	function setAllow_free_signup($o) {
		$this->allow_free_signup = $o;
	}
	
	function getRecurringCredits() {
		return $this->recurring_credits;
	}
	function setRecurringCredits($o) {
		$this->recurring_credits = $o;
	}
	
	function getShortDescription() {
		return $this->short_description;
	}
	function setShortDescription($o) {
		$this->short_description = $o;
	}
	
	function getLongDescription() {
		return $this->long_description;
	}
	function setLongDescription($o) {
		$this->long_description = $o;
	}
	
	function getResellProduct() {
		return $this->resell_product;
	}
	function setResellProduct($o) {
		$this->resell_product = $o;
	}
	
	function getAllowAccessToFutureContent() {
		return $this->future_content_access;
	}
	function setAllowAccessToFutureContent($o) {
		$this->future_content_access = $o;
	}
	
	function getProductImageUrlLinkedTo() {
		return $this->product_image_url_linkedto;
	}
	function setProductImageUrlLinkedTo($o) {
		$this->product_image_url_linkedto = $o;
	}
	
	function getAccessExpirationAction() {
		return $this->access_expiration_action;
	}
	function setAccessExpirationAction($o) {
		$this->access_expiration_action = $o;
	}
	
	function getRenewal_redirect_url() {
		return $this->renewal_redirect_url;
	}
	function setRenewal_redirect_url($o) {
		$this->renewal_redirect_url = $o;
	}	

	function getRenewal_html() {
		return $this->renewal_html;
	}
	function setRenewal_html($o) {
		$this->renewal_html = $o;
	}	

	function getAccessUponFinalPayment() {
		return $this->access_upon_final_payment;
	}
	function setAccessUponFinalPayment($o) {
		$this->access_upon_final_payment = $o;
	}
	
	function getDrip_type() {
		return $this->drip_type;
	}
	function setDrip_type($o) {
		$this->drip_type = $o;
	}
	
	function getStripe_payment_retry_subject() {
		return $this->stripe_payment_retry_subject;
	}
	function setStripe_payment_retry_subject($o) {
		$this->stripe_payment_retry_subject = $o;
	}

	function getStripe_payment_retry_body() {
		return $this->stripe_payment_retry_body;
	}
	function setStripe_payment_retry_body($o) {
		$this->stripe_payment_retry_body = $o;
	}
	
	
	function getStripe_final_retry_subject() {
		return $this->stripe_final_retry_subject;
	}
	function setStripe_final_retry_subject($o) {
		$this->stripe_final_retry_subject = $o;
	}
	
	function getStripe_final_retry_body() {
		return $this->stripe_final_retry_body;
	}
	function setStripe_final_retry_body($o) {
		$this->stripe_final_retry_body = $o;
	}
	
	function getStripe_failed_payment_cancellation_subject() {
		return $this->stripe_failed_payment_cancellation_subject;
	}
	function setStripe_failed_payment_cancellation_subject($o) {
		$this->stripe_failed_payment_cancellation_subject = $o;
	}
	
	function getStripe_failed_payment_cancellation_body() {
		return $this->stripe_failed_payment_cancellation_body;
	}
	function setStripe_failed_payment_cancellation_body($o) {
		$this->stripe_failed_payment_cancellation_body = $o;
	}
	function getFreeTrial() {
		return $this->free_trial;
	}
	function setFreeTrial($o) {
		$this->free_trial = $o;
	}
	
	function getLastPaymentAccess() {
		return $this->last_payment_access;
	}
	function setLastPaymentAccess($o) {
		$this->last_payment_access = $o;
	}
	
	function getLastPaymentDays() {
		return $this->last_payment_days;
	}
	function setLastPaymentDays($o) {
		$this->last_payment_days = $o;
	}
	
	function getProductType() {
		return $this->product_type;
	}
	function setProductType($o) {
		$this->product_type = $o;
	}
	
	function getProductStructure() {
		return $this->product_structure;
	}
	function setProductStructure($o) {
		$this->product_structure = $o;
	}
	
	function getCourseEmailSubject() {
		return $this->course_email_subject;
	}
	function setCourseEmailSubject($o) {
		$this->course_email_subject = $o;
	}


	function getCourseEmailBody() {
		return $this->course_email_body;
	}
	function setCourseEmailBody($o) {
		$this->course_email_body = $o;
	}
	
	function getModuleEmailSubject() {
		return $this->module_email_subject;
	}
	function setModuleEmailSubject($o) {
		$this->module_email_subject = $o;
	}

	function getModuleEmailBody() {
		return $this->module_email_body;
	}
	function setModuleEmailBody($o) {
		$this->module_email_body = $o;
	}
		
	function getLessonEmailSubject() {
		return $this->lesson_email_subject;
	}
	function setLessonEmailSubject($o) {
		$this->lesson_email_subject = $o;
	}
	function getLessonEmailBody() {
		return $this->lesson_email_body;
	}
	function setLessonEmailBody($o) {
		$this->lesson_email_body = $o;
	}
	function getOfferTrial() {
		return $this->offer_trial;
	}
	function setOfferTrial($o) {
		$this->offer_trial = $o;
	}
	function getCourseProgress() {
		return $this->course_progress;
	}
	function setCourseProgress($o) {
		$this->course_progress = $o;
	}
 
	function getCourseCompleteMessage() {
		return $this->course_complete_message;
	}
	function setCourseCompleteMessage($o) {
		$this->course_complete_message = $o;
	}
	
	function getModuleCompleteMessage() {
		return $this->module_complete_message;
	}
	function setModuleCompleteMessage($o) {
		$this->module_complete_message = $o;
	}
	
	function getLessonCompleteMessage() {
		return $this->lesson_complete_message;
	}
	function setLessonCompleteMessage($o) {
		$this->lesson_complete_message = $o;
	}
	
	function getAccessAfterFinalPayment() {
		return $this->access_after_final_payment;
	}
	function setAccessAfterFinalPayment($o) {
		$this->access_after_final_payment = $o;
	}
	
	function getAccessLimit() {
		return $this->access_limit;
	}
	function setAccessLimit($o) {
		$this->access_limit = $o;
	}
 
	function getSendCourseComplete() {
		return $this->send_course_complete;
	}
	function setSendCourseComplete($o) {
		$this->send_course_complete = $o;
	}
	
	function getSendModuleComplete() {
		return $this->send_module_complete;
	}
	function setSendModuleComplete($o) {
		$this->send_module_complete = $o;
	}
  
	function getSendLessonComplete() {
		return $this->send_lesson_complete;
	}
	function setSendLessonComplete($o) {
		$this->send_lesson_complete = $o;
	}
	//Derive the remaining recurring days to be awarded based on total.
	// we need to calculate to see what recurring cycle
	// total_days can be zero or negative = meaning this is new cycle (first cycle).
	// total_days can be less than or equal to cycle_1, meaning return cycle_2
	// total_days can be less than or equal to sum of cycle_1, cycle_2 - return cycle_3
	// else return cycle_3
	function deriveRecurringDaysFromTotal($total_days) {
		if($total_days <= 0) return $this->recurring_cycle_1;
		if($total_days <= $this->recurring_cycle_1) return $this->recurring_cycle_2;
		//if($total_days <= ($this->recurring_cycle_1 + $this->recurring_cycle_2)) return $this->recurring_cycle_3;
		return $this->recurring_cycle_3;
	}


 	public static function getErrorPageByResource($resource) {
		$dap_dbh = Dap_Connection::getConnection();
		$errorPageURL = Dap_Config::get("SITEWIDE_ERROR");
		$url = NULL;
		
		if(!isset($resource)) {
			return $url;
		}
		
		$sql =
			"select p.error_page_url
					as error_page_url
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr
			where
				p.status = 'A' and
				prj.status = 'A' and
				fr.url =:resource and
				prj.resource_id = fr.id and
				prj.product_id = p.id
			";
		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':resource', $resource, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		
		if(!($count == 1)) {
			/*
				Either more than one product this resource is associated with.
				Or this is an image or a zip file that is directly uploaded to the WP uploads folder
				and is not really a part of any product yet.
				Lets return the config error page url.
			*/
			
			if ( !isset($errorPageURL) || ($errorPageURL == "") ) $errorPageURL = "/dap/product-error.php";
			
			return $errorPageURL;
		}
		
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		return $row['error_page_url'];
	}


	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$price = "0.00"; //We don't care about price at this time
	
			$sql = "insert into dap_products
						(name, description, thankyou_page_url, error_page_url, is_recurring, price, trial_price, price_increment, price_increment_ceil, num_sales, num_days, timed_pricing_start_date, selfservice_start_date, selfservice_end_date, total_occur, recurring_cycle_1, recurring_cycle_2, recurring_cycle_3, thirdPartyEmailIds, subscribe_to, unsubscribe_from, status, sales_page_url, self_service_allowed, is_master, allowContentLevelCredits, product_image_url, credits, double_optin_subject, double_optin_body, thankyou_email_subject, thankyou_email_body, logged_in_url, is_free_product, allow_free_signup,access_expiration_action,access_upon_final_payment,show_buy_link,buy_link,drip_type, member_product_links_url, stripe_payment_retry_subject, stripe_payment_retry_body, stripe_final_retry_subject, stripe_final_retry_body, stripe_failed_payment_cancellation_subject, stripe_failed_payment_cancellation_body,resell_product, free_trial, last_payment_access,last_payment_days, product_type, product_structure, course_email_subject, course_email_body, module_email_subject, module_email_body	,lesson_email_subject	,lesson_email_body, offer_trial, course_progress, course_complete_message, module_complete_message, lesson_complete_message, access_after_final_payment, access_limit , send_course_complete, send_module_complete, send_lesson_complete)
					values
						(:name, :description, :thankyou_page_url, :error_page_url, :is_recurring, :price, :trial_price, :price_increment, :price_increment_ceil, :num_sales, :num_days, :timed_pricing_start_date, :selfservice_start_date, :selfservice_end_date, :total_occur, :recurring_cycle_1, :recurring_cycle_2, :recurring_cycle_3, :thirdPartyEmailIds, :subscribeTo, :unsubscribeFrom, :status, :sales_page_url, :self_service_allowed, :is_master, :allowContentLevelCredits, :product_image_url, :credits, :double_optin_subject, :double_optin_body, :thankyou_email_subject, :thankyou_email_body, :logged_in_url, :is_free_product, :allow_free_signup,:access_expiration_action,:access_upon_final_payment,:show_buy_link,:buy_link,:drip_type, :member_product_links_url, :stripe_payment_retry_subject, :stripe_payment_retry_body, :stripe_final_retry_subject, :stripe_final_retry_body, :stripe_failed_payment_cancellation_subject,
						 :stripe_failed_payment_cancellation_body,:resell_product, :free_trial, :last_payment_access , :last_payment_days, :product_type, :product_structure, :course_email_subject, :course_email_body, :module_email_subject, :module_email_body, :lesson_email_subject, :lesson_email_body, :offer_trial, :course_progress, :course_complete_message, :module_complete_message, :lesson_complete_message, :access_after_final_payment, :access_limit, :send_course_complete, :send_module_complete, :send_lesson_complete)";
			
			$is_free_product = $this->getIs_free_product();
			if( is_null($is_free_product) || ($is_free_product == "") ) {
				$is_free_product = "N";
			}
			
			$allow_free_signup = $this->getAllow_free_signup();
			if( is_null($allow_free_signup) || ($allow_free_signup == "") ) {
				$allow_free_signup = "N";
			}
			
			$is_recurring = $this->getIs_recurring();
			if( is_null($is_recurring) || ($is_recurring == "") ) {
				$is_recurring = "N";
			}
			
			$price = $this->getPrice();
			if( is_null($price) || ($price == "") ) {
				$price = "0.00";
			}
			
			$status = $this->getStatus();
			if( is_null($status) || ($status == "") ) {
				$status = "A";
			}
			
			$self_service_allowed = $this->getSelf_service_allowed();
			if( is_null($self_service_allowed) || ($self_service_allowed == "") ) {
				$self_service_allowed = "N";
			}
			
			$is_master = $this->getIs_master();
			if( is_null($is_master) || ($is_master == "") ) {
				$is_master = "N";
			}
			
			$show_buy_link = $this->getShowBuyLink();
			if( is_null($show_buy_link) || ($show_buy_link == "") ) {
				$show_buy_link = "N";
			}
			
			$drip_type = $this->getDrip_type();
			if( is_null($drip_type) || ($drip_type == "") ) {
				$drip_type = "1";
			}
			
			$free_trial = $this->getFreeTrial();
			if( is_null($free_trial) || ($free_trial == "") ) {
				$free_trial = "N";
			}
			$send_course_complete = $this->getSendCourseComplete();
			if( is_null($send_course_complete) || ($send_course_complete == "") ) {
				$send_course_complete = "N";
			}
			$send_module_complete = $this->getSendModuleComplete();
			if( is_null($send_module_complete) || ($send_module_complete == "") ) {
				$send_module_complete = "N";
			}
			$send_lesson_complete = $this->getSendLessonComplete();
			if( is_null($send_lesson_complete) || ($send_lesson_complete == "") ) {
				$send_lesson_complete = "N";
			}
			
			$course_complete_message = $this->getCourseCompleteMessage();
			if( is_null($course_complete_message) || ($course_complete_message == "") ) {
				$course_complete_message = "Congrats! You've now completed this course! Well done!";
			}
			$module_complete_message = $this->getModuleCompleteMessage();
			if( is_null($module_complete_message) || ($module_complete_message == "") ) {
				$module_complete_message = "Great job! You've now completed this module.";
			}
			$lesson_complete_message = $this->getLessonCompleteMessage();
			if( is_null($lesson_complete_message) || ($lesson_complete_message == "") ) {
				$lesson_complete_message = "Great job! You've now completed this lesson.";
			}
			
			
			$resell_product = "Y";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':description', $this->getDescription(), PDO::PARAM_STR);
			$stmt->bindParam(':thankyou_page_url', $this->getThankyou_page_url(), PDO::PARAM_STR);
			$stmt->bindParam(':error_page_url', $this->getError_page_url(), PDO::PARAM_STR);
			$stmt->bindParam(':is_recurring', $is_recurring, PDO::PARAM_STR);
			$stmt->bindParam(':price', $price, PDO::PARAM_STR);
			$stmt->bindParam(':trial_price', $this->getTrial_price(), PDO::PARAM_STR);
			$stmt->bindParam(':price_increment', $this->getPrice_increment(), PDO::PARAM_STR);
			$stmt->bindParam(':price_increment_ceil', $this->getPrice_increment_ceil(), PDO::PARAM_STR);
			$stmt->bindParam(':num_sales', $this->getNum_sales(), PDO::PARAM_STR);
			$stmt->bindParam(':num_days', $this->getNum_days(), PDO::PARAM_STR);
			$stmt->bindParam(':timed_pricing_start_date', $this->getTimed_pricing_start_date(), PDO::PARAM_STR);
			$stmt->bindParam(':selfservice_start_date', $this->getSelfservice_start_date(), PDO::PARAM_STR);
			$stmt->bindParam(':selfservice_end_date', $this->getSelfservice_end_date(), PDO::PARAM_STR);
			$stmt->bindParam(':total_occur',  $this->getTotal_occur(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_cycle_1', $this->getRecurring_cycle_1(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_cycle_2', $this->getRecurring_cycle_2(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_cycle_3', $this->getRecurring_cycle_3(), PDO::PARAM_STR);
			$stmt->bindParam(':thirdPartyEmailIds', $this->getThirdPartyEmailIds(), PDO::PARAM_STR);
			$stmt->bindParam(':subscribeTo', $this->getSubscribeTo(), PDO::PARAM_STR);
			$stmt->bindParam(':unsubscribeFrom', $this->getUnsubscribeFrom(), PDO::PARAM_STR);
			$stmt->bindParam(':status', $status, PDO::PARAM_STR);
			$stmt->bindParam(':sales_page_url', $this->getSales_page_url(), PDO::PARAM_STR);
			$stmt->bindParam(':self_service_allowed', $self_service_allowed, PDO::PARAM_STR);
			$stmt->bindParam(':is_master', $is_master, PDO::PARAM_STR);
			$stmt->bindParam(':allowContentLevelCredits', $this->getAllowContentLevelCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':product_image_url', $this->getProduct_image_url(), PDO::PARAM_STR);
			$stmt->bindParam(':credits', $this->getCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':double_optin_subject', $this->getDouble_optin_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':double_optin_body', $this->getDouble_optin_body(), PDO::PARAM_STR);
			$stmt->bindParam(':thankyou_email_subject', $this->getThankyou_email_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':thankyou_email_body', $this->getThankyou_email_body(), PDO::PARAM_STR);
			$stmt->bindParam(':logged_in_url', $this->getLogged_in_url(), PDO::PARAM_STR);
			$stmt->bindParam(':is_free_product', $is_free_product, PDO::PARAM_STR);
			$stmt->bindParam(':allow_free_signup', $allow_free_signup, PDO::PARAM_STR);
			$stmt->bindParam(':access_expiration_action', $access_expiration_action, PDO::PARAM_STR);
			$stmt->bindParam(':access_upon_final_payment', $access_upon_final_payment, PDO::PARAM_STR);
			$stmt->bindParam(':show_buy_link', $show_buy_link, PDO::PARAM_STR);
			$stmt->bindParam(':buy_link', $this->getBuyLink(), PDO::PARAM_STR);
			$stmt->bindParam(':drip_type', $this->getDrip_type(), PDO::PARAM_STR);
			$stmt->bindParam(':member_product_links_url', $this->getMember_product_links_url(), PDO::PARAM_STR);
			
			$stmt->bindParam(':stripe_payment_retry_subject', $this->getStripe_payment_retry_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_payment_retry_body', $this->getStripe_payment_retry_body(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_final_retry_subject', $this->getStripe_final_retry_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_final_retry_body', $this->getStripe_final_retry_body(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_failed_payment_cancellation_subject', $this->getStripe_failed_payment_cancellation_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_failed_payment_cancellation_body', $this->getStripe_failed_payment_cancellation_body(), PDO::PARAM_STR);
			$stmt->bindParam(':resell_product', $resell_product, PDO::PARAM_STR);
			
			$stmt->bindParam(':free_trial', $free_trial , PDO::PARAM_STR);
			$stmt->bindParam(':last_payment_access', $this->getLastPaymentAccess(), PDO::PARAM_STR);
			$stmt->bindParam(':last_payment_days', $this->getLastPaymentDays(), PDO::PARAM_STR);
			$stmt->bindParam(':product_type', $this->getProductType(), PDO::PARAM_STR);
			$stmt->bindParam(':product_structure', $this->getProductStructure(), PDO::PARAM_STR); 
			$stmt->bindParam(':course_email_subject', $this->getCourseEmailSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':course_email_body', $this->getCourseEmailBody(), PDO::PARAM_STR);
			$stmt->bindParam(':module_email_subject', $this->getModuleEmailSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':module_email_body', $this->getModuleEmailBody(), PDO::PARAM_STR);
			$stmt->bindParam(':lesson_email_subject', $this->getLessonEmailSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':lesson_email_body', $this->getLessonEmailBody(), PDO::PARAM_STR);
			$stmt->bindParam(':offer_trial', $this->getOfferTrial(), PDO::PARAM_STR);
			$stmt->bindParam(':course_progress', $this->getCourseProgress(), PDO::PARAM_STR);
			$stmt->bindParam(':course_complete_message', $course_complete_message, PDO::PARAM_STR);
			$stmt->bindParam(':module_complete_message', $module_complete_message, PDO::PARAM_STR);
			$stmt->bindParam(':lesson_complete_message', $lesson_complete_message, PDO::PARAM_STR);
			$stmt->bindParam(':access_after_final_payment', $this->getAccessAfterFinalPayment(), PDO::PARAM_STR);
			$stmt->bindParam(':access_limit', $this->getAccessLimit(), PDO::PARAM_STR);
			$stmt->bindParam(':send_course_complete', $send_course_complete, PDO::PARAM_STR);
			$stmt->bindParam(':send_module_complete', $send_module_complete, PDO::PARAM_STR);
			$stmt->bindParam(':send_lesson_complete', $send_lesson_complete, PDO::PARAM_STR);
			
			//$stmt->bindParam(':quantity', $quantity, PDO::PARAM_STR);
			$stmt->execute();
			
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}


	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "update dap_products set
						name = :name,
						description = :description,
						thankyou_page_url = :thankyou_page_url,
						error_page_url = :error_page_url,
						is_recurring = :is_recurring,
						price = :price,
						trial_price = :trial_price,
						price_increment = :price_increment,
						price_increment_ceil = :price_increment_ceil,
						num_sales = :num_sales,
						num_days = :num_days,
						timed_pricing_start_date = :timed_pricing_start_date,
						selfservice_start_date = :selfservice_start_date,
						selfservice_end_date = :selfservice_end_date,
						total_occur = :total_occur,
						recurring_cycle_1 = :recurring_cycle_1,
						recurring_cycle_2 = :recurring_cycle_2,
						recurring_cycle_3 = :recurring_cycle_3,
						thirdPartyEmailIds = :thirdPartyEmailIds,
						subscribe_to = :subscribeTo,
						unsubscribe_from = :unsubscribeFrom,
						status = :status,
						sales_page_url = :sales_page_url,
						self_service_allowed = :self_service_allowed,
						is_master = :is_master,
						allowContentLevelCredits = :allowContentLevelCredits,
						product_image_url = :product_image_url,
						credits = :credits,
						double_optin_subject = :double_optin_subject,
						double_optin_body = :double_optin_body,
						thankyou_email_subject = :thankyou_email_subject,
						thankyou_email_body = :thankyou_email_body,
						logged_in_url = :logged_in_url,
						is_free_product = :is_free_product,
						allow_free_signup = :allow_free_signup,
						short_description = :short_description,
						long_description = :long_description,
						resell_product = :resell_product,
						future_content_access = :future_content_access,
						product_image_url_linkedto = :product_image_url_linkedto,
						access_expiration_action=:access_expiration_action,						
						recurring_credits = :recurring_credits,
						renewal_redirect_url = :renewal_redirect_url,
						renewal_html = :renewal_html,
						access_upon_final_payment = :access_upon_final_payment,
						show_buy_link = :show_buy_link,
						buy_link = :buy_link,
						drip_type = :drip_type,
						member_product_links_url = :member_product_links_url,
						stripe_payment_retry_subject = :stripe_payment_retry_subject,
						stripe_payment_retry_body = :stripe_payment_retry_body,
						stripe_final_retry_subject = :stripe_final_retry_subject,
						stripe_final_retry_body = :stripe_final_retry_body,
						stripe_failed_payment_cancellation_subject = :stripe_failed_payment_cancellation_subject,
						stripe_failed_payment_cancellation_body = :stripe_failed_payment_cancellation_body,
						free_trial = :free_trial,
						last_payment_access = :last_payment_access,
						last_payment_days = :last_payment_days,
						product_type = :product_type,
						product_structure = :product_structure,
						course_email_subject = :course_email_subject,
						course_email_body = :course_email_body,
						module_email_subject = :module_email_subject,
						module_email_body = :module_email_body,
						lesson_email_subject = :lesson_email_subject,
						lesson_email_body = :lesson_email_body,
						offer_trial = :offer_trial 	,
						course_progress = :course_progress 	,
						course_complete_message = :course_complete_message , 	
						module_complete_message = :module_complete_message , 	
						lesson_complete_message = :lesson_complete_message 	,	 					
						access_after_final_payment = :access_after_final_payment 	,	 					
						access_limit = :access_limit ,		 					
						send_course_complete = :send_course_complete ,		 					
						send_module_complete = :send_module_complete ,		 					
						send_lesson_complete = :send_lesson_complete   		 					
					where
						id = :productId";
						
		 

			//logToFile("HERE in Dap_Products update");
			
			$is_free_product = $this->getIs_free_product();
			if( is_null($is_free_product) || ($is_free_product == "") ) {
				$is_free_product = "N";
			}
			
			$allow_free_signup = $this->getAllow_free_signup();
			if( is_null($allow_free_signup) || ($allow_free_signup == "") ) {
				$allow_free_signup = "N";
			}
			
			$show_buy_link = $this->getShowBuyLink();
			if( is_null($show_buy_link) || ($show_buy_link == "") ) {
				$show_buy_link = "N";
			}
			
			$recur_credits = $this->getRecurringCredits();
			if( is_null($recur_credits) || ($recur_credits == "") ) {
				$recur_credits = 0;
			}
			$send_course_complete = $this->getSendCourseComplete();
			if( is_null($send_course_complete) || ($send_course_complete == "") ) {
				$send_course_complete = "N";
			}
			$send_module_complete = $this->getSendModuleComplete();
			if( is_null($send_module_complete) || ($send_module_complete == "") ) {
				$send_module_complete = "N";
			}
			$send_lesson_complete = $this->getSendLessonComplete();
			if( is_null($send_lesson_complete) || ($send_lesson_complete == "") ) {
				$send_lesson_complete = "N";
			}				 
			
			$course_complete_message = $this->getCourseCompleteMessage();
			if( is_null($course_complete_message) || ($course_complete_message == "") ) {
				$course_complete_message = "Congrats! You've now completed this course! Well done!";
			}
			$module_complete_message = $this->getModuleCompleteMessage();
			if( is_null($module_complete_message) || ($module_complete_message == "") ) {
				$module_complete_message = "Great job! You've now completed this module.";
			}
			$lesson_complete_message = $this->getLessonCompleteMessage();
			if( is_null($lesson_complete_message) || ($lesson_complete_message == "") ) {
				$lesson_complete_message = "Great job! You've now completed this lesson.";
			}
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':description', $this->getDescription(), PDO::PARAM_STR);
			$stmt->bindParam(':thankyou_page_url', $this->getThankyou_page_url(), PDO::PARAM_STR);
			$stmt->bindParam(':error_page_url', $this->getError_page_url(), PDO::PARAM_STR);
			$stmt->bindParam(':is_recurring', $this->getIs_recurring(), PDO::PARAM_STR);
			$stmt->bindParam(':price', $this->getPrice(), PDO::PARAM_STR);
			$stmt->bindParam(':trial_price', $this->getTrial_price(), PDO::PARAM_STR);
			$stmt->bindParam(':price_increment', $this->getPrice_increment(), PDO::PARAM_STR);
			$stmt->bindParam(':price_increment_ceil', $this->getPrice_increment_ceil(), PDO::PARAM_STR);
			$stmt->bindParam(':num_sales', $this->getNum_sales(), PDO::PARAM_STR);
			$stmt->bindParam(':num_days', $this->getNum_days(), PDO::PARAM_STR);
			$stmt->bindParam(':timed_pricing_start_date', $this->getTimed_pricing_start_date(), PDO::PARAM_STR);
			$stmt->bindParam(':selfservice_start_date', $this->getSelfservice_start_date(), PDO::PARAM_STR);
			$stmt->bindParam(':selfservice_end_date', $this->getSelfservice_end_date(), PDO::PARAM_STR);
			$stmt->bindParam(':total_occur', $this->getTotal_occur(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_cycle_1', $this->getRecurring_cycle_1(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_cycle_2', $this->getRecurring_cycle_2(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_cycle_3', $this->getRecurring_cycle_3(), PDO::PARAM_STR);
			$stmt->bindParam(':thirdPartyEmailIds', $this->getThirdPartyEmailIds(), PDO::PARAM_STR);
			$stmt->bindParam(':subscribeTo', $this->getSubscribeTo(), PDO::PARAM_STR);
			$stmt->bindParam(':unsubscribeFrom', $this->getUnsubscribeFrom(), PDO::PARAM_STR);
			$stmt->bindParam(':status', $this->getStatus(), PDO::PARAM_STR);
			$stmt->bindParam(':sales_page_url', $this->getSales_page_url(), PDO::PARAM_STR);
			$stmt->bindParam(':self_service_allowed', $this->getSelf_service_allowed(), PDO::PARAM_STR);
			$stmt->bindParam(':is_master', $this->getIs_master(), PDO::PARAM_STR);
			$stmt->bindParam(':allowContentLevelCredits', $this->getAllowContentLevelCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':product_image_url', $this->getProduct_image_url(), PDO::PARAM_STR);
			$stmt->bindParam(':credits', $this->getCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':double_optin_subject', $this->getDouble_optin_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':double_optin_body', $this->getDouble_optin_body(), PDO::PARAM_STR);
			$stmt->bindParam(':thankyou_email_subject', $this->getThankyou_email_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':thankyou_email_body', $this->getThankyou_email_body(), PDO::PARAM_STR);
			$stmt->bindParam(':logged_in_url', $this->getLogged_in_url(), PDO::PARAM_STR);
			$stmt->bindParam(':is_free_product', $is_free_product, PDO::PARAM_STR);
			$stmt->bindParam(':allow_free_signup', $allow_free_signup, PDO::PARAM_STR);
			$stmt->bindParam(':short_description', $this->getShortDescription(), PDO::PARAM_STR);
			$stmt->bindParam(':long_description', $this->getLongDescription(), PDO::PARAM_STR);
			$stmt->bindParam(':resell_product', $this->getResellProduct(), PDO::PARAM_STR);
			$stmt->bindParam(':future_content_access', $this->getAllowAccessToFutureContent(), PDO::PARAM_STR);
			$stmt->bindParam(':product_image_url_linkedto', $this->getProductImageUrlLinkedTo(), PDO::PARAM_STR);
			$stmt->bindParam(':access_expiration_action', $this->getAccessExpirationAction(), PDO::PARAM_STR);
			$stmt->bindParam(':recurring_credits', $recur_credits, PDO::PARAM_STR);
			$stmt->bindParam(':renewal_redirect_url', $this->getRenewal_redirect_url(), PDO::PARAM_STR);
			$stmt->bindParam(':renewal_html', $this->getRenewal_html(), PDO::PARAM_STR);
			$stmt->bindParam(':access_upon_final_payment', $this->getAccessUponFinalPayment(), PDO::PARAM_STR);
			$stmt->bindParam(':show_buy_link', $show_buy_link, PDO::PARAM_STR);
			$stmt->bindParam(':buy_link', $this->getBuyLink(), PDO::PARAM_STR);
			$stmt->bindParam(':drip_type', $this->getDrip_type(), PDO::PARAM_STR);
			$stmt->bindParam(':member_product_links_url', $this->getMember_product_links_url(), PDO::PARAM_STR);
			
			$stmt->bindParam(':stripe_payment_retry_subject', $this->getStripe_payment_retry_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_payment_retry_body', $this->getStripe_payment_retry_body(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_final_retry_subject', $this->getStripe_final_retry_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_final_retry_body', $this->getStripe_final_retry_body(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_failed_payment_cancellation_subject', $this->getStripe_failed_payment_cancellation_subject(), PDO::PARAM_STR);
			$stmt->bindParam(':stripe_failed_payment_cancellation_body', $this->getStripe_failed_payment_cancellation_body(), PDO::PARAM_STR);
			
			$stmt->bindParam(':free_trial', $this->getFreeTrial(), PDO::PARAM_STR);
			$stmt->bindParam(':last_payment_access', $this->getLastPaymentAccess(), PDO::PARAM_STR);
			$stmt->bindParam(':last_payment_days', $this->getLastPaymentDays(), PDO::PARAM_STR);
			$stmt->bindParam(':product_type', $this->getProductType(), PDO::PARAM_STR);
			$stmt->bindParam(':product_structure', $this->getProductStructure(), PDO::PARAM_STR);
			
			$stmt->bindParam(':course_email_subject', $this->getCourseEmailSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':course_email_body', $this->getCourseEmailBody(), PDO::PARAM_STR);
			$stmt->bindParam(':module_email_subject', $this->getModuleEmailSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':module_email_body', $this->getModuleEmailBody(), PDO::PARAM_STR);
			$stmt->bindParam(':lesson_email_subject', $this->getLessonEmailSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':lesson_email_body', $this->getLessonEmailBody(), PDO::PARAM_STR);
			//$stmt->bindParam(':quantity', $quantity, PDO::PARAM_STR);
			$stmt->bindParam(':offer_trial', $this->getOfferTrial(), PDO::PARAM_STR);	
			$stmt->bindParam(':course_progress', $this->getCourseProgress(), PDO::PARAM_STR);
			$stmt->bindParam(':course_complete_message', $course_complete_message, PDO::PARAM_STR);
			$stmt->bindParam(':module_complete_message', $module_complete_message, PDO::PARAM_STR);
			$stmt->bindParam(':lesson_complete_message', $lesson_complete_message, PDO::PARAM_STR);
			$stmt->bindParam(':access_after_final_payment', $this->getAccessAfterFinalPayment(), PDO::PARAM_STR);
			$stmt->bindParam(':access_limit', $this->getAccessLimit(), PDO::PARAM_STR);	
			$stmt->bindParam(':send_course_complete', $send_course_complete, PDO::PARAM_STR);
			$stmt->bindParam(':send_module_complete', $send_module_complete, PDO::PARAM_STR);
			$stmt->bindParam(':send_lesson_complete', $send_lesson_complete, PDO::PARAM_STR);
			$stmt->bindParam(':productId', $this->getId(), PDO::PARAM_INT);

			//logToFile("Before exec in Dap_Products update");
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

    public static function displayFileResourcesCount($productId = 0){ 
		
		$output = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.start_day,
						prj.start_date,
						prj.num_clicks,
						prj.is_free,
					    prj.credits_assigned,
						prj.display_order as do
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'					
						";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();
            $output = array();
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				 $output[] =$row;
			}
            $stmt = null;
			$dap_dbh = null;
			return $output;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function displayFileResources($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.start_day,
						prj.start_date,
						prj.num_clicks,
						prj.is_free,
					    prj.credits_assigned,
						prj.display_order as do
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.start_day desc, 
						prj.start_date desc, 
						prj.display_order desc,
						prj.num_clicks desc
						";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			logToFile("DAP_Products.class.php: sss=".$sss);
			logToFile("DAP_Products.class.php: isSSSMaster=".$isSSSMaster);
			$displayHTML = "
			  <div id='sortableFileListHeader'>
				  <ul>
					  <li class='sortable_file_resource'>
					  <span class='sortable_file_resource1' style='width:40px; float:left'><strong>Edit</strong></span>";
			 
			 if(($sss!="Y") || ($isSSSMaster=="Y")) {		
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; align=center'><strong>Drip Day</strong></span>";
			 }
			 else {	
				 $displayHTML .= "<span class='sortable_file_resource5' style='width:40px; float:left; align=center'><strong>Credits</strong></span>";	
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; align=center'><strong>Drip Day</strong></span>";				  
			  }
			  
			  $displayHTML .=	"<span class='sortable_file_resource3' style='width:70px; float:left;'><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\"
			   title=\"Delete all protected content from this Product\"><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					  <span class='sortable_file_resource4' style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div id='sortableFileList'>
				<ul>";
			//<table width='100%' cellspacing='0' cellpadding='0'>";
			/**<tr align='left' bgcolor=\"#EFEFEF\" class=\"bodytext\">
				<td>&nbsp;</td>
				<td align='center'><b>Drip on<br/>Day #</b></td>
				<td align='center'><b>URL</b></td>
				<td><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\" title=\"Delete all protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
			*/	
			//$displayHTML .= "<tr align='left' bgcolor=\"$bgcolor\" class=\"bodytext\"><td colspan = '4'>
			//$displayHTML .= "";
			
			$dataFound = false;
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$num_clicks = $row["num_clicks"];
				$is_free = $row["is_free"];
				$do = $row["do"];
				$credits = $row["credits_assigned"];
				if ($credits == "") $credits=0;
				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				} else if( ($num_clicks != "") && ($num_clicks != 0) ){
					$whichOne = $num_clicks . " (clicks)";
				}
				
				//$urlShort = $url;
				$urlShort = trimString($url,80,50,30);

				/**$displayHTML .= "<tr align='left' bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td width='30'><a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings'>edit</a></td>
				<td align='center'>$whichOne</td>
				<td><a href='$url' target='_blank' title='$url'>$urlShort</a></td>
				<td width='20' align='center'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title=\"Delete this protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";*/
				
			 
				$displayHTML .= "<li id='recordsArray_".$id."' class='records_file_resource'>
				<span class='records_file_resource1' style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'>
				<i class=\"fa fa-pencil-square-o\" aria-hidden=\"true\"></i></a></span>";
				
				if(($sss!="Y") || ($isSSSMaster=="Y")) {
				  $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left'>$whichOne</span>";
				}
				else {				   
				   $displayHTML .= "<span class='records_file_resource5' style='width:40px; float:left'>$credits</span>";
				   $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left'>$whichOne</span>";
			    }
				$displayHTML .= "<span class='records_file_resource3' style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title=\"Delete this protected content from this Product\">
				<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
				<span class='records_file_resource4' style='display:block; overflow:auto; background-color:#EFEFEF;' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>
				";
			  
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Files currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	
	function displayFileResourcesConditional($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			
			$sql = "select
						fr.id,
						fr.url,
						prj.display_order,
						prj.cond_drip_order,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'  
					order by
						prj.cond_drip_order, prj.display_order desc, fr.id";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			logToFile("DAP_Products.class.php: conditional drip product");
			$displayHTML = "
			  <div id='sortableFileListHeader'>
				  <ul>
					  <li>
					  <span style='width:35px; float:left'><strong>Edit</strong></span>";
			 
			$displayHTML .= "<span style='width:93px; float:left;'><strong>Conditional<br> Drip Order</strong></span>";
		
			  
			$displayHTML .=	"<span style='width:30px; float:left;'><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\" title=\"Delete all protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"20\" height=\"20\" style='align: middle'></a></span>
					  <span style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div id='sortableFileList'>
				<ul>";
			
			$dataFound = false;
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				if(isset($row["cond_drip_order"]))
					$cond_drip_order = floatval($row["cond_drip_order"]);
				$display_order = $row["display_order"];
				
				//$urlShort = $url;
				$urlShort = trimString($url,80,50,30);
 
				$displayHTML .= "<li id='recordsArray_".$id."' style='overflow: hidden;clear:both' >
				<span style='width:35px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'><img src='/dap/images/edit.png' width='12' height='12' style='align:absmiddle' border='0'/></a></span>";
				
				If (!isset($cond_drip_order))
					$cond_drip_order=1;
					
				$displayHTML .= "<span style='width: 20px; float: left;  display: inline-block; margin-right: 18px;'><input type='text' style='width: 25px; height: 12px;' name='condorder_".$id. "' id='condorder_".$id. "' size=4 value=". $cond_drip_order . "></span>
				<span style='width:50px; float:left'><a href=\"#\" onClick=\"javascript:updateCondContentOrderProduct('" .$id. "',document.getElementById('condorder_".$id."').value); return false;\" title=\"Update\"><img src=\"/dap/images/updatesmall.png\" border=\"0\" width=\"14\" height=\"14\" align=\"absmiddle\"></a></span>";
				$displayHTML .= "<span style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title=\"Delete this protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"14\" height=\"14\" align=\"absmiddle\"></a></span>";
				$displayHTML .= "<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>";
			  
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Files currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	


	function displayFileResourcesSSS($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.credits_assigned,
						prj.display_order,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F' and
						prj.credits_assigned > 0
					order by
						prj.display_order desc";
						
			//logToFile($sql,LOG_DEBUG_DAP);
			logToFile("Dap_Product.class.php.displayFileResourcesSSS(): productId=". $productId,LOG_DEBUG_DAP);
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$displayHTML = "<table width='100%' cellspacing='0' cellpadding='3'>
			<tr align='center' bgcolor=\"#EFEFEF\" class=\"bodytext\">
				<td>&nbsp;</td>
				<td align='center'><b>Credits</b></td>
				<td align='center'><b>Display<br/>Order</b></td>
				<td align='center'><b>URL</b></td>
				<td><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\" title='Delete all protected content from this Product'><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$credits_assigned = $row["credits_assigned"];
				$display_order = $row["display_order"];
				$is_free = $row["is_free"];

				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				$displayHTML .= "<tr align='left' bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td width='30'><a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings'>edit</a></td>
				<td align='center'>$credits_assigned</td>
				<td align='center'>$display_order</td>
				<td><a href='$url' target='_blank' title='Click to open in a new window'>$url</a></td>
				<td width='20' align='center'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title='Delete this protected content from this Product'><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
			}

			if($displayHTML == "<table width='100%' cellspacing='0' cellpadding='5'>") {
				$displayHTML = "<tr align='left'><td colspan='4'>There are no Files currently assigned to this Product</td></tr>";
			} else {
				$displayHTML .= "</table>";
			}

			return $displayHTML;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	public static function loadProduct($productId) {
		$dap_dbh = Dap_Connection::getConnection();
		$product = null;

		//Load product details from database
		$sql = "select *
			from
				dap_products
			where
				id = :productId";

		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
		$stmt->execute();

		//echo "sql: $sql<br>"; exit;
		//$result = mysql_query($sql);
		//echo "rows returned: " . mysql_num_rows($result) . "<br>";

		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$product = new Dap_Product();
			$product->setId( $row["id"] );
			$product->setName( stripslashes($row["name"]) );
			$product->setDescription( stripslashes($row["description"]) );
			$product->setError_page_url( stripslashes($row["error_page_url"]) );
			$product->setIs_recurring( stripslashes($row["is_recurring"]) );
			$product->setPrice( $row["price"] );
			$product->setTrial_price( $row["trial_price"] );
			$product->setPrice_increment( $row["price_increment"] );
			$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
			$product->setNum_sales( $row["num_sales"] );
			$product->setNum_days( $row["num_days"] );
			$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
			$product->setSelfservice_start_date( $row["selfservice_start_date"] );
			$product->setSelfservice_end_date( $row["selfservice_end_date"] );
			$product->setTotal_occur( $row["total_occur"] );
			$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
			$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
			$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
			$product->setStatus( $row["status"] );
			$product->setNotification_id( $row["notification_id"] );
			$product->setThankyou_page_url( stripslashes($row["thankyou_page_url"]) );
			$product->setThirdPartyEmailIds( stripslashes($row["thirdPartyEmailIds"]) );
			$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
			$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
			$product->setSales_page_url( stripslashes($row["sales_page_url"]) );
			$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
			$product->setIs_master( stripslashes($row["is_master"]) );
			$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
			$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
			$product->setCredits( stripslashes($row["credits"]) );
			$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
			$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
			$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
			$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
			$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
			$product->setIs_free_product( stripslashes($row["is_free_product"]) );
			$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
			$product->setRecurringCredits( stripslashes($row["recurring_credits"]) );
			$product->setShortDescription( stripslashes($row["short_description"]) );
			$product->setLongDescription( stripslashes($row["long_description"]) );
			$product->setResellProduct( stripslashes($row["resell_product"]) );
			$product->setAllowAccessToFutureContent( stripslashes($row["future_content_access"]) );
			$product->setProductImageUrlLinkedTo( stripslashes($row["product_image_url_linkedto"]) );
			$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
			$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
			$product->setRenewal_html( stripslashes($row["renewal_html"]) );
			$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
			$product->setBuyLink( stripslashes($row["buy_link"]) );
			$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
			$product->setDrip_type( stripslashes($row["drip_type"]) );
			$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
			
			$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
			$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
			$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
			$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
			$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
			$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
			$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
			$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
			
			$product->setFreeTrial( stripslashes($row["free_trial"]) );
			$product->setLastPaymentAccess( stripslashes($row["last_payment_access"]) );
			$product->setLastPaymentDays( stripslashes($row["last_payment_days"]) );
			$product->setProductType( stripslashes($row["product_type"]) );
			$product->setProductStructure( stripslashes($row["product_structure"]) );
			
			$product->setCourseEmailSubject( stripslashes($row["course_email_subject"]) );
			$product->setCourseEmailBody( stripslashes($row["course_email_body"]) );
			$product->setModuleEmailSubject( stripslashes($row["module_email_subject"]) );
			$product->setModuleEmailBody( stripslashes($row["module_email_body"]) );
			$product->setLessonEmailSubject( stripslashes($row["lesson_email_subject"]) );
			$product->setLessonEmailBody( stripslashes($row["lesson_email_body"]) );
			$product->setOfferTrial( stripslashes($row["offer_trial"]) );			
			$product->setCourseProgress( stripslashes($row["course_progress"]) );			
			$product->setCourseCompleteMessage( stripslashes($row["course_complete_message"]) );			
			$product->setModuleCompleteMessage( stripslashes($row["module_complete_message"]) );			
			$product->setLessonCompleteMessage( stripslashes($row["lesson_complete_message"]) );	
			$product->setSendCourseComplete( stripslashes($row["send_course_complete"]) );	
			$product->setSendModuleComplete( stripslashes($row["send_module_complete"]) );	
			$product->setSendLessonComplete( stripslashes($row["send_lesson_complete"]) );	
			
 
		}

		return $product;
	}
	
	public static function isExists($productId) {
		$dap_dbh = Dap_Connection::getConnection();

		//Load product details from database
		$sql = "select id
			from
				dap_products
			where
				id = :productId";

		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
		$stmt->execute();

		//echo "sql: $sql<br>"; exit;
		//$result = mysql_query($sql);
		//echo "rows returned: " . mysql_num_rows($result) . "<br>";

		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
		  return TRUE;
		}

		return FALSE;
	}	

	public static function loadProductByName($productName) {
		$dap_dbh = Dap_Connection::getConnection();

		//$productName=utf8_encode($productName);
		//Load product details from database
		$sql = "select *
			from
				dap_products
			where
				name = :productName";
		
		//echo "sql: $sql<br>"; exit;
		//$result = mysql_query($sql);
		//echo "rows returned: " . mysql_num_rows($result) . "<br>";
		try {
		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':productName', $productName, PDO::PARAM_STR);
		$stmt->execute();
		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$product = new Dap_Product();
			$product->setId( $row["id"] );
			$product->setName( stripslashes($row["name"]) );
			$product->setDescription( stripslashes($row["description"]) );
			$product->setError_page_url( stripslashes($row["error_page_url"]) );
			$product->setIs_recurring( stripslashes($row["is_recurring"]) );
			$product->setPrice( $row["price"] );
			$product->setTrial_price( $row["trial_price"] );
			$product->setPrice_increment( $row["price_increment"] );
			$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
			$product->setNum_sales( $row["num_sales"] );
			$product->setNum_days( $row["num_days"] );
			$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
			$product->setSelfservice_start_date( $row["selfservice_start_date"] );
			$product->setSelfservice_end_date( $row["selfservice_end_date"] );
			$product->setTotal_occur( $row["total_occur"] );
			$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
			$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
			$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
			$product->setStatus( $row["status"] );
			$product->setNotification_id( $row["notification_id"] );
			$product->setThankyou_page_url( stripslashes($row["thankyou_page_url"]) );
			$product->setThirdPartyEmailIds( stripslashes($row["thirdPartyEmailIds"]) );
			$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
			$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
			$product->setSales_page_url( stripslashes($row["sales_page_url"]) );
			$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
			$product->setIs_master( stripslashes($row["is_master"]) );
			$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
			$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
			$product->setCredits( stripslashes($row["credits"]) );
			$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
			$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
			$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
			$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
			$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
			$product->setIs_free_product( stripslashes($row["is_free_product"]) );
			$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
			$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
			$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
			$product->setRenewal_html( stripslashes($row["renewal_html"]) );
			$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
			$product->setBuyLink( stripslashes($row["buy_link"]) );
			$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
			$product->setDrip_type( stripslashes($row["drip_type"]) );
			$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
			$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
			$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
			$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
			$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
			$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
			$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
			$product->setLastPaymentAccess($row["last_payment_access"]);
			$product->setLastPaymentDays($row["last_payment_days"]);
			
			//$product->setQuantity( stripslashes($row["quantity"]) );
			//echo "id: " . $product->getDescription(); exit;
			return $product;
		}
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

		return;
	}


	public static function loadProductByDesc($productName) {
		$dap_dbh = Dap_Connection::getConnection();
		$productName=utf8_encode($productName);
		//Load product details from database
		$sql = "select *
			from
				dap_products
			where
				description = :productName";

		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':productName', $productName, PDO::PARAM_STR);
		$stmt->execute();

		//echo "sql: $sql<br>"; exit;
		//$result = mysql_query($sql);
		//echo "rows returned: " . mysql_num_rows($result) . "<br>";

		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$product = new Dap_Product();
			$product->setId( $row["id"] );
			$product->setName( stripslashes($row["name"]) );
			$product->setDescription( stripslashes($row["description"]) );
			$product->setError_page_url( stripslashes($row["error_page_url"]) );
			$product->setIs_recurring( stripslashes($row["is_recurring"]) );
			$product->setPrice( $row["price"] );
			$product->setTrial_price( $row["trial_price"] );
			$product->setPrice_increment( $row["price_increment"] );
			$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
			$product->setNum_sales( $row["num_sales"] );
			$product->setNum_days( $row["num_days"] );
			$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
			$product->setSelfservice_start_date( $row["selfservice_start_date"] );
			$product->setSelfservice_end_date( $row["selfservice_end_date"] );
			$product->setTotal_occur( $row["total_occur"] );
			$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
			$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
			$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
			$product->setStatus( $row["status"] );
			$product->setNotification_id( $row["notification_id"] );
			$product->setThankyou_page_url( stripslashes($row["thankyou_page_url"]) );
			$product->setThirdPartyEmailIds( stripslashes($row["thirdPartyEmailIds"]) );
			$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
			$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
			$product->setSales_page_url( stripslashes($row["sales_page_url"]) );
			$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
			$product->setIs_master( stripslashes($row["is_master"]) );
			$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
			$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
			$product->setCredits( stripslashes($row["credits"]) );
			$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
			$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
			$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
			$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
			$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
			$product->setIs_free_product( stripslashes($row["is_free_product"]) );
			$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
			$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
			$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
			$product->setRenewal_html( stripslashes($row["renewal_html"]) );
			$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
			$product->setBuyLink( stripslashes($row["buy_link"]) );
			$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
			$product->setDrip_type( stripslashes($row["drip_type"]) );
			$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
			$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
			$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
			$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
			$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
			$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
			$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
			$product->setLastPaymentAccess($row["last_payment_access"]);
			$product->setLastPaymentDays($row["last_payment_days"]);			
			//$product->setQuantity( stripslashes($row["quantity"]) );
			//echo "id: " . $product->getDescription(); exit;
			return $product;
		}

		return;
	}
	
	//Load products matching filter criteria
	public static function loadProducts($productFilter, $status, $orderBy = "id", $orderHow = "asc") {
		$ProductsList = array();

		$whereClauseForStatus1 = ($status == "") ? "" : " where status = '$status'";
		$whereClauseForStatus2 = ($status == "") ? "" : " and status = '$status'";
		$orderClause = " order by $orderBy $orderHow ";

		if(trim($productFilter) == "") {
			$sql = "select * from dap_products " . $whereClauseForStatus1 . $orderClause;
		} else {
			$sql = "select * from dap_products
					where
						(id = '$productFilter' or
						name like '%$productFilter%' or
						description like '%$productFilter%' or
						error_page_url like '%$productFilter%' or
						thankyou_page_url like '%$productFilter%') " . $whereClauseForStatus2 . $orderClause;
		}

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();
				$product->setId( $row["id"] );
				$product->setName( stripslashes($row["name"]) );
				$product->setDescription( stripslashes($row["description"]) );
				$product->setError_page_url( stripslashes($row["error_page_url"]) );
				$product->setIs_recurring( stripslashes($row["is_recurring"]) );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setStatus( $row["status"] );
				$product->setNotification_id( $row["notification_id"] );
				$product->setThankyou_page_url( stripslashes($row["thankyou_page_url"]) );
				$product->setThirdPartyEmailIds( stripslashes($row["thirdPartyEmailIds"]) );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSales_page_url( stripslashes($row["sales_page_url"]) );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
				$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
				$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
				$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setRecurringCredits( stripslashes($row["recurring_credits"]) );
				$product->setShortDescription( stripslashes($row["short_description"]) );
				$product->setLongDescription( stripslashes($row["long_description"]) );
				$product->setResellProduct( stripslashes($row["resell_product"]) );
				$product->setAllowAccessToFutureContent( stripslashes($row["future_content_access"]) );
				$product->setProductImageUrlLinkedTo( stripslashes($row["product_image_url_linkedto"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
				$product->setRenewal_html( stripslashes($row["renewal_html"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );

				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				 
				
				$product->setFreeTrial( stripslashes($row["free_trial"]) );
				$product->setLastPaymentAccess( stripslashes($row["last_payment_access"]) );
				$product->setLastPaymentDays( stripslashes($row["last_payment_days"]) );
				$product->setProductType( stripslashes($row["product_type"]) );
				$product->setProductStructure( stripslashes($row["product_structure"]) );
				
				$product->setCourseEmailSubject( stripslashes($row["course_email_subject"]) );
				$product->setCourseEmailBody( stripslashes($row["course_email_body"]) );
				$product->setModuleEmailSubject( stripslashes($row["module_email_subject"]) );
				$product->setModuleEmailBody( stripslashes($row["module_email_body"]) );
				$product->setLessonEmailSubject( stripslashes($row["unit_email_subject"]) );
				$product->setLessonEmailBody( stripslashes($row["unit_email_body"]) );
				$product->setOfferTrial( stripslashes($row["offer_trial"]) );			
				$product->setCourseProgress( stripslashes($row["course_process"]) );			
				$product->setCourseCompleteMessage( stripslashes($row["course_complete_message"]) );			
				$product->setModuleCompleteMessage( stripslashes($row["module_complete_message"]) );			
				$product->setLessonCompleteMessage( stripslashes($row["unit_complete_message"]) );	
						
				//$product->setQuantity( stripslashes($row["quantity"]) );
				$ProductsList[] = $product;
			}

			return $ProductsList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}


     //Load products matching filter criteria
	public static function loadProductsForCondDrip($orderBy = "id", $orderHow = "asc") {
		$ProductsList = array();

		$sql = "select * from dap_products where status='A' and drip_type=2 order by $orderBy $orderHow";
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();

				$product->setId( $row["id"] );
				$product->setName( $row["name"] );
				$product->setDescription( $row["description"] );
				$product->setError_page_url( $row["error_page_url"] );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setIs_recurring( $row["is_recurring"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setStatus( $row["status"] );
				$product->setNotification_id( $row["notification_id"] );
				$product->setThankyou_page_url( $row["thankyou_page_url"] );
				$product->setThirdPartyEmailIds( $row["thirdPartyEmailIds"] );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
				$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
				$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
				$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
				$product->setRenewal_html( stripslashes($row["renewal_html"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
				
				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				
				$product->setLastPaymentAccess($row["last_payment_access"]);
				$product->setLastPaymentDays($row["last_payment_days"]);
				//$product->setQuantity( stripslashes($row["quantity"]) );
				$ProductsList[] = $product;
			}

			return $ProductsList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
//Load products matching filter criteria
	public static function loadProductsForSSS($isMaster) {
		$ProductsList = array();
		try {
			
			if ($isMaster=="ALL") {
				$sql = "select * from dap_products
							where self_service_allowed='Y'";
				$dap_dbh = Dap_Connection::getConnection();
				$stmt = $dap_dbh->prepare($sql);
				$stmt->execute();
			}
			else if ($isMaster=="Y") {
				$sql = "select * from dap_products
							where is_master=:isMaster and self_service_allowed='Y'";
				$dap_dbh = Dap_Connection::getConnection();
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':isMaster', $isMaster, PDO::PARAM_STR);
				$stmt->execute();
			}
			else {
				$sql = "select * from dap_products
							where is_master<>'Y' and self_service_allowed='Y'";
							$dap_dbh = Dap_Connection::getConnection();
					$stmt = $dap_dbh->prepare($sql);
					$stmt->execute();
			}
		
			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();

				$product->setId( $row["id"] );
				$product->setName( $row["name"] );
				$product->setDescription( $row["description"] );
				$product->setError_page_url( $row["error_page_url"] );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setIs_recurring( $row["is_recurring"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setStatus( $row["status"] );
				$product->setNotification_id( $row["notification_id"] );
				$product->setThankyou_page_url( $row["thankyou_page_url"] );
				$product->setThirdPartyEmailIds( $row["thirdPartyEmailIds"] );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
				$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
				$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
				$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
				$product->setRenewal_html( stripslashes($row["renewal_html"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				
				$product->setLastPaymentAccess($row["last_payment_access"]);
				$product->setLastPaymentDays($row["last_payment_days"]);
				//$product->setQuantity( stripslashes($row["quantity"]) );
				$ProductsList[] = $product;
			}

			return $ProductsList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	//TODO: THIS MAY RESULT IN MORE THAN ONE PRODUCT.
	public static function getProductDetailsByResource($resource) {
		try {
			//logToFile("Resource: $resource"); 
			
			$dap_dbh = Dap_Connection::getConnection();
			//Load product details from database
			$sql = "select p.id as id,
							p.name as name,
							p.description as description,
							p.error_page_url as error_page_url,
							p.is_recurring as is_recurring,
							p.recurring_cycle_1 as recurring_cycle_1,
							p.recurring_cycle_2 as recurring_cycle_2,
							p.recurring_cycle_3 as recurring_cycle_3,
							p.thirdPartyEmailIds as thirdPartyEmailIds,
							p.sales_page_url as sales_page_url,
							p.logged_in_url as logged_in_url
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr
				where
					p.status = 'A' and
					p.id = prj.product_id and
					prj.status = 'A' and
					prj.resource_id = fr.id and
					prj.resource_type = 'F' and
					fr.url = :resource
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':resource', $resource, PDO::PARAM_STR);
			$stmt->execute();
	
			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();
				$product->setId( $row["id"] );
				$product->setName( $row["name"] );
				$product->setDescription( $row["description"] );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setError_page_url( $row["error_page_url"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setThirdPartyEmailIds( $row["thirdPartyEmailIds"] );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSales_page_url( $row["sales_page_url"] );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
				
				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				$product->setLastPaymentAccess($row["last_payment_access"]);
				$product->setLastPaymentDays($row["last_payment_days"]);		
				//$product->setQuantity( stripslashes($row["quantity"]) );
				return $product;
			}
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	public static function isPartOfHowManyDistinctProducts($resource) {
		try {
			//logToFile("in isPartOfHowManyDistinctProducts. resource: $resource"); 
			$dap_dbh = Dap_Connection::getConnection();
			$count = 0;
			$user = null;
			$sql = "";
		
			if( Dap_Session::isLoggedIn() ) { 
				//get userid
				$session = Dap_Session::getSession();
				$user = $session->getUser();
			}
			
			if ( !isset($user) || is_null($user) ) {
				$sql = "select 
							count(*) as count
						from
							dap_products_resources_jn prj,
							dap_file_resources fr
						where
							fr.url = :resource and
							fr.id = prj.resource_id and
							prj.status = 'A' and
							prj.resource_type = 'F'
						";
		
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':resource', $resource, PDO::PARAM_STR);
				$stmt->execute();
		
				if ($row = $stmt->fetch()) {
					$count = $row["count"];
				}
			} 
			
			else { //user is available, so check only for products belonging to user
				$userId = $user->getId();
				//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							count(*) as count
						from
							dap_file_resources fr,
							dap_products_resources_jn prj,
							dap_users_products_jn upj,
							dap_products p
						where
							fr.url = :resource and
							fr.id = prj.resource_id and
							prj.status = 'A' and 
							prj.resource_type = 'F' and
							prj.product_id = p.id and
							prj.product_id = upj.product_id and
							upj.user_id = :userId						
						";
		
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':resource', $resource, PDO::PARAM_STR);
				$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
				$stmt->execute();
		
				if ($row = $stmt->fetch()) {
					$count = $row["count"];
				}
				
				
				if(intval($count) == 0) {
					//It is a logged in user - but user doesn't have access to product that has this resource
					//So do generic query again
					$sql2 = "select 
								count(*) as count
							from
								dap_products_resources_jn prj,
								dap_file_resources fr
							where
								fr.url = :resource and
								fr.id = prj.resource_id and
								prj.status = 'A' and
								prj.resource_type = 'F'
							";
		
					//logToFile($sql2,LOG_DEBUG_DAP);
					$stmt2 = $dap_dbh->prepare($sql2);
					$stmt2->bindParam(':resource', $resource, PDO::PARAM_STR);
					$stmt2->execute();
			
					if ($row2 = $stmt2->fetch()) {
						$count = $row2["count"];
					}
				}
			}
			
			$stmt = null;
			$row = null;
			$sql = null;
			$stmt2 = null;
			$row2 = null;
			$sql2 = null;
			$dap_dbh = null;
			
			return $count;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	function displayAssignedEmailResources ($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						prj.id as prjId,
						prj.start_day,
						prj.start_date,
						prj.is_free,
						prj.resource_id,
						prj.file_resource_id
						
					from
						dap_products_resources_jn prj
					where
						prj.product_id = :productId and
						prj.resource_type = 'E' 
					order by
						prj.start_day desc, prj.start_date desc";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$bgcolor = "#EEEEEE";
			$dataFound = false;
			
			/**
			$displayHTML = "<table width='100%' cellspacing='0' cellpadding='3'>
				<tr align='center' bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td align='center'>&nbsp;</td>
				<td align='center'><b>Drip on<br/>Day #</b></td>
				<td align='center'><b>Is<br/>Free?</b></td>
				<td align='center'><b>Subject</b></td>
				<td align='center'>&nbsp;</td>
				</tr>";
			*/
				
			$displayHTML = "
				<div id='emailListHeader'>
					<ul>
						<li>
						<span style='width:40px; float:left'><strong>Edit</strong></span>
						<span style='width:85px; float:left; align=center'><strong>Send<br/>Day</strong></span>
						<span style='width:30px; float:left;'>
						<a href=\"#\" onClick=\"javascript:removeAllEmailResourcesFromProduct(); return false;\" title=\"Delete all Emails from this Product\">
						<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
						<span style='display:block; overflow:auto;'><strong>Email Subject</strong></span>
						</li>
					</ul>
				</div>
				
				
				";

			$displayHTML .= "<div id='emailList'>
				<ul>";
				
			//$id=-1000;
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}

				
				$prjId = $row["prjId"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$is_free = $row["is_free"];
				$resource_id = $row["resource_id"];
				$file_resource_id = $row["file_resource_id"];
				
				logToFile("displayAssignedEmailResources: resource_id: " . $resource_id,LOG_DEBUG_DAP);

				$sql = "select
						id,
						subject
					from
						dap_email_resources 
					where
						id = :resource_id";
				
				$sqlstmt = $dap_dbh->prepare($sql);
				$sqlstmt->bindParam(':resource_id', $resource_id, PDO::PARAM_STR);
				$sqlstmt->execute();
			
				$found=false;
				if ($emailrow = $sqlstmt->fetch()) {
					$found=true;
					$id = $emailrow["id"];
					//$subject = mb_convert_encoding($emailrow["subject"], "UTF-8");
					$subject = mb_convert_encoding($emailrow["subject"], "UTF-8", "auto");
					
					logToFile("displayAssignedEmailResources: id: " . $prjId,LOG_DEBUG_DAP);
					logToFile("displayAssignedEmailResources: subject: " . $subject,LOG_DEBUG_DAP);
				}
				
				if (!$found) {
					$id=$resource_id;
					logToFile("displayAssignedEmailResources: AUTOMATED EMAIL ROW FOUND: " . $id,LOG_DEBUG_DAP);
					$FileResource = Dap_FileResource::loadFileResourceAutomated($productId, $file_resource_id);
					//foreach($FileResources as $FileResource) {
					$resourceURL = $FileResource["url"];
					//break;
					//}
					$resourceURL = trimString($resourceURL,40,20,10);
					$subjectShort="Automated: " . $resourceURL;
					$subject=$subjectShort;
					logToFile("displayAssignedEmailResources:AUTOMATED EMAIL DRIP: " . $subjectShort,LOG_DEBUG_DAP);
				}
				logToFile("displayAssignedEmailResources: EMAIL ROW FOUND: " . $id,LOG_DEBUG_DAP);
				
				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				}
				
				$isEnglish = true;
				if (preg_match('/[^A-Za-z0-9]/', $subject)) {
					logToFile("Inside preg_match - this is NON English"); 
					$isEnglish = false;
				}
				
				$subjectShort = $subject;
				if( $isEnglish && (strlen($subject) > 40)) {
					$subjectShort = substr($subject,0,20) . "......." . substr($subject,-10);
				}

				/**
				$displayHTML .= "<tr bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td><a href=\"javascript:\" onClick=\"loadEmailResource($id, $prjId); clearDiv('email_resource_message'); return false;\" title='Click to edit email drip settings (when this email is to be sent)'>edit</a></td>
				<td align='center'>$whichOne</td>
				<td align='center'>$is_free</td>
				<td align='left'><span title='$subject'>$subjectShort</span></td>
				<td width='20' align='center'><a href=\"javascript:\" onClick=\"javascript:removeEmailResourceFromProduct($id, $prjId); return false;\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
				*/
				
				
				if($id > -1000) {
				   	logToFile("if: displayAssignedEmailResources: emailresource found: " . $id,LOG_DEBUG_DAP);
					$displayHTML .= "<li class='displayAssignedEmailResources_div' id='recordsArrayEmail_".$id."'>
					<span style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadEmailResource($id, $prjId); clearDiv('email_resource_message'); return false;\" title='Click to edit email drip settings (when this email is to be sent)'><img src='/dap/images/edit.png' width='12' height='12' style='align:absbottom' border='0'/></a></span>
					<span style='width:85px; float:left'>$whichOne</span>
					<span style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeEmailResourceFromProduct($id, $prjId); return false;\" title=\"Delete this Email from this Product\">
						<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$title'>$subjectShort</span>
					</li>
				";
				}
				else {
					logToFile("else: displayAssignedEmailResources: emailresource found: " . $id,LOG_DEBUG_DAP);
					//$id=$id-1;
					
					$displayHTML .= "<li  class='displayAssignedEmailResources_div' id='recordsArrayEmail_".$id."'>
					<span style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadEmailResource($id, $prjId); clearDiv('email_resource_message'); return false;\" title='Click to edit email drip settings (when this email is to be sent)'><img src='/dap/images/edit.png' width='12' height='12' style='align:absbottom' border='0'/></a></span>
					<span style='width:85px; float:left'>$whichOne</span>
					<span style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeEmailResourceFromProduct($id, $prjId); return false;\" title=\"Delete this Email from this Product\">
						<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$title'>$subjectShort</span>
					</li>";
					
					logToFile("displayAssignedEmailResources: emailresource NOT found: " . $id,LOG_DEBUG_DAP);
				}
				
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Emails currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";
			
			logToFile("displayAssignedEmailResources: " . $displayHTML); 
			
			return $displayHTML;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	 
	function displayAssignedEmailResourcesUsingDripDay ($productId, $dripDay) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						prj.id as prjId,
						prj.start_day,
						prj.start_date,
						prj.is_free,
						prj.resource_id,
						prj.file_resource_id
						
					from
						dap_products_resources_jn prj
					where
						prj.product_id = :productId and
						prj.resource_type = 'E' and
						prj.start_day = :dripDay
					order by
						prj.start_day desc, prj.start_date desc";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->bindParam(':dripDay', $dripDay, PDO::PARAM_STR);
			$stmt->execute();

			$bgcolor = "#EEEEEE";
			$dataFound = false;
			
			/**
			$displayHTML = "<table width='100%' cellspacing='0' cellpadding='3'>
				<tr align='center' bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td align='center'>&nbsp;</td>
				<td align='center'><b>Drip on<br/>Day #</b></td>
				<td align='center'><b>Is<br/>Free?</b></td>
				<td align='center'><b>Subject</b></td>
				<td align='center'>&nbsp;</td>
				</tr>";
			*/
				
			$displayHTML = "
				<div id='emailListHeader'>
					<ul>
						<li>
						<span style='width:85px; float:left; align=center'><strong>Send<br/>Day</strong></span>
						<span style='display:block; overflow:auto;'><strong>Email Subject</strong></span>
						</li>
					</ul>
				</div>
				
				
				";

			$displayHTML .= "<div id='emailList'>
				<ul>";
				
			//$id=-1000;
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}

				
				$prjId = $row["prjId"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$is_free = $row["is_free"];
				$resource_id = $row["resource_id"];
				$file_resource_id = $row["file_resource_id"];
				
				logToFile("displayAssignedEmailResources: resource_id: " . $resource_id,LOG_DEBUG_DAP);

				$sql = "select
						id,
						subject
					from
						dap_email_resources 
					where
						id = :resource_id";
				
				$sqlstmt = $dap_dbh->prepare($sql);
				$sqlstmt->bindParam(':resource_id', $resource_id, PDO::PARAM_STR);
				$sqlstmt->execute();
			
				$found=false;
				if ($emailrow = $sqlstmt->fetch()) {
					$found=true;
					$id = $emailrow["id"];
					$subject = mb_convert_encoding($emailrow["subject"], "auto");
					logToFile("displayAssignedEmailResources: id: " . $prjId,LOG_DEBUG_DAP);
					logToFile("displayAssignedEmailResources: subject: " . $subject,LOG_DEBUG_DAP);
				}
				
				if (!$found) {
					$id=$resource_id;
					logToFile("displayAssignedEmailResources: AUTOMATED EMAIL ROW FOUND: " . $id,LOG_DEBUG_DAP);
					$FileResource = Dap_FileResource::loadFileResourceAutomated($productId, $file_resource_id);
					//foreach($FileResources as $FileResource) {
					$resourceURL = $FileResource["url"];
					//break;
					//}
					$resourceURL = trimString($resourceURL,40,20,10);
					$subjectShort="Automated: " . $resourceURL;
					$subject=$subjectShort;
					logToFile("displayAssignedEmailResources:AUTOMATED EMAIL DRIP: " . $subjectShort,LOG_DEBUG_DAP);
				}
				logToFile("displayAssignedEmailResources: EMAIL ROW FOUND: " . $id,LOG_DEBUG_DAP);
				
				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				}
				
				$isEnglish = true;
				if (preg_match('/[^A-Za-z0-9]/', $subject)) {
					logToFile("Inside preg_match - this is NON English"); 
					$isEnglish = false;
				}
				
				$subjectShort = $subject;
				if( $isEnglish && (strlen($subject) > 40)) {
					$subjectShort = substr($subject,0,20) . "......." . substr($subject,-10);
				}

				/**
				$displayHTML .= "<tr bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td><a href=\"javascript:\" onClick=\"loadEmailResource($id, $prjId); clearDiv('email_resource_message'); return false;\" title='Click to edit email drip settings (when this email is to be sent)'>edit</a></td>
				<td align='center'>$whichOne</td>
				<td align='center'>$is_free</td>
				<td align='left'><span title='$subject'>$subjectShort</span></td>
				<td width='20' align='center'><a href=\"javascript:\" onClick=\"javascript:removeEmailResourceFromProduct($id, $prjId); return false;\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
				*/
				
				
				if($id > -1000) {
				   	logToFile("if: displayAssignedEmailResources: emailresource found: " . $id,LOG_DEBUG_DAP);
					$displayHTML .= "<li  class='displayAssignedEmailResources_div' id='recordsArrayEmail_".$id."'>
					<span style='width:85px; float:left'>$whichOne</span>
					<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$title'>$subjectShort</span>
					</li>
				";
				}
				else {
					logToFile("else: displayAssignedEmailResources: emailresource found: " . $id,LOG_DEBUG_DAP);
					//$id=$id-1;
					
					$displayHTML .= "<li  class='displayAssignedEmailResources_div' id='recordsArrayEmail_".$id."'>
					<span style='width:85px; float:left'>$whichOne</span>
					<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$title'>$subjectShort</span>
					</li>";
					
					logToFile("displayAssignedEmailResources: emailresource NOT found: " . $id,LOG_DEBUG_DAP);
				}
				
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Emails currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";
			
			logToFile("displayAssignedEmailResources: " . $displayHTML); 
			
			return $displayHTML;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function displayAssignedEmailResourcesORIG($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						prj.id as prjId,
						er.id,
						er.subject,
						prj.start_day,
						prj.start_date,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_email_resources er
					where
						prj.product_id = :productId and
						prj.resource_type = 'E' and
						prj.resource_id = er.id
					order by
						prj.start_day desc, prj.start_date desc";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$bgcolor = "#EEEEEE";
			$dataFound = false;
			
			/**
			$displayHTML = "<table width='100%' cellspacing='0' cellpadding='3'>
				<tr align='center' bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td align='center'>&nbsp;</td>
				<td align='center'><b>Drip on<br/>Day #</b></td>
				<td align='center'><b>Is<br/>Free?</b></td>
				<td align='center'><b>Subject</b></td>
				<td align='center'>&nbsp;</td>
				</tr>";
			*/
				
			$displayHTML = "
				<div id='emailListHeader'>
					<ul>
						<li>
						<span style='width:40px; float:left'><strong>Edit</strong></span>
						<span style='width:85px; float:left; align=center'><strong>Send<br/>Day</strong></span>
						<span style='width:30px; float:left;'><a href=\"#\" onClick=\"javascript:removeAllEmailResourcesFromProduct(); return false;\" title=\"Delete all Emails from this Product\">
						<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
						<span style='display:block; overflow:auto;'><strong>Email Subject</strong></span>
						</li>
					</ul>
				</div>
				
				
				";

			$displayHTML .= "<div id='emailList'>
				<ul>";

			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}

				$id = $row["id"];
				$prjId = $row["prjId"];
				$subject = $row["subject"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$is_free = $row["is_free"];

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				}
				
				$subjectShort = $subject;
				if( strlen($subject) > 40) {
					$subjectShort = substr($subject,0,20) . "......." . substr($subject,-10);
				}
				
				$subjectShort = mb_convert_encoding($subjectShort, "UTF-8", "auto");

				/**
				$displayHTML .= "<tr bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td><a href=\"javascript:\" onClick=\"loadEmailResource($id, $prjId); clearDiv('email_resource_message'); return false;\" title='Click to edit email drip settings (when this email is to be sent)'>edit</a></td>
				<td align='center'>$whichOne</td>
				<td align='center'>$is_free</td>
				<td align='left'><span title='$subject'>$subjectShort</span></td>
				<td width='20' align='center'><a href=\"javascript:\" onClick=\"javascript:removeEmailResourceFromProduct($id, $prjId); return false;\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
				*/
				
				
				$displayHTML .= "<li  class='displayAssignedEmailResources_div' id='recordsArrayEmail_".$id."'>
					<span style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadEmailResource($id, $prjId); clearDiv('email_resource_message'); return false;\" title='Click to edit email drip settings (when this email is to be sent)'><img src='/dap/images/edit.png' width='12' height='12' style='align:absbottom' border='0'/></a></span>
					<span style='width:85px; float:left'>$whichOne</span>
					<span style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeEmailResourceFromProduct($id, $prjId); return false;\" title=\"Delete this Email from this Product\">
						<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$subject'>$subjectShort</span>
					</li>
				";
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Emails currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";
			
			return $displayHTML;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}

	public static function deleteProduct($id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction(); //begin the transaction
			$response = "SUCCESS! Product $productId was deleted from the database";
			$count = 0;

			//Check if there are any users associated with this product
			$sql = "select count(*) as count from dap_users_products_jn where product_id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();

			if ($row = $stmt->fetch()) {
				$count = $row["count"];
				if($count > 0) {
					return "There are Users associated with this Product. <br/>Remove them first before you can delete this Product.";
				}
			}

			//$sql = "delete from dap_products_resources_jn where product_id = :id";
			$sql = "DELETE 
						prj, fr
					FROM 
						dap_products_resources_jn AS prj
					LEFT JOIN 
						dap_file_resources AS fr ON prj.id = fr.id
					WHERE 
						prj.product_id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			
			//If none, then delete from dap_users_products_jn table
			$sql = "delete from dap_users_products_jn where product_id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();

			$sql = "delete from dap_products where id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			
			$sql = "delete from
						dap_file_resources
					where
						id not in 
							(select distinct resource_id from dap_products_resources_jn where resource_type = 'F')";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
					

			$dap_dbh->commit(); //commit the transaction
			$sql = null;
			$stmt = null;
			$dap_dbh = null;

			return $response;

		} catch (PDOException $e) {
			$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

	}

	/* 
		Copy all resources from one product to another, if not exists in another already.
		Params: source product id, destination product id.
		Return: nothing.
	*/
	public static function copyResourcesP2P($srcProductId, $destProductId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction(); //begin the transaction
			
			//TODO: check if both source and destination products exists.					
			
			/*
				Lets get all product-resource rows for the src product id.				
			*/
			$sql = "SELECT 
						resource_id, 
						is_free, 
						start_day, 
						end_day, 
						start_date, 
						end_date,
						num_clicks,
						resource_type, 
						status,
						credits_assigned, 
						sss_enabled, 
						excerpt, 
						display_order
					FROM
						dap_products_resources_jn prj
					WHERE
						prj.product_id = :productId";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $srcProductId, PDO::PARAM_INT);
			$stmt->execute();
			$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

			foreach ($results as $key => $row) {
				//Lets insert into products resources join table.
				try {
					$sql2 = "insert into dap_products_resources_jn
								(product_id, resource_id, is_free, start_day, end_day, 
								start_date, end_date, num_clicks, resource_type, status, credits_assigned, sss_enabled, excerpt, display_order)
								values(:product_id, :resource_id, :is_free, :start_day, :end_day,
								:start_date, :end_date, :num_clicks, :resource_type, :status, :credits_assigned, :sss_enabled, :excerpt, :display_order)";		
					$stmt2 = $dap_dbh->prepare($sql2);
					$stmt2->bindParam(':product_id', $destProductId, PDO::PARAM_INT);
					$stmt2->bindParam(':resource_id', $row['resource_id'], PDO::PARAM_INT);
					$stmt2->bindParam(':is_free', $row['is_free'], PDO::PARAM_STR);
					$stmt2->bindParam(':start_day', $row['start_day'], PDO::PARAM_INT);
					$stmt2->bindParam(':end_day', $row['end_day'], PDO::PARAM_INT);
					$stmt2->bindParam(':start_date', $row['start_date'], PDO::PARAM_STR);
					$stmt2->bindParam(':end_date', $row['end_date'], PDO::PARAM_STR);
					$stmt2->bindParam(':num_clicks', $row['num_clicks'], PDO::PARAM_INT);
					$stmt2->bindParam(':resource_type', $row['resource_type'], PDO::PARAM_STR);
					$stmt2->bindParam(':status', $row['status'], PDO::PARAM_STR);
					$stmt2->bindParam(':credits_assigned', $row['credits_assigned'], PDO::PARAM_INT);
					$stmt2->bindParam(':sss_enabled', $row['sss_enabled'], PDO::PARAM_STR);
					$stmt2->bindParam(':excerpt', $row['excerpt'], PDO::PARAM_STR);
					$stmt2->bindParam(':display_order', $row['display_order'], PDO::PARAM_INT);
					$stmt2->execute();	
				} catch (PDOException $e) {
					logToFile($e->getMessage());
					throw $e;
				} catch (Exception $e) {
					logToFile($e->getMessage());
					throw $e;
				}		
			}
			
			$dap_dbh->commit(); //commit the transaction
			$stmt = null;
			$dap_dbh = null;
			//return "<b>SUCCESS: File '" . $file . "' <br/>has been added to this product</b><br/><br/>";
		} catch (PDOException $e1) { 
			$dap_dbh->rollback();
			logToFile($e1->getMessage(),LOG_FATAL_DAP);
			throw $e1;
		} catch (Exception $e1) {
			$dap_dbh->rollback();
			logToFile($e1->getMessage(),LOG_FATAL_DAP);
			throw $e1;
		}	
	}


	public static function getMinProductId() {
		$dap_dbh = Dap_Connection::getConnection();
		$id = 0;
		
		$sql = "select 
					min(id) as id
				from
					dap_products";
					
		$stmt = $dap_dbh->prepare($sql);
		$stmt->execute();

		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$id = $row["id"];
		}

		return $id;
	}


	public static function isResourceProtectedInThisProduct($productId, $url) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$isProtected = false;
			
			//logToFile("url: $url"); 

			$sql = "select
						fr.id
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						fr.url like :url and
						fr.id = prj.resource_id and
						prj.product_id = :productId and
						prj.resource_type = 'F'
					";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':url', $url, PDO::PARAM_STR);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();
			
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$isProtected = true;
			}

			//logToFile("isProtected: $isProtected"); 
			return $isProtected;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	
	public static function getProtectedResourceCount($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$protectedResourceCount = 0;

			$sql = "select 
						count(*) as count
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.start_day desc, 
						prj.start_date desc, 
						prj.display_order desc,
						prj.num_clicks desc
						";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$protectedResourceCount = $row["count"];
			}

			return $protectedResourceCount;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	

			/******newly added*********/
	function displayFileResourcesNew($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.start_day,
						prj.start_date,
						prj.num_clicks,
						prj.is_free,
					    prj.credits_assigned,
						prj.display_order as do
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.start_day desc, 
						prj.start_date desc, 
						prj.display_order desc,
						prj.num_clicks desc
						";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			logToFile("DAP_Products.class.php: sss=".$sss);
			logToFile("DAP_Products.class.php: isSSSMaster=".$isSSSMaster);
			$displayHTML = "
			  <div id='sortableFileListHeader'>
				  <ul>
					  <li class='sortable_file_resource'>
					  <span class='sortable_file_resource1' style='width:40px; float:left'><strong>ID</strong></span>";
			 		
			 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; align=center'><strong>Credits</strong></span>";
			 
			  
			  $displayHTML .=	"<span class='sortable_file_resource4' style='display:block; overflow:auto;'><strong>URL of Protected Content</strong>
			  </span><span class='sortable_file_resource3' style='width:70px; float:left;'><a href=\"#\"
			   onClick=\"javascript:removeAllFileResourcesFromProduct('" .$productId. "'); return false;\"
			   title=\"Delete all protected content from this Product\"><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div id='sortableFileList'>
				<ul>";

			
			$dataFound = false;
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$num_clicks = $row["num_clicks"];
				$is_free = $row["is_free"];
				$do = $row["do"];
				$credits = $row["credits_assigned"];
				$product_id = $row["product_id"];
				if ($credits == "") $credits=0;
				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = '<input value="'.$start_day.'" class="editablecls">
					 <a class="update-btn btn btn-xs" title="Click to update drip settings." href=\"#\" 
					 onClick=\"javascript:updateDripday(' .$id. '); return false;\">
							<i aria-hidden="true" class="fa fa-refresh"></i>
						</a> ' ;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				} else if( ($num_clicks != "") && ($num_clicks != 0) ){
					$whichOne = $num_clicks . " (clicks)";
				}

				$urlShort = trimString($url,80,50,30);
			 
				$displayHTML .= "<li id='recordsArray_".$id."' data-id='".$id."' class='records_file_resource'>
				<span class='records_file_resource1' style='width:40px; float:left'>".$id ."
				 </span>";				
				
				$displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left'><input value='".$credits."' class='editablecls'>
					 <a class='update-btn btn btn-xs' title='Click to update credits settings.' 
					 onClick='javascript:updateCredits(" .$id. ", " .$productId. "); return false;'>
							<i aria-hidden='true' class='fa fa-refresh'></i>
						</a>  </span>";
			   
				$displayHTML .= "<span class='records_file_resource4' style='display:block; overflow:auto; background-color:#EFEFEF;' title='$url'>	
				<a href='$url' target='_blank'>$urlShort</a></span><span class='records_file_resource3' style='width:30px; float:left'>
				<a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$productId. "', '" .$id. "'); return false;\" title=\"Delete this protected content from this Product\">
				<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
				</li>
				";
			  
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>No content found in DAP products page >> content responder tab.</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} 
	}
	
	//Load master products  
	public static function loadMasterProducts($isMaster) {
		$ProductsList = array();
		
		$sql = "select *
			from
				dap_products
			where
				 is_master = '$isMaster'";


		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();

								$product->setId( $row["id"] );
				$product->setName( $row["name"] );
				$product->setDescription( $row["description"] );
				$product->setError_page_url( $row["error_page_url"] );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setIs_recurring( $row["is_recurring"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setStatus( $row["status"] );
				$product->setNotification_id( $row["notification_id"] );
				$product->setThankyou_page_url( $row["thankyou_page_url"] );
				$product->setThirdPartyEmailIds( $row["thirdPartyEmailIds"] );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
				$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
				$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
				$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
				$product->setRenewal_html( stripslashes($row["renewal_html"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				$product->setLastPaymentAccess($row["last_payment_access"]);
				$product->setLastPaymentDays($row["last_payment_days"]);
				
				$ProductsList[] = $product;
			}

			return $ProductsList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	//Load child products  
	public static function loadChildProducts($isChild) {
		$ProductsList = array();
		
		$sql = "select *
			from
				dap_products
			where
				 self_service_allowed = '$isChild'";


		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();

							$product->setId( $row["id"] );
				$product->setName( $row["name"] );
				$product->setDescription( $row["description"] );
				$product->setError_page_url( $row["error_page_url"] );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setIs_recurring( $row["is_recurring"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setStatus( $row["status"] );
				$product->setNotification_id( $row["notification_id"] );
				$product->setThankyou_page_url( $row["thankyou_page_url"] );
				$product->setThirdPartyEmailIds( $row["thirdPartyEmailIds"] );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setRecurringCredits( stripslashes($row["recurring_credits"]) );   
				$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
				$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
				$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
				$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
				$product->setRenewal_html( stripslashes($row["renewal_html"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );
				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				$product->setLastPaymentAccess($row["last_payment_access"]);
				$product->setLastPaymentDays($row["last_payment_days"]);
 
				$ProductsList[] = $product;
			}

			return $ProductsList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	/********Added for thrive to get the product id by user ID and url**********/
	public static function getProductByResourceAndUserId($uid, $requestUrl) {
		$ProductsList = array();
		 $sql = "select
					upj.transaction_id as transid,
					TO_DAYS(now()) as today,
					TO_DAYS(upj.access_start_date) as access_start_days,
					TO_DAYS(upj.access_end_date) as access_end_days,
					prj.is_free as is_free,
					prj.start_day as start_day,
					prj.end_day as end_day,
					TO_DAYS(prj.start_date) as res_start_days,
					TO_DAYS(prj.end_date) as res_end_days,
					prj.num_clicks as num_clicks,
					prj.product_id as product_id,
					prj.resource_id as resource_id,
					prj.credits_assigned as credits_assigned,
					p.error_page_url as error_page_url
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj
			where
				u.id =:uid and
				u.status = 'A' and
				fr.url =:requesturl and
				prj.resource_id = fr.id and
				prj.resource_type = 'F' and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A' and
				(
					(
						prj.start_day != 0 and
						( (TO_DAYS(now()) - TO_DAYS(upj.access_start_date) + 1) >= prj.start_day ) and
						( (TO_DAYS(now()) - TO_DAYS(upj.access_end_date) + 1) <= prj.end_day)
					) 
					or
					(
						prj.start_date != 0 and
						( date(now()) >= prj.start_date )
					) 
					or
					(
						( date(now()) >= upj.access_start_date ) and
						( date(now()) <= upj.access_end_date )
					) 
				)
			order by
				upj.access_end_date desc,
				prj.end_day desc,
				access_end_days desc,
				prj.num_clicks asc
				";
				
				//logToFile("ssa SQL:".$sql);
		$dap_dbh = Dap_Connection::getConnection();
		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':uid', $uid, PDO::PARAM_INT);
		$stmt->bindParam(':requesturl', $requestUrl, PDO::PARAM_STR);
		$stmt->execute();
		
		while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			 
			$product = new Dap_Product();
			$product->setId( $row["product_id"] );		 
			$ProductsList[] = $product;
		}
		return $ProductsList;
	}

	function displayFileResourcesWithModuleId($productId , $module_id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.start_day,
						prj.start_date,
						prj.num_clicks,
						prj.is_free,
					    prj.credits_assigned,
						prj.display_order as do
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.module_id = :module_id and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.start_day desc, 
						prj.start_date desc, 
						prj.display_order desc,
						prj.num_clicks desc
						";

			logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_STR);
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			logToFile("DAP_Products.class.php: sss=".$sss);
			logToFile("DAP_Products.class.php: isSSSMaster=".$isSSSMaster);
			$displayHTML = "
			  <div class='sortableFileListHeader'>
				   <ul class='ui-sortable' >
					  <li class='sortable_file_resource'>
					  <span class='sortable_file_resource1' style='width:40px; float:left'><strong>Edit</strong></span>";
			 
			 if(($sss!="Y") || ($isSSSMaster=="Y")) {		
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";
			 }
			 else {	
				 $displayHTML .= "<span class='sortable_file_resource5' style='width:40px; float:left; text-align: center;'><strong>Credits</strong></span>";	
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";				  
			  }
			  
			  $displayHTML .=	"<span class='sortable_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\"  onClick=\"javascript:removeAllFileResourcesFromProductNew( '" .$module_id. "'); return false;\"
			   title=\"Delete all lessons from this module\"><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					  <span class='sortable_file_resourceurl' style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div class='sortableFileList'>
				<ul class='modul_listing ui-droppable ui-sortable' id='mod_".$module_id."'>";
			
			
			$dataFound = false;
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$num_clicks = $row["num_clicks"];
				$is_free = $row["is_free"];
				$do = $row["do"];
				$credits = $row["credits_assigned"];
				if ($credits == "") $credits=0;
				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				} else if( ($num_clicks != "") && ($num_clicks != 0) ){
					$whichOne = $num_clicks . " (clicks)";
				}
				
				$urlShort = trimString($url,80,50,30);

				$displayHTML .= "<li id='recordsArray_".$id."' class='records_file_resource'>
				<span class='records_file_resource1' style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'>
				<i class=\"fa fa-pencil-square-o\" aria-hidden=\"true\"></i></a></span>";
				
				if(($sss!="Y") || ($isSSSMaster=="Y")) {
				  $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
				}
				else {				   
				   $displayHTML .= "<span class='records_file_resource5' style='width:40px; float:left'>$credits</span>";
				   $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
			    }
				$displayHTML .= "<span class='records_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProductNew('" .$id. "', '" .$module_id. "'); return false;\" title=\"Delete this lesson from this module\">
				<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
				<span class='records_file_resource4' style='display:block; overflow:auto; ' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>
				";
			
			  
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no lessons assigned to this module.</li>";
			}			
				
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function displayFileResourcesWithModuleIdCount($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
 
			//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							count(*) as count
						from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						 prj.module_id != '' and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.start_day desc, 
						prj.start_date desc, 
						prj.display_order desc,
						prj.num_clicks desc				
						";						
						
					 
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
				$stmt->execute();
		
				if ($row = $stmt->fetch()) {
					$count = $row["count"];
				}
				 			 
			//return $displayHTML;
			return $count;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	
	
	function displayFileResourcesWithOutModuleIdCount($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
 
			//logToFile("userId $userId , so check only for products belonging to user"); 
				$sql = "select 
							count(*) as count						 
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and						 
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.start_day desc, 
						prj.start_date desc, 
						prj.display_order desc,
						prj.num_clicks desc
									
						";						
						
					 
				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
				$stmt->execute();
		
				if ($row = $stmt->fetch()) {
					$count = $row["count"];
				}
				 			 
			//return $displayHTML;
			return $count;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	
	function displayFileResourcesWithLessons($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.start_day,
						prj.start_date,
						prj.num_clicks,
						prj.is_free,
					    prj.credits_assigned,
						prj.display_order as do
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and						 
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.display_order desc,
						prj.start_day desc, 
						prj.start_date desc, 						
						prj.num_clicks desc
						";

			logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);			 
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			$module_id= 0;
			logToFile("DAP_Products.class.php: sss=".$sss);
			logToFile("DAP_Products.class.php: isSSSMaster=".$isSSSMaster);
			$displayHTML = "
			  <div class='sortableFileListHeader'>
				   <ul class='ui-sortable' >
					  <li class='sortable_file_resource'>
					  <span class='sortable_file_resource1' style='width:40px; float:left'><strong>Edit</strong></span>";
			 
			 if(($sss!="Y") || ($isSSSMaster=="Y")) {		
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";
			 }
			 else {	
				 $displayHTML .= "<span class='sortable_file_resource5' style='width:40px; float:left; text-align: center;'><strong>Credits</strong></span>";	
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";				  
			  }
			  
			  $displayHTML .=	"<span class='sortable_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\"  onClick=\"javascript:removeAllFileResourcesFromProductNew( '" .$module_id. "'); return false;\"
			   title=\"Delete all lessons from this Product\"><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					  <span class='sortable_file_resourceurl' style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div class='sortableFileList'>
				<ul class='modul_listing  ui-droppable ui-sortable' id='mod_".$module_id."' >";
			
			
			$dataFound = false;
			
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$num_clicks = $row["num_clicks"];
				$is_free = $row["is_free"];
				$do = $row["do"];
				$credits = $row["credits_assigned"];
				$module_id= 0;
				if ($credits == "") $credits=0;
				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				} else if( ($num_clicks != "") && ($num_clicks != 0) ){
					$whichOne = $num_clicks . " (clicks)";
				}
				
				$urlShort = trimString($url,80,50,30);

				$displayHTML .= "<li id='recordsArray_".$id."' class='records_file_resource'>
				<span class='records_file_resource1' style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'>
				<i class=\"fa fa-pencil-square-o\" aria-hidden=\"true\"></i></a></span>";
				
				if(($sss!="Y") || ($isSSSMaster=="Y")) {
				  $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
				}
				else {				   
				   $displayHTML .= "<span class='records_file_resource5' style='width:40px; float:left'>$credits</span>";
				   $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
			    }
				$displayHTML .= "<span class='records_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProductNew('" .$id. "',  '" .$module_id. "'); return false;\" title=\"Delete this lesson from this Product\">
				<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
				<span class='records_file_resource4' style='display:block; overflow:auto; ' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>
				";
			
			  
			}
 
			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no lessons assigned to this module.</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	
	function displayFileResourcesNewType($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.start_day,
						prj.start_date,
						prj.num_clicks,
						prj.is_free,
					    prj.credits_assigned,
						prj.display_order as do
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and						 
						prj.resource_id = fr.id and
						prj.resource_type = 'F'
					order by
						prj.display_order desc,
						prj.start_day desc, 
						prj.start_date desc, 
						prj.num_clicks desc
						";

			logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);			 
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			$module_id= 0;
			logToFile("DAP_Products.class.php: sss=".$sss);
			logToFile("DAP_Products.class.php: isSSSMaster=".$isSSSMaster);
			$displayHTML = "
			  <div class='sortableFileListHeader'>
				    <ul class='ui-sortable' >
					  <li class='sortable_file_resource'>
					  <span class='sortable_file_resource1' style='width:40px; float:left'><strong>Edit</strong></span>";
			 
			 if(($sss!="Y") || ($isSSSMaster=="Y")) {		
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";
			 }
			 else {	
				 $displayHTML .= "<span class='sortable_file_resource5' style='width:40px; float:left; text-align: center;'><strong>Credits</strong></span>";	
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";				  
			  }
			  
			  $displayHTML .=	"<span class='sortable_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\"  onClick=\"javascript:removeAllFileResourcesFromProductNew( '" .$module_id. "'); return false;\"
			   title=\"Delete all lessons from this Product\"><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					  <span class='sortable_file_resourceurl' style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div class='sortableFileList'>
				<ul class='resource_listing  ui-droppable ui-sortable'  >";
			
			
			$dataFound = false;
			
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$num_clicks = $row["num_clicks"];
				$is_free = $row["is_free"];
				$do = $row["do"];
				$credits = $row["credits_assigned"];
				$module_id= 0;
				if ($credits == "") $credits=0;
				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				} else if( ($num_clicks != "") && ($num_clicks != 0) ){
					$whichOne = $num_clicks . " (clicks)";
				}
				
				$urlShort = trimString($url,80,50,30);

				$displayHTML .= "<li id='recordsArray_".$id."' class='records_file_resource'>
				<span class='records_file_resource1' style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'>
				<i class=\"fa fa-pencil-square-o\" aria-hidden=\"true\"></i></a></span>";
				
				if(($sss!="Y") || ($isSSSMaster=="Y")) {
				  $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
				}
				else {				   
				   $displayHTML .= "<span class='records_file_resource5' style='width:40px; float:left'>$credits</span>";
				   $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
			    }
				$displayHTML .= "<span class='records_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProductNew('" .$id. "',  '" .$module_id. "'); return false;\" title=\"Delete this lesson from this Product\">
				<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
				<span class='records_file_resource4' style='display:block; overflow:auto; ' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>
				";
			
			  
			}
 
			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no resources assigned to this product.</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	
	function displayFileResourcesConditionalNewType($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			
			$sql = "select
						fr.id,
						fr.url,
						prj.display_order,
						prj.cond_drip_order,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'  
					order by
						prj.cond_drip_order, prj.display_order desc, fr.id";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			logToFile("DAP_Products.class.php: conditional drip product");
			$displayHTML = "
			  <div id='sortableFileListHeader'>
				  <ul class='ui-sortable' >
					  <li>
					  <span style='width:35px; float:left'><strong>Edit</strong></span>";
			 
			$displayHTML .= "<span style='width:93px; float:left;'><strong>Conditional<br> Drip Order</strong></span>";
		
			  
			$displayHTML .=	"<span style='width:30px; float:left;'><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\" title=\"Delete all protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"20\" height=\"20\" style='align: middle'></a></span>
					  <span style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div class='sortableFileList'>
				<ul class='resource_listing  ui-droppable ui-sortable'  >";
			
			$dataFound = false;
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				if(isset($row["cond_drip_order"]))
					$cond_drip_order = floatval($row["cond_drip_order"]);
				$display_order = $row["display_order"];
				
				//$urlShort = $url;
				$urlShort = trimString($url,80,50,30);
 
				$displayHTML .= "<li id='recordsArray_".$id."' style='overflow: hidden;clear:both' >
				<span style='width:35px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'><img src='/dap/images/edit.png' width='12' height='12' style='align:absmiddle' border='0'/></a></span>";
				
				If (!isset($cond_drip_order))
					$cond_drip_order=1;
					
				$displayHTML .= "<span style='width: 20px; float: left;  display: inline-block; margin-right: 18px;'><input type='text' style='width: 25px; height: 12px;' name='condorder_".$id. "' id='condorder_".$id. "' size=4 value=". $cond_drip_order . "></span>
				<span style='width:50px; float:left'><a href=\"#\" onClick=\"javascript:updateCondContentOrderProduct('" .$id. "',document.getElementById('condorder_".$id."').value); return false;\" title=\"Update\"><img src=\"/dap/images/updatesmall.png\" border=\"0\" width=\"14\" height=\"14\" align=\"absmiddle\"></a></span>";
				$displayHTML .= "<span style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title=\"Delete this protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"14\" height=\"14\" align=\"absmiddle\"></a></span>";
				$displayHTML .= "<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>";
			  
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Files currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function displayFileResourcesConditionalWithModuleId($productId, $module_id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			
			$sql = "select
						fr.id,
						fr.url,
						prj.display_order,
						prj.cond_drip_order,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.module_id = :module_id and
						prj.resource_id = fr.id and
						prj.resource_type = 'F'  
					order by
						prj.cond_drip_order, prj.display_order desc, fr.id";

			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_STR);
			$stmt->execute();

			$product = DAP_Product::loadProduct($productId); //loads product details from db
			if(isset($product)) {
			  $isSSSMaster=$product->getIs_master();
			  $sss=$product->getSelf_service_allowed();
			  $allowContentLevelCredits=$product->getAllowContentLevelCredits();
			//  $allowContentLevelCredits=$product->setAllowContentLevelCredits();
			}
			logToFile("DAP_Products.class.php: conditional drip product");
			$displayHTML = "
			  <div id='sortableFileListHeader'>
				  <ul>
					  <li>
					  <span style='width:35px; float:left'><strong>Edit</strong></span>";
			 
			$displayHTML .= "<span style='width:93px; float:left;'><strong>Conditional<br> Drip Order</strong></span>";
		
			  
			$displayHTML .=	"<span style='width:30px; float:left;'><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\" title=\"Delete all protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"20\" height=\"20\" style='align: middle'></a></span>
					  <span style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div id='sortableFileList'>
				<ul>";
			
			$dataFound = false;
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				if(isset($row["cond_drip_order"]))
					$cond_drip_order = floatval($row["cond_drip_order"]);
				$display_order = $row["display_order"];
				
				//$urlShort = $url;
				$urlShort = trimString($url,80,50,30);
 
				$displayHTML .= "<li id='recordsArray_".$id."' style='overflow: hidden;clear:both' >
				<span style='width:35px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'><img src='/dap/images/edit.png' width='12' height='12' style='align:absmiddle' border='0'/></a></span>";
				
				If (!isset($cond_drip_order))
					$cond_drip_order=1;
					
				$displayHTML .= "<span style='width: 20px; float: left;  display: inline-block; margin-right: 18px;'><input type='text' style='width: 25px; height: 12px;' name='condorder_".$id. "' id='condorder_".$id. "' size=4 value=". $cond_drip_order . "></span>
				<span style='width:50px; float:left'><a href=\"#\" onClick=\"javascript:updateCondContentOrderProduct('" .$id. "',document.getElementById('condorder_".$id."').value); return false;\" title=\"Update\"><img src=\"/dap/images/updatesmall.png\" border=\"0\" width=\"14\" height=\"14\" align=\"absmiddle\"></a></span>";
				$displayHTML .= "<span style='width:30px; float:left'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title=\"Delete this protected content from this Product\"><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"14\" height=\"14\" align=\"absmiddle\"></a></span>";
				$displayHTML .= "<span style='display:block; overflow:auto; background-color:#EFEFEF;' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>";
			  
			}

			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no Files currently assigned to this Product</li>";
			}
			
			$displayHTML .= "</ul></div>";

			//return $displayHTML;
			return mb_convert_encoding($displayHTML, "UTF-8", "auto");
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	

	function displayFileResourcesSSSNewType($productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.credits_assigned,
						prj.display_order,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.resource_id = fr.id and
						prj.resource_type = 'F' and
						prj.credits_assigned > 0
					order by
						prj.display_order desc";
						
			//logToFile($sql,LOG_DEBUG_DAP);
			logToFile("Dap_Product.class.php.displayFileResourcesSSS(): productId=". $productId,LOG_DEBUG_DAP);
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->execute();
 
			$module_id= 0;
			logToFile("DAP_Products.class.php: sss=".$sss);
			logToFile("DAP_Products.class.php: isSSSMaster=".$isSSSMaster);
			$displayHTML = "
			  <div class='sortableFileListHeader'>
				  <ul >
					  <li class='sortable_file_resource'>
					  <span class='sortable_file_resource1' style='width:40px; float:left'><strong>Edit</strong></span>";
			 
			 if(($sss!="Y") || ($isSSSMaster=="Y")) {		
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";
			 }
			 else {	
				 $displayHTML .= "<span class='sortable_file_resource5' style='width:40px; float:left; text-align: center;'><strong>Credits</strong></span>";	
				 $displayHTML .= "<span class='sortable_file_resource2' style='width:70px; float:left; text-align: center;'><strong>Drip Day</strong></span>";				  
			  }
			  
			  $displayHTML .=	"<span class='sortable_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\"  onClick=\"javascript:removeAllFileResourcesFromProductNew( '" .$module_id. "'); return false;\"
			   title=\"Delete all lessons from this Product\"><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
					  <span class='sortable_file_resourceurl' style='display:block; overflow:auto;'><strong>URL of Protected Content</strong></span>
					  </li>
				  </ul>
			  </div>
			  ";
						
			$displayHTML .= "<div class='sortableFileList'>
				<ul class='resource_listing  ui-droppable ui-sortable'  >";
			
			
			$dataFound = false;
			
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				$dataFound = true;
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$start_day = $row["start_day"];
				$start_date = $row["start_date"];
				$num_clicks = $row["num_clicks"];
				$is_free = $row["is_free"];
				$do = $row["do"];
				$credits = $row["credits_assigned"];
				$module_id= 0;
				if ($credits == "") $credits=0;
				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				if( ($start_day != "") && ($start_day != 0) ){
					$whichOne = $start_day;
				} else if( ($start_date != "") && ($start_date != 0) ){
					$whichOne = $start_date;
				} else if( ($num_clicks != "") && ($num_clicks != 0) ){
					$whichOne = $num_clicks . " (clicks)";
				}
				
				$urlShort = trimString($url,80,50,30);

				$displayHTML .= "<li id='recordsArray_".$id."' class='records_file_resource'>
				<span class='records_file_resource1' style='width:40px; float:left'>&nbsp;&nbsp;<a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings. Click & Drag to re-arrange order within a given drip day'>
				<i class=\"fa fa-pencil-square-o\" aria-hidden=\"true\"></i></a></span>";
				
				if(($sss!="Y") || ($isSSSMaster=="Y")) {
				  $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
				}
				else {				   
				   $displayHTML .= "<span class='records_file_resource5' style='width:40px; float:left'>$credits</span>";
				   $displayHTML .= "<span class='records_file_resource2' style='width:70px; float:left; text-align: center;'>$whichOne</span>";
			    }
				$displayHTML .= "<span class='records_file_resource3' style='width:50px; float:left; text-align: center; margin-top: 4px;'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProductNew('" .$id. "',  '" .$module_id. "'); return false;\" title=\"Delete this lesson from this Product\">
				<i class=\"fa fa-trash\" aria-hidden=\"true\"></i></a></span>
				<span class='records_file_resource4' style='display:block; overflow:auto; ' title='$url'><a href='$url' target='_blank'>$urlShort</a></span>
				</li>
				";
			
			  
			}
 
			if($dataFound == false) {
				$displayHTML .= "<li class='no_data'>There are no resources assigned to this product.</li>";
			}
			
			$displayHTML .= "</ul></div>";
			

			return $displayHTML;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
	function displayFileResourcesSSSWithModuleId($productId, $module_id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "select
						fr.id,
						fr.url,
						prj.credits_assigned,
						prj.display_order,
						prj.is_free
					from
						dap_products_resources_jn prj,
						dap_file_resources fr
					where
						prj.product_id = :productId and
						prj.module_id = :module_id and
						prj.resource_id = fr.id and
						prj.resource_type = 'F' and
						prj.credits_assigned > 0
					order by
						prj.display_order desc";
						
			//logToFile($sql,LOG_DEBUG_DAP);
			logToFile("Dap_Product.class.php.displayFileResourcesSSS(): productId=". $productId,LOG_DEBUG_DAP);
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_STR);
			$stmt->execute();

			$displayHTML = "<table width='100%' cellspacing='0' cellpadding='3'>
			<tr align='center' bgcolor=\"#EFEFEF\" class=\"bodytext\">
				<td>&nbsp;</td>
				<td align='center'><b>Credits</b></td>
				<td align='center'><b>Display<br/>Order</b></td>
				<td align='center'><b>URL</b></td>
				<td><a href=\"#\" onClick=\"javascript:removeAllFileResourcesFromProduct(); return false;\" title='Delete all protected content from this Product'><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
			$bgcolor = "#EEEEEE";
			while ($row = $stmt->fetch()) {
				if($bgcolor == "#FFFFFF") {
					$bgcolor = "#EEEEEE";
				} else if ($bgcolor == "#EEEEEE") {
					$bgcolor = "#FFFFFF";
				}
				$id = $row["id"];
				$url = $row["url"];
				$credits_assigned = $row["credits_assigned"];
				$display_order = $row["display_order"];
				$is_free = $row["is_free"];

				//logToFile("$start_day, $start_date, $num_clicks",LOG_DEBUG_DAP);

				$whichOne = "";

				$displayHTML .= "<tr align='left' bgcolor=\"$bgcolor\" class=\"bodytext\">
				<td width='30'><a href=\"#\" onClick=\"loadFileResource('" . $id . "'); clearDiv('file_resource_message'); return false;\" title='Click to edit drip settings'>edit</a></td>
				<td align='center'>$credits_assigned</td>
				<td align='center'>$display_order</td>
				<td><a href='$url' target='_blank' title='Click to open in a new window'>$url</a></td>
				<td width='20' align='center'><a href=\"#\" onClick=\"javascript:removeFileResourceFromProduct('" .$id. "'); return false;\" title='Delete this protected content from this Product'><img src=\"/dap/images/ximage.jpg\" border=\"0\" width=\"13\" height=\"13\"></a></td>
				</tr>";
			}

			if($displayHTML == "<table width='100%' cellspacing='0' cellpadding='5'>") {
				$displayHTML = "<tr align='left'><td colspan='4'>There are no Files currently assigned to this Product</td></tr>";
			} else {
				$displayHTML .= "</table>";
			}

			return $displayHTML;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
		}
	}
	
    public static function loadProductsByFilters($all = '', $subscription = '', $one_time = '', $free_product = '', $payment_plan = '',$id_desc = '',$id_asc = '',$name_desc = '',$name_asc = ''){		
		
		$ProductsList = null;	
        $sql = "select * from dap_products";
		if($all == 'all'){
			$sql = "select * from dap_products";
		}else{
			$sql = "select * from dap_products ";
			$where_status = " where ";
			if($subscription != ''){
				$sql .= $where_status ." is_recurring = '".$subscription."'  AND is_free_product='N' "; 
				$where_status = " OR ";
			}
			if($one_time != ''){
				$sql .= $where_status ." (is_free_product = 'N' AND is_recurring = 'N')"; 
				$where_status = " OR ";
			}
			if($free_product != ''){
				$sql .= $where_status ." is_free_product = '".$free_product."'"; 
				$where_status = " OR ";
			}
			if($payment_plan != ''){
				$sql .= $where_status ." (is_free_product = 'N' AND is_recurring = 'Y' AND total_occur	< $payment_plan ".")"; 
				$where_status = " OR ";
			}	
		}
		
		$orderby_status = ' ORDER BY ';
		if($id_desc != ''){
			$sql .= $orderby_status ." id DESC"; 
			$orderby_status = " , ";
		}	

		if($id_asc != ''){
			$sql .= $orderby_status ." id ASC"; 
			$orderby_status = " , ";
		}	
		if($name_desc != ''){
			$sql .= $orderby_status ." name DESC"; 
			$orderby_status = " , ";
		}	
		if($name_asc != ''){
			$sql .= $orderby_status ." name ASC"; 
			$orderby_status = " , ";
		}				
       logToFile("sql_filter:- ".$sql);
      
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$product = new Dap_Product();
				$product->setId( $row["id"] );
				$product->setName( stripslashes($row["name"]) );
				$product->setDescription( stripslashes($row["description"]) );
				$product->setError_page_url( stripslashes($row["error_page_url"]) );
				$product->setIs_recurring( stripslashes($row["is_recurring"]) );
				$product->setPrice( $row["price"] );
				$product->setTrial_price( $row["trial_price"] );
				$product->setPrice_increment( $row["price_increment"] );
				$product->setPrice_increment_ceil( $row["price_increment_ceil"] );
				$product->setNum_sales( $row["num_sales"] );
				$product->setNum_days( $row["num_days"] );
				$product->setTimed_pricing_start_date( $row["timed_pricing_start_date"] );
				$product->setSelfservice_start_date( $row["selfservice_start_date"] );
				$product->setSelfservice_end_date( $row["selfservice_end_date"] );
				$product->setTotal_occur( $row["total_occur"] );
				$product->setRecurring_cycle_1( $row["recurring_cycle_1"] );
				$product->setRecurring_cycle_2( $row["recurring_cycle_2"] );
				$product->setRecurring_cycle_3( $row["recurring_cycle_3"] );
				$product->setStatus( $row["status"] );
				$product->setNotification_id( $row["notification_id"] );
				$product->setThankyou_page_url( stripslashes($row["thankyou_page_url"]) );
				$product->setThirdPartyEmailIds( stripslashes($row["thirdPartyEmailIds"]) );
				$product->setSubscribeTo( stripslashes($row["subscribe_to"]) );
				$product->setUnsubscribeFrom( stripslashes($row["unsubscribe_from"]) );
				$product->setSales_page_url( stripslashes($row["sales_page_url"]) );
				$product->setSelf_service_allowed( stripslashes($row["self_service_allowed"]) );
				$product->setIs_master( stripslashes($row["is_master"]) );
				$product->setAllowContentLevelCredits( stripslashes($row["allowContentLevelCredits"]) );
				$product->setProduct_image_url( stripslashes($row["product_image_url"]) );
				$product->setCredits( stripslashes($row["credits"]) );
				$product->setDouble_optin_subject( stripslashes($row["double_optin_subject"]) );
				$product->setDouble_optin_body( stripslashes($row["double_optin_body"]) );
				$product->setThankyou_email_subject( stripslashes($row["thankyou_email_subject"]) );
				$product->setThankyou_email_body( stripslashes($row["thankyou_email_body"]) );
				$product->setLogged_in_url( stripslashes($row["logged_in_url"]) );
				$product->setIs_free_product( stripslashes($row["is_free_product"]) );
				$product->setAllow_free_signup( stripslashes($row["allow_free_signup"]) );
				$product->setRecurringCredits( stripslashes($row["recurring_credits"]) );
				$product->setShortDescription( stripslashes($row["short_description"]) );
				$product->setLongDescription( stripslashes($row["long_description"]) );
				$product->setResellProduct( stripslashes($row["resell_product"]) );
				$product->setAllowAccessToFutureContent( stripslashes($row["future_content_access"]) );
				$product->setProductImageUrlLinkedTo( stripslashes($row["product_image_url_linkedto"]) );
				$product->setAccessExpirationAction( stripslashes($row["access_expiration_action"]) );
				$product->setRenewal_redirect_url( stripslashes($row["renewal_redirect_url"]) );
				$product->setRenewal_html( stripslashes($row["renewal_html"]) );
				$product->setAccessUponFinalPayment( stripslashes($row["access_upon_final_payment"]) );
				$product->setBuyLink( stripslashes($row["buy_link"]) );
				$product->setShowBuyLink( stripslashes($row["show_buy_link"]) );
				$product->setDrip_type( stripslashes($row["drip_type"]) );
				$product->setMember_product_links_url( stripslashes($row["member_product_links_url"]) );

				$product->setStripe_payment_retry_subject( stripslashes($row["stripe_payment_retry_subject"]) );
				$product->setStripe_payment_retry_body( stripslashes($row["stripe_payment_retry_body"]) );
				$product->setStripe_final_retry_subject( stripslashes($row["stripe_final_retry_subject"]) );
				$product->setStripe_final_retry_body( stripslashes($row["stripe_final_retry_body"]) );
				$product->setStripe_failed_payment_cancellation_subject( stripslashes($row["stripe_failed_payment_cancellation_subject"]) );
				$product->setStripe_failed_payment_cancellation_body( stripslashes($row["stripe_failed_payment_cancellation_body"]) );
				
				$product->setFreeTrial( stripslashes($row["free_trial"]) );
				$product->setLastPaymentAccess( stripslashes($row["last_payment_access"]) );
				$product->setLastPaymentDays( stripslashes($row["last_payment_days"]) );
				$product->setProductType( stripslashes($row["product_type"]) );
			    $product->setProductStructure( stripslashes($row["product_structure"]) );
			    $product->setCourseEmailSubject( stripslashes($row["course_email_subject"]) );
				$product->setCourseEmailBody( stripslashes($row["course_email_body"]) );
				$product->setModuleEmailSubject( stripslashes($row["module_email_subject"]) );
				$product->setModuleEmailBody( stripslashes($row["module_email_body"]) );
				$product->setLessonEmailSubject( stripslashes($row["lesson_email_subject"]) );
				$product->setLessonEmailBody( stripslashes($row["lesson_email_body"]) );
				$product->setOfferTrial( stripslashes($row["offer_trial"]) );
				$product->setCourseProgress( stripslashes($row["course_progress"]) );	
				$product->setCourseCompleteMessage( stripslashes($row["course_complete_message"]) );			
				$product->setModuleCompleteMessage( stripslashes($row["module_complete_message"]) );			
				$product->setLessonCompleteMessage( stripslashes($row["lesson_complete_message"]) );	
				$product->setLastPaymentAccess($row["last_payment_access"]);
				$product->setLastPaymentDays($row["last_payment_days"]);
				//$product->setQuantity( stripslashes($row["quantity"]) );
				$ProductsList[] = $product;
			}

			return $ProductsList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
    
	public static function copyResourcesWithModuleP2P($srcProductId, $destProductId,$srcmoduleId =0,$destmoduleId = 0) {
		
		
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction(); //begin the transaction
			
			//TODO: check if both source and destination products exists.					
			
			/*
				Lets get all product-resource rows for the src product id.				
			*/
			$sql = "SELECT 
						resource_id, 
						is_free, 
						start_day, 
						end_day, 
						start_date, 
						end_date,
						num_clicks,
						resource_type, 
						status,
						credits_assigned, 
						sss_enabled, 
						excerpt, 
						display_order,
						module_id 
					FROM
						dap_products_resources_jn prj
					WHERE
						prj.product_id = :productId AND prj.module_id = :srcmoduleId";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':productId', $srcProductId, PDO::PARAM_INT);
			$stmt->bindParam(':srcmoduleId', $srcmoduleId, PDO::PARAM_INT);
			$stmt->execute();
			$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

			foreach ($results as $key => $row) {
				//Lets insert into products resources join table.
				try {
					$sql2 = "insert into dap_products_resources_jn
								(product_id, resource_id, is_free, start_day, end_day, 
								start_date, end_date, num_clicks, resource_type, status, credits_assigned, sss_enabled, excerpt, display_order, module_id)
								values(:product_id, :resource_id, :is_free, :start_day, :end_day,
								:start_date, :end_date, :num_clicks, :resource_type, :status, :credits_assigned, :sss_enabled, :excerpt, :display_order, :module_id)";		
					$stmt2 = $dap_dbh->prepare($sql2);
					$stmt2->bindParam(':product_id', $destProductId, PDO::PARAM_INT);
					$stmt2->bindParam(':resource_id', $row['resource_id'], PDO::PARAM_INT);
					$stmt2->bindParam(':is_free', $row['is_free'], PDO::PARAM_STR);
					$stmt2->bindParam(':start_day', $row['start_day'], PDO::PARAM_INT);
					$stmt2->bindParam(':end_day', $row['end_day'], PDO::PARAM_INT);
					$stmt2->bindParam(':start_date', $row['start_date'], PDO::PARAM_STR);
					$stmt2->bindParam(':end_date', $row['end_date'], PDO::PARAM_STR);
					$stmt2->bindParam(':num_clicks', $row['num_clicks'], PDO::PARAM_INT);
					$stmt2->bindParam(':resource_type', $row['resource_type'], PDO::PARAM_STR);
					$stmt2->bindParam(':status', $row['status'], PDO::PARAM_STR);
					$stmt2->bindParam(':credits_assigned', $row['credits_assigned'], PDO::PARAM_INT);
					$stmt2->bindParam(':sss_enabled', $row['sss_enabled'], PDO::PARAM_STR);
					$stmt2->bindParam(':excerpt', $row['excerpt'], PDO::PARAM_STR);
					$stmt2->bindParam(':display_order', $row['display_order'], PDO::PARAM_INT);
					$stmt2->bindParam(':module_id', $destmoduleId, PDO::PARAM_INT);
					$stmt2->execute();	
				} catch (PDOException $e) {
					logToFile($e->getMessage());
					throw $e;
				} catch (Exception $e) {
					logToFile($e->getMessage());
					throw $e;
				}		
			}
			
			$dap_dbh->commit(); //commit the transaction
			$stmt = null;
			$dap_dbh = null;
			//return "<b>SUCCESS: File '" . $file . "' <br/>has been added to this product</b><br/><br/>";
		} catch (PDOException $e1) { 
			$dap_dbh->rollback();
			logToFile($e1->getMessage(),LOG_FATAL_DAP);
			throw $e1;
		} catch (Exception $e1) {
			$dap_dbh->rollback();
			logToFile($e1->getMessage(),LOG_FATAL_DAP);
			throw $e1;
		}	
	}
	
    public static function loadProductByProductType($product_type) {
		$dap_dbh = Dap_Connection::getConnection();
		$ProductsList = array();
	
		//Load product details from database
		$sql = "select *
			from
				dap_products
			where
				product_type = :product_type";
		
	 
		try {
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':product_type', $product_type, PDO::PARAM_STR);
			$stmt->execute();
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product = new Dap_Product();
				$product->setId( $row["id"] );
				$product->setName( stripslashes($row["name"]) );
				$product->setDescription( $row["description"] );
				 
				$ProductsList[] = $product;
			}
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

		return $ProductsList;
	}
     
	function displayFileResourcesWithModuleIdCourseId($productId , $module_id) {
			$ProductsList = array();
			try {
				$dap_dbh = Dap_Connection::getConnection();

				$sql = "select
							fr.id,
							fr.url,
							fr.name,
							prj.start_day,
							prj.start_date,
							prj.num_clicks,
							prj.is_free,
							prj.credits_assigned,
							prj.display_order as do
						from
							dap_products_resources_jn prj,
							dap_file_resources fr
						where
							prj.product_id = :productId and
							prj.module_id = :module_id and
							prj.resource_id = fr.id and
							prj.resource_type = 'F'
						order by
							prj.display_order desc,
							prj.start_day desc, 
							prj.start_date desc, 							
							prj.num_clicks desc
							";

				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);
				$stmt->bindParam(':module_id', $module_id, PDO::PARAM_STR);
				$stmt->execute();
		 
				while ($row = $stmt->fetch()) {			 
					$ProductsList[] = $row;		  
				}
	 
				return $ProductsList;
			} catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_DEBUG_DAP);
				return $e->getMessage();
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_DEBUG_DAP);
				return $e->getMessage();
			}
		}
		
	function displayFileResourcesWithCourseId($productId) {
			$ProductsList = array();
			try {
				$dap_dbh = Dap_Connection::getConnection();

				$sql = "select
							fr.id,
							fr.url,
							fr.name,
							prj.start_day,
							prj.start_date,
							prj.num_clicks,
							prj.is_free,
							prj.credits_assigned,
							prj.module_id,
							prj.display_order as do
						from
							dap_products_resources_jn prj,
							dap_file_resources fr
						where
							prj.product_id = :productId and
							prj.resource_id = fr.id and
							prj.resource_type = 'F'
						order by
							prj.display_order desc,
							prj.start_day desc, 
							prj.start_date desc, 							
							prj.num_clicks desc
							";

				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);				 
				$stmt->execute();
		 
				while ($row = $stmt->fetch()) {			 
					$ProductsList[] = $row;		  
				}
	 
				return $ProductsList;
			} catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_DEBUG_DAP);
				return $e->getMessage();
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_DEBUG_DAP);
				return $e->getMessage();
			}
		}
		
		
		function displayFileResourcesWithCourseIdLessonId($productId, $resource_id) {
			$ProductsList = array();
			try {
				$dap_dbh = Dap_Connection::getConnection();

				$sql = "select
							fr.id,
							fr.url,
							fr.name,
							prj.start_day,
							prj.resource_id,
							prj.start_date,
							prj.num_clicks,
							prj.is_free,
							prj.credits_assigned,
							prj.module_id,
							prj.display_order as do
						from
							dap_products_resources_jn prj,
							dap_file_resources fr
						where
							prj.product_id = :productId and
							fr.id = :resource_id and
							prj.resource_id = fr.id and
							prj.resource_type = 'F'
						order by
							prj.display_order desc,
							prj.start_day desc, 
							prj.start_date desc,							
							prj.num_clicks desc
							";

				//logToFile($sql,LOG_DEBUG_DAP);
				$stmt = $dap_dbh->prepare($sql);
				$stmt->bindParam(':productId', $productId, PDO::PARAM_STR);				 
				$stmt->bindParam(':resource_id', $resource_id, PDO::PARAM_STR);				 
				$stmt->execute();
		 
				while ($row = $stmt->fetch()) {			 
					$ProductsList[] = $row;	
					return $row;	  
				}
	 
				
			} catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_DEBUG_DAP);
				return $e->getMessage();
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_DEBUG_DAP);
				return $e->getMessage();
			}
		}
		
		
}
