<?php 
class Dap_ProductRoleMapping{
	
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }	
    
    function getRoleId() {
        return $this->role_id;
    }
    function setRoleId($o) {
        $this->role_id = $o;
    }	
    
    function getProductId() {
        return $this->product_id;
    }
    function setProductId($o) {
        $this->product_id = $o;
    }	
    
    function getNumber() {
        return $this->number;
    }
    function setNumber($o) {
        $this->number = $o;
    }	
    
     
    function create(){
		//logToFile("Dap_ProductRoleMapping.class.php: create method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "INSERT INTO dap_product_role_mapping
					(product_id,role_id, number) VALUES
					(:product_id, :role_id , :number)";
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
			$stmt->bindParam(':role_id', $this->getRoleId(), PDO::PARAM_INT);
			$stmt->bindParam(':number', $this->getNumber(), PDO::PARAM_INT);
			$stmt->execute();
		
			return $dap_dbh->lastInsertId();
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductRoleMapping.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductRoleMapping.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductRoleMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
	}
	
	
	function update(){
	//	logToFile("Dap_ProductRoleMapping.class.php: update() method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_product_role_mapping
					SET product_id = :product_id,role_id = :role_id, number = :number WHERE id=:id";
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
			$stmt->bindParam(':role_id', $this->getRoleId(), PDO::PARAM_INT);
			$stmt->bindParam(':number', $this->getNumber(), PDO::PARAM_INT);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductRoleMapping.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductRoleMapping.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		
		logToFile("Dap_ProductRoleMapping.class.php: update() exit ", LOG_DEBUG_DAP);
	}
	
	
	function delete(){
	//	logToFile("Dap_ProductRoleMapping.class.php: delete() method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "DELETE FROM
						dap_product_role_mapping
					WHERE
						id=:id";
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductRoleMapping.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductRoleMapping.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		
		logToFile("Dap_ProductRoleMapping.class.php: delete() exit ", LOG_DEBUG_DAP);
	}
	
	
	public static function load(){
		//logToFile("Dap_ProductRoleMapping.class.php: load method called ", LOG_DEBUG_DAP);
		$productRoleArr = array();
	
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_product_role_mapping ORDER BY number asc";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product_role = new Dap_ProductRoleMapping();
				
				$product_role->setId($row['id']);
				$product_role->setProductId($row['product_id']);
				$product_role->setRoleId($row['role_id']);
				$product_role->setNumber($row['number']);	
				$productRoleArr[] = $product_role;
			}
			return $productRoleArr;
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductRoleMapping.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductRoleMapping.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductRoleMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	public static function loadByProductId($pid , $id){
	//	logToFile("Dap_ProductRoleMapping.class.php: loadByProductId method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			if($id != ''){
				$sql = "SELECT * FROM dap_product_role_mapping WHERE product_id = :product_id AND id != :id";	
			}else{
				$sql = "SELECT * FROM dap_product_role_mapping WHERE product_id = :product_id";		
			}
			
			$stmt = $dap_dbh->prepare($sql);
			
			if($id != ''){
			
				$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			}
			$stmt->bindParam(':product_id', $pid, PDO::PARAM_INT);
			
			$stmt->execute();
			
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product_role = new Dap_ProductRoleMapping();
				$product_role->setId($row['id']);
				$product_role->setProductId($row['product_id']);
				$product_role->setRoleId($row['role_id']);
				$product_role->setNumber($row['number']);
				
			}
			
			return $product_role;
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductRoleMapping.class.php: loadByProductId(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductRoleMapping.class.php: loadByProductId(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductRoleMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	
	public static function loadByPriority($number , $id){
	//	logToFile("Dap_ProductRoleMapping.class.php: loadByPriority method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			if($id != ''){
				$sql = "SELECT * FROM dap_product_role_mapping WHERE number = :number AND id != :id";			
			}else{
				$sql = "SELECT * FROM dap_product_role_mapping WHERE number = :number";		
			}
			
				
			$stmt = $dap_dbh->prepare($sql);
			if($id != ''){
				$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			}
			$stmt->bindParam(':number', $number, PDO::PARAM_INT);
			$stmt->execute();
			
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product_role = new Dap_ProductRoleMapping();
				
				$product_role->setId($row['id']);
				$product_role->setProductId($row['product_id']);
				$product_role->setRoleId($row['role_id']);
				$product_role->setNumber($row['number']);	
			}
			return $product_role;
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductRoleMapping.class.php: loadByPriority(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductRoleMapping.class.php: loadByPriority(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductRoleMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
}
