<?php


class Dap_Reports extends Dap_Base {
	
	var $id;
	var $product_id;
	var $user_id;
   	var $trans_id;
   	var $trans_type;
   	
	var $subscription_id;
	var $payment_status;
   	var $payment_currency;
	var $payment_value;
	var $payer_email;
   	var $sub_trans_num = 0;
   	var $payment_processor;
	
	var $transaction_start_date;
	var $cancellation_date;
	var $refund_date;
	
   	var $time;
   		
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getUser_id() {
	        return $this->user_id;
	}
	
	function setUser_id($o) {
	      $this->user_id = $o;
	}
	
	function getProduct_id() {
	        return $this->product_id;
	}
	
	function setProduct_id($o) {
	      $this->product_id = $o;
	}	
	
	function getTrans_id() {
	        return $this->trans_id;
	}
	
	function setTrans_id($o) {
	      $this->trans_id= $o;
	}
	
	function getTrans_type() {
	        return $this->trans_type;
	}
	
	function setTrans_type($o) {
	      $this->trans_type = $o;
	}
	
	function getSubscription_id() {
	        return $this->subscription_id;
	}
	
	function setSubscription_id($o) {
	      $this->subscription_id = $o;
	}
	
	function getPayment_status() {
	        return $this->payment_status;
	}
	
	function setPayment_status($o) {
	      $this->payment_status = $o;
	}
	
	function getPayment_currency() {
	        return $this->payment_currency;
	}
	
	function setPayment_currency($o) {
	      $this->payment_currency = $o;
	}
	
	function getPayment_value() {
	        return $this->payment_value;
	}
	
	function setPayment_value($o) {
	      $this->payment_value = $o;
	}	

	function getPayer_email() {
	        return $this->payer_email;
	}
	
	function setPayer_email($o) {
	      $this->payer_email = $o;
	}
	
	function getPayment_processor() {
	        return $this->payment_processor;
	}
	
	function setPayment_processor($o) {
	      $this->payment_processor = $o;
	}
	
	function getTime() {
	        return $this->time;
	}
	
	function setTime($o) {
	      $this->time = $o;
	}
	
	function getTransaction_start_date() {
	        return $this->transaction_start_date;
	}
	
	function setTransaction_start_date($o) {
	      $this->transaction_start_date = $o;
	}
	
	function getCancellation_date() {
	        return $this->cancellation_date;
	}
	
	function setCancellation_date($o) {
	      $this->cancellation_date = $o;
	}
	
	function getRefund_date() {
	        return $this->refund_date;
	}
	
	function setRefund_date($o) {
	      $this->refund_date = $o;
	}

	
	
	
	public static function loadUniqueActiveMembersPerPeriod($start_date, $end_date, $group) {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			$stmt = null;
			
				
			if($group=="month") {		
						$sql = "SELECT 
							count(*) as active,
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							CURDATE() <= upj.access_end_date and
							CURDATE() >= upj.access_start_date and
							upj.access_start_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";	
			
						$sql.=" GROUP BY
							YEAR(upj.access_start_date),MONTH(upj.access_start_date)
				  	    ORDER BY
						YEAR(upj.access_start_date),MONTH(upj.access_start_date)";
					}
			else {
						$sql = "SELECT 
							count(*) as active,
							YEAR(upj.access_start_date) as ty
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							CURDATE() <= upj.access_end_date and
							CURDATE() >= upj.access_start_date and
							upj.access_start_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
						$sql.=" GROUP BY
							YEAR(upj.access_start_date)
				  	    ORDER BY
						YEAR(upj.access_start_date)";
			}
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: loadUniqueActiveMembersPerPeriod(): Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadUniqueExpiredMembersPerPeriod($start_date, $end_date, $group) {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			$stmt = null;
			

		
					
			if($group=="month") {		
				$sql = "SELECT 
							count(*) as expired,
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_end_date < CURDATE() and
							CURDATE() >= upj.access_start_date and
							upj.access_start_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
				
				$sql.=" GROUP BY YEAR( upj.access_start_date ), MONTH(upj.access_start_date)
						ORDER BY YEAR( upj.access_start_date ), MONTH(upj.access_start_date)";
			}
			else {
				
					$sql = "SELECT 
							count(*) as expired,
							YEAR(upj.access_start_date) as ty
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_end_date < CURDATE() and
							CURDATE() >= upj.access_start_date and
							upj.access_start_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
				
				$sql.=" GROUP BY YEAR( upj.access_start_date )
						ORDER BY YEAR( upj.access_start_date )";
			}
			
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: loadUniqueExpiredMembersPerPeriod(): Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	
	
	
	
	public static function loadNewMemberSummary($start_date, $end_date, $group) {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			$stmt = null;
			
					
			if($group=="month") {		
			$sql = "SELECT 
							count(*) as new,
							p.id,
							p.name, 
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_start_date >= str_to_date(:start_date, '%m-%d-%Y') and
							upj.access_start_date <= str_to_date(:end_date, '%m-%d-%Y')";
							
				$sql.=" GROUP BY
							upj.product_id,YEAR(upj.access_start_date),MONTH(upj.access_start_date)
					ORDER BY
						upj.product_id,YEAR(upj.access_start_date),MONTH(upj.access_start_date)";
			}
			else {
				
				$sql = "SELECT 
							count(*) as new,
							p.id,
							p.name, 
							YEAR(upj.access_start_date) as ty
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_start_date >= str_to_date(:start_date, '%m-%d-%Y') and
							upj.access_start_date <= str_to_date(:end_date, '%m-%d-%Y')";
							
				$sql.=" GROUP BY
							upj.product_id,YEAR(upj.access_start_date)
					ORDER BY
						upj.product_id,YEAR(upj.access_start_date)";
			}
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				//logToFile("Dap_Reports.class: loadNewMemberSummary(): Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	
	
	public static function loadActiveMemberSummary($start_date, $end_date, $group) {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			$stmt = null;

			/*$sql = "SELECT 
							count(*) as active,
							p.id,
							p.name, 
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_end_date >= str_to_date(:end_date, '%m-%d-%Y') and
							upj.access_start_date >= str_to_date(:start_date, '%m-%d-%Y')";				
							
							*/
					
			if($group=="month") {		
						$sql = "SELECT 
							count(*) as active,
							p.id,
							p.name, 
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_end_date >= str_to_date(:start_date, '%m-%d-%Y') and
							upj.access_start_date <= str_to_date(:end_date, '%m-%d-%Y')";
							
				$sql.=" GROUP BY
							p.id, p.name, YEAR(upj.access_start_date),MONTH(upj.access_start_date)
					ORDER BY
						p.id, p.name, YEAR(upj.access_start_date),MONTH(upj.access_start_date)";
			}
			else {
							$sql = "SELECT 
							count(*) as active,
							p.id,
							p.name, 
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id and
							upj.access_end_date >= str_to_date(:start_date, '%m-%d-%Y') and
							upj.access_start_date <= str_to_date(:end_date, '%m-%d-%Y')";
							
				$sql.=" GROUP BY
							p.id,p.name,YEAR(upj.access_start_date)
					ORDER BY
						upj.access_start_date, p.id,p.name";
			}
			
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
		
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			//	logToFile("Dap_Reports.class: loadUniqueActiveMembers(): Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
		public static function loadExpiredMemberSummary($start_date, $end_date) {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			$stmt = null;
					
			if($group=="month") {		
			$sql = "SELECT 
							count(*) as expired,
							p.id,
							p.name, 
							YEAR(upj.access_end_date) as ty,
							MONTH(upj.access_end_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							p.id=upj.product_id and
							upj.access_end_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
				$sql.=" GROUP BY
							p.id, p.name,YEAR(upj.access_end_date),MONTH(upj.access_end_date)
					ORDER BY
						p.id, p.name,YEAR(upj.access_end_date),MONTH(upj.access_end_date)";
			}
			else {
				$sql = "SELECT 
							count(*) as expired,
							p.id,
							p.name, 
							YEAR(upj.access_end_date) as ty
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							p.id=upj.product_id and
							upj.access_end_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
				$sql.=" GROUP BY
							p.id, p.name,YEAR(upj.access_end_date)
					ORDER BY
						p.id, p.name,YEAR(upj.access_end_date)";
			}
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			//	logToFile("Dap_Reports.class: loadExpiredMemberSummary(): Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadUniqueMembers($start_date, $end_date) {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			$stmt = null;
			$sql = "select id, name from dap_products";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$productsArray = array();
			$i=0;
			$months = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$productId = $row["id"];
				$productName = $row["name"];
				$productRowCount = 0;
				$productsArray[$i] = array();
				$productsArray[$i]["id"] = $productId;
				$productsArray[$i]["name"] = $productName;
				$productsArray[$i]["active"] = 0;
				$productsArray[$i]["expired"] = 0;
				
				/** Select all ACTIVE users **/
				$sql2 = "SELECT 
							count(*) as count,
							upj.product_id,
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = " . $productId . " and
							upj.product_id = p.id and
							CURDATE() <= upj.access_end_date and
							upj.access_start_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')
						GROUP BY
							upj.product_id,YEAR(upj.access_start_date),MONTH(upj.access_start_date)
						";
							
				//logToFile("ACTIVE sql: $sql2"); 
				$stmt2 = $dap_dbh->prepare($sql2);
				$stmt2->bindParam(':start_date', $start_date, PDO::PARAM_STR);
				$stmt2->bindParam(':end_date', $end_date, PDO::PARAM_STR);
				$stmt2->execute();
				
				if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
					//$productsArray[$i]["name"] = $row2["name"];
					$name=$row2["name"];
					$mon=$row2['tm'];
					$my = $months[$mon] . "-" . $row2['ty'];
				
					$productsArray[$name][$my]["active"] = $row2["count"];
					logToFile("product id: " . $productId . ", productsArray[name][my]['active'] " . $row2["count"]); 
				}
				
				$productsArray[$name][$my]["rowTotal"] = $productRowCount;
				
				$row2 = null;
				$stmt2 = null;
				$sql2 = null;
			
			
				/** Select all EXPIRED users **/
				$sql2 = "SELECT 
							count(*) as count,
							p.name,
							YEAR(upj.access_start_date) as ty,
							MONTH(upj.access_start_date) as tm
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = " . $productId . " and
							upj.product_id = p.id and 
							upj.access_end_date < CURDATE() and
							upj.access_start_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')
						GROUP BY
							p.name,YEAR(upj.access_start_date),MONTH(upj.access_start_date)					
						";
				//logToFile("FREE sql: $sql2"); 
				$stmt2 = $dap_dbh->prepare($sql2);
				$stmt2->bindParam(':start_date', $start_date, PDO::PARAM_STR);
				$stmt2->bindParam(':end_date', $end_date, PDO::PARAM_STR);
				$stmt2->execute();
				
				if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
					//$productsArray[$i]["name"] = $row2["name"];
					$name=$row2["name"];
					$mon=$row2['tm'];
					$my = $months[$mon] . "-" . $row2['ty'];
				
					$productsArray[$name][$my]["expired"] = $row2["count"];
					logToFile("product id: " . $productId . ", productsArray[name][my]['expired'] " . $row2["count"]); 
				}
				
				$row2 = null;
				$stmt2 = null;
				$sql2 = null;

				//logToFile("-----------------------------------"); 
			
			
				$productsArray[$name][$my]["rowTotal"] = $productRowCount;
				$i++;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $productsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	
	public static function loadMemberSummary($start_date, $end_date) {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			$stmt = null;
			$sql = "select id, name from dap_products";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$productsArray = array();
			$i=0;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$productId = $row["id"];
				$productName = $row["name"];
				$productRowCount = 0;
				$productsArray[$i] = array();
				$productsArray[$i]["id"] = $productId;
				$productsArray[$i]["name"] = $productName;
				$productsArray[$i]["active"] = 0;
				$productsArray[$i]["expired"] = 0;
				$productsArray[$i]["rowTotal"] = 0;
				
				/** Select all ACTIVE users **/
				$sql2 = "SELECT 
							count(*) as count,
							p.id
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = " . $productId . " and
							upj.product_id = p.id and
							upj.access_end_date >= str_to_date(:start_date, '%m-%d-%Y') and
							upj.access_start_date >= str_to_date(:end_date, '%m-%d-%Y') 
						GROUP BY
							p.id
						";
							
				//logToFile("PAID sql: $sql2"); 
				$stmt2 = $dap_dbh->prepare($sql2);
				$stmt2->bindParam(':start_date', $start_date, PDO::PARAM_STR);
				$stmt2->bindParam(':end_date', $end_date, PDO::PARAM_STR);
				$stmt2->execute();
				
				if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
					//$productsArray[$i]["name"] = $row2["name"];
					$productsArray[$i]["active"] = $row2["count"];
					$productRowCount += $row2["count"];
					logToFile("product id: " . $productId . ", productsArray[$i][active]: " . $row2["count"]); 
				}
				
				$row2 = null;
				$stmt2 = null;
				$sql2 = null;
			
			
				/** Select all EXPIRED users **/
				$sql2 = "SELECT 
							count(*) as count,
							p.id
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = " . $productId . " and
							upj.product_id = p.id and 
							upj.access_end_date < CURDATE() and 
							upj.access_end_date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')
						GROUP BY
							p.id							
						";
				//logToFile("FREE sql: $sql2"); 
				$stmt2 = $dap_dbh->prepare($sql2);
				$stmt2->bindParam(':start_date', $start_date, PDO::PARAM_STR);
				$stmt2->bindParam(':end_date', $end_date, PDO::PARAM_STR);
				$stmt2->execute();
				
				if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
					//$productsArray[$i]["name"] = $row2["name"];
					$productsArray[$i]["expired"] = $row2["count"];
					$productRowCount += $row2["count"];
					logToFile("product id: " . $productId . ", productsArray[$i][expired]: " . $row2["count"]); 
				}
				
				$row2 = null;
				$stmt2 = null;
				$sql2 = null;

				//logToFile("-----------------------------------"); 
			
			
				$productsArray[$i]["rowTotal"] = $productRowCount;
				$i++;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $productsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadEarningsSummary($start_date, $end_date, $group) {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		//	if($group=="year")
			//	$end_date=date('m-d-Y', strtotime('+1 year', strtotime($end_date)) );
			

			$stmt = null;
			
				
			if($group=="month") {		
			$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name, 
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						sum(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
				$sql.="GROUP BY
						t.product_id, YEAR(t.date),MONTH(t.date)
					ORDER BY
						t.product_id, YEAR(t.date),MONTH(t.date)
					";
			}
			else {
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name, 
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						sum(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
				logToFile("group by year"); 
				$sql.="GROUP BY
						p.id,YEAR(t.date)
					ORDER BY
						p.id,YEAR(t.date)
					";
			}
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadEarningsSummaryOLD($start_date, $end_date, $group) {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			$stmt = null;
			$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name, 
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						sum(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')
					GROUP BY
						p.id, YEAR(t.date),MONTH(t.date)
					ORDER BY
						p.id, YEAR(t.date),MONTH(t.date)
					";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadEarningsSummaryByMonth($start_date, $end_date, $group) {
		try {
			//logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			$stmt = null;
			
			if($group=="month") {		
			
			$sql = "
						SELECT 
							YEAR(date) as ty, 
							MONTH(date) as tm,
						  	COUNT(*) AS numtrans,
						  	sum(payment_value) as total
						FROM 
							dap_transactions
						WHERE
							payment_status in ('Completed', 'Refund') and
							trans_type <> 'subscr_signup' and
							date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
								
				$sql.="GROUP BY 
							YEAR(date), MONTH(date)
						ORDER BY 
							YEAR(date), MONTH(date)
					";
			}
			else {
				
				$sql = "
						SELECT 
							YEAR(date) as ty, 
							MONTH(date) as tm,
						  	COUNT(*) AS numtrans,
						  	sum(payment_value) as total
						FROM 
							dap_transactions
						WHERE
							payment_status in ('Completed', 'Refund') and
							trans_type <> 'subscr_signup' and
							date between str_to_date(:start_date, '%m-%d-%Y') and str_to_date(:end_date, '%m-%d-%Y')";
								
				logToFile("group by year"); 
				$sql.="GROUP BY 
							YEAR(date)
						ORDER BY 
							YEAR(date)
					";
			}
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	/******New Stats Page*******/
	
	public static function getDAPMemberTotals($start_date, $end_date, $group_by = '', $order = 'DESC', $p_id = 'all') {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;
			
	//		$end_date = date('Y-m-d', strtotime($end_date . ' +1 day'));
			
			
			$sql = "SELECT 
							*
						FROM
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.product_id = p.id ";	
							
			/*if($p_id != 'all'){
				$sql .= " and upj.product_id = $p_id  ";	
			}*/					
			
			if($start_date != '' && $end_date != ''){			
				$sql .= " and upj.access_start_date <= '$end_date' and
						upj.access_end_date >= '$start_date'";			
			}			
			
			$sql .=" ORDER BY access_start_date $order";	
			
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}

	
	public static function getDAPActivePaidMembers($start_date, $end_date,$group_by='' , $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
		
			$stmt = null;	
			$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							u.id = upj.user_id and
							upj.product_id = p.id and upj.status='A' and
							p.is_free_product='N'";
	
							
				/*if($p_id != 'all'){
					$sql .= " and upj.product_id = $p_id  ";	
				}*/					
				
				if($start_date != '' && $end_date != ''){			
					$sql .= " and upj.access_start_date <= '$end_date' and
							upj.access_end_date > '$start_date'";			
				}			
				
				$sql .=" ORDER BY access_start_date $order";
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	public static function getDAPNewPaidMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
						
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							u.id = upj.user_id and
							upj.product_id = p.id 
							and p.is_free_product='N'";	
							
								
						
				if($start_date != '' && $end_date != ''){
					$sql .= " and upj.access_start_date >= '$start_date' and
							upj.access_start_date <= '$end_date'";	
				}		
						
				$sql .=" ORDER BY access_start_date $order";
			
						
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	public static function getDAPExpiredPaidMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
						
			$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
					FROM
						`dap_users` u,
						`dap_users_products_jn` upj,
						`dap_products` p 
					WHERE 
						u.id = upj.user_id and
						upj.product_id = p.id 
						and p.is_free_product='N'";
						
				//upj.access_end_date between '$start_date'  and '$end_date'";			
				//upj.access_end_date >= '$start_date' and upj.access_end_date <= '$end_date'";
				if($start_date != '' && $end_date != '' ){
					$sql .= " and
							upj.access_end_date >= '$start_date'  and upj.access_end_date <= '$end_date'";			
				}		
					
				$sql .=" ORDER BY access_start_date $order";	
				
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function getDAPTotalFreeMembers($start_date, $end_date,$group_by='' , $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
						
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							u.id = upj.user_id and
							upj.product_id = p.id 
							and p.is_free_product='Y'";		
							
							
							
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_start_date <= '$end_date' and
							upj.access_end_date >= '$start_date' ";	
				}			
						
				$sql .=" ORDER BY access_start_date $order";			
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function getDAPNewFreeMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			//logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
				
				
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							u.id = upj.user_id and
							upj.product_id = p.id 
							and p.is_free_product='Y'";
							
						
							
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_start_date >= '$start_date' and
							upj.access_start_date <= '$end_date'";	
				}			
						
				$sql .=" ORDER BY access_start_date $order";
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
		
	public static function getDAPProductsMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			//logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
		
				$sql = "SELECT 
							*
						FROM
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.product_id = p.id"; 
							
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}			
							
				if($end_date != ''){
					$sql .= " and
							upj.access_start_date <= '$end_date'";	
				}			
						
				
				$sql .=" ORDER BY access_start_date $order";
				
				
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function getDAPProductActivePaidMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.user_id=u.id and
							upj.product_id = p.id 
							and upj.status='A' and p.is_free_product='N' ";	
						
							
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}	
							
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_start_date <= '$end_date' and
							upj.access_end_date >= '$start_date'";	
				}			
							
						
				$sql .=" ORDER BY access_start_date $order";
				
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function getDAPProductNewPaidMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.user_id=u.id and
							upj.product_id = p.id 
							and p.is_free_product='N'";
							
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}				
				
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_start_date >= '$start_date' and
							upj.access_start_date <= '$end_date'";	
				}			
				
						
				$sql .=" ORDER BY access_start_date $order";
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function getDAPProductNewFreeMembers($start_date, $end_date,$group_by='',  $order='DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.user_id=u.id and
							upj.product_id = p.id 
							and p.is_free_product='Y'";
							
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}				
							
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_start_date >= '$start_date' and
							upj.access_start_date <= '$end_date'";	
				}			
				
						
				$sql .=" ORDER BY access_start_date $order";
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function getDAPProductTotalFreeMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.user_id=u.id and
							upj.product_id = p.id and
							p.is_free_product='Y'";
							
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}			
						
				$sql .=" ORDER BY access_start_date $order";				
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	public static function getDAPProductsExpiredPaidMembers($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			$stmt = null;	
			
				$sql = "SELECT 
							u.id as id,
							u.first_name as first_name,
							u.last_name as last_name,
							u.email as email,
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM
							`dap_users` u,
							`dap_users_products_jn` upj,
							`dap_products` p 
						WHERE 
							upj.user_id=u.id and
							upj.product_id = p.id 
							and p.is_free_product='N'";	
							
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}				
				
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_end_date between '$start_date' and '$end_date'";	
				}
							
						
				$sql .=" ORDER BY access_start_date $order";
							
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	public static function getOneData(){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			$stmt = null;	
					
			$sql = "SELECT 
							*
						FROM 
							`dap_users_products_jn` ORDER BY access_start_date ASC LIMIT 1";	
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	
	public static function getDAPTotalSubscriptions($start_date, $end_date,$group_by='', $order = 'DESC'){
			
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id 
							and p.is_free_product='N' and p.is_recurring='Y'";	
					
				if($start_date != '' && $end_date != ''){
					$sql .= " and upj.access_start_date <= '$end_date' and
							upj.access_end_date >= '$end_date'"; 	
				}	
							
						
				$sql .=" ORDER BY access_start_date $order";
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
			
			
	}
	
	public static function getDAPActiveSubscriptions($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id 
							and upj.status='A' and p.is_free_product='N' and p.is_recurring='Y'";	
							
				if($start_date != '' && $end_date != ''){
					$sql .= " and upj.access_start_date <= '$end_date' and
							upj.access_end_date >= '$start_date'";	
								
				}				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}				
						
				$sql .=" ORDER BY access_start_date $order";
				
				
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				$resultsArray[] = $row;
			}
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	public static function getDAPNewSubscriptions($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id  
							and p.is_free_product='N' and p.is_recurring='Y'";	
							
						
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_start_date >= '$start_date' and
							upj.access_start_date <= '$end_date'"; 	
				}	
				
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}			
						
				$sql .=" ORDER BY access_start_date $order";
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	
	public static function getDAPExpiredSubscriptions($start_date, $end_date,$group_by='', $order = 'DESC', $p_id = 'all'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = null;	
			
				$sql = "SELECT 
							upj.access_start_date as access_start_date,
							upj.access_end_date as access_end_date,
							upj.product_id as product_id,
							p.name as name,
							p.is_free_product as is_free_product,
							p.is_recurring as is_recurring
						FROM 
							dap_users_products_jn upj,
							dap_products p
						WHERE 
							upj.product_id = p.id 
							and p.is_free_product='N' and p.is_recurring='Y'";	
							
				
				if($start_date != '' && $end_date != ''){
					$sql .= " and
							upj.access_end_date >= '$start_date' and
							upj.access_end_date <= '$end_date'"; 	
				}
				
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql .= " and upj.product_id = $p_id";	
				}	
						
				$sql .=" ORDER BY access_start_date $order";
							
				
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;	
			
		}catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	
	public static function loadDetailsSalesRefundsIdsEarningsSummaryStats($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		//	if($group=="year")
			//	$end_date=date('m-d-Y', strtotime('+1 year', strtotime($end_date)) );
			
			
			$stmt = null;
			
			$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name, 
						t.date,
						t.trans_blob as trans_blob,
						t.sub_trans_num as sub_trans_num,
						t.payer_email as payer_email,
						(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						
						(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
						
					WHERE
					
						t.product_id = p.id and
						t.payment_status in ('Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row['sub_trans_num'];
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadDetailsSalesEarningsSummaryStats($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		//	if($group=="year")
			//	$end_date=date('m-d-Y', strtotime('+1 year', strtotime($end_date)) );
			
			
			$stmt = null;
			
			$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name, 
						t.date,
						t.trans_blob as trans_blob,
						t.payer_email as payer_email,
						t.trans_num as trans_num,
						t.id as t_id,
						(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						
						(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
						
					WHERE
					
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadEarningsSummaryStats($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		//	if($group=="year")
			//	$end_date=date('m-d-Y', strtotime('+1 year', strtotime($end_date)) );
			
			
			$stmt = null;
			if($group=="day") {		
			$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						DAY(t.date) as td,
						t.date as date,
						p.id,
						p.name, 
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						sum(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						count(t.id) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
				
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql.="GROUP BY
						t.product_id, YEAR(t.date),MONTH(t.date), DAY(t.date), t.date
					ORDER BY
						t.product_id, YEAR(t.date),MONTH(t.date),DAY(t.date)
					";
					
					
			}	
			else if($group=="month") {		
			$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						t.date as date,
						p.id,
						p.name, 
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						sum(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						count(t.id) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
				
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql.="GROUP BY
						t.product_id, YEAR(t.date),MONTH(t.date), t.date
					ORDER BY
						t.product_id, YEAR(t.date),MONTH(t.date)
					";
			}
			else {
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						t.date as date,
						p.id,
						p.name, 
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value < 0 THEN t.payment_value ELSE 0 end) as product_total_refunds,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						sum(CASE WHEN t.payment_value < 0 THEN 1 ELSE 0 end) as num_refunds,
						count(t.id) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						t.payment_status in ('Completed', 'Refund') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
				logToFile("group by year"); 
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql.=" GROUP BY
						p.id,YEAR(t.date), t.date
					ORDER BY
						p.id,YEAR(t.date)
					";
			}
			
			//echo $sql;die;
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				logToFile("Dap_Reports.class: Start, end: $start_date, $end_date"); 
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadUserHasAccessByDate($start_date,$product_id = ''){
		try {
			 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("Y-m-d");
			
			$product_id_sql = '';
			if($product_id != ''){
				$product_id_sql = '  p.id = :product_id and ';
			}		
		
			$sql = "SELECT 
				u.id as user_id,
				u.status as u_status,
				p.is_free_product as product_free,
				p.id as product_id,
				upj.access_start_date as access_start_date,
				upj.access_end_date as access_end_date
				
			FROM 
				dap_users as u,
				dap_users_products_jn as upj,
				dap_products p
			WHERE 
			    u.id = upj.user_id and 
			    p.id = upj.product_id and 
			    p.is_free_product = 'N' and 
			    u.status = 'A' and 
			    $product_id_sql 
				upj.access_start_date <= :start_date AND upj.access_end_date >= :start_date " ;		
			
			logToFile("Dap_Reports.class:loadUserHasAccessByDate sql: ".$sql); 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			if($product_id != ''){
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			}
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	

	public static function loadUserHasAccessBetweenDate($start_date,$end_date,$product_id = ''){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("Y-m-d");
			if($end_date == "") $end_date = date("Y-m-d");
			$product_id_sql = '';
			if($product_id != ''){
				$product_id_sql = '  p.id = :product_id and ';
			}		
				
			$sql = "SELECT 
				u.id as user_id,
				u.status as u_status,
				p.is_free_product as product_free,
				p.id as product_id,
				upj.access_start_date as access_start_date,
				upj.access_end_date as access_end_date
				
			FROM 
				dap_users as u,
				dap_users_products_jn as upj,
				dap_products p
			WHERE 
			    u.id = upj.user_id and 
			    p.id = upj.product_id and 
			    p.is_free_product = 'N' and 
			    u.status = 'A' and 
				upj.access_start_date >= :start_date and 
				$product_id_sql 
				upj.access_start_date <= :end_date";		
			
			logToFile("Dap_Reports.class:loadUserHasAccessBetweenDate sql: ".$sql);  
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			if($product_id != ''){
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			}
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadExpiredUserByDate($start_date,$end_date,$product_id = ''){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("Y-m-d");
			if($end_date == "") $end_date = date("Y-m-d");
			$product_id_sql = '';
			if($product_id != ''){
				$product_id_sql = '  p.id = :product_id and ';
			}		
				
			$sql = "SELECT 
				upj.user_id as user_id
			FROM 
				dap_users as u,
				dap_users_products_jn as upj,
				dap_products p
			WHERE 
			    u.id = upj.user_id and 
			    p.id = upj.product_id and 
			    p.is_free_product = 'N' and 
			    u.status = 'A' and 
				upj.access_end_date >= :start_date and 
				$product_id_sql 
				upj.access_end_date <= :end_date";		
			
			logToFile("Dap_Reports.class:loadUserHasAccessBetweenDate sql: ".$sql);  
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			if($product_id != ''){
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			}
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row['user_id'];
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadCancelledUserByDate($start_date,$end_date,$product_id = ''){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("Y-m-d");
			if($end_date == "") $end_date = date("Y-m-d");
			$product_id_sql = '';
			if($product_id != ''){
				$product_id_sql = '  p.id = :product_id and ';
			}		
				
			$sql = "SELECT 
				dt.payer_email
			FROM 
				dap_users as u,
				dap_transactions as dt
			WHERE 
				u.email = dt.payer_email and
				dt.date >= '$start_date' and 
				dt.date <= '$end_date' AND dt.payment_status  LIKE '%cancel%'";		
			
			
			
			logToFile("Dap_Reports.class:loadUserHasAccessBetweenDate sql: ".$sql);  
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
			/*if($product_id != ''){
				$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
			}*/
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadRevenueEarningsSummaryStats($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name as product_name, 
						t.date,
						t.product_id as p_id,
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'N' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= " GROUP BY t.product_id";
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadUniqueCustomersEarningsSummaryStatsWithTotalPrice($start_date, $end_date, $group, $p_id = 'all', $order = 'asc') {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		/*	if($order == 'asc'){*/
				$sql = "SELECT
						YEAR(t.date) as ty,
						t.payer_email as email,
						t.date as date, 
						t.product_id as p_id,
						t.trans_num as trans_num,
						t.sub_trans_num as sub_trans_num,
						sum(t.payment_value) as price,
						p.name as product_name
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
			/*}else{
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						t.payer_email,
						MAX(t.date) as date, 
						t.product_id as p_id,
						p.name as product_name
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date' GROUP BY t.payer_email, t.product_id, YEAR(t.date),MONTH(t.date)";	
			}*/
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'N' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= "  GROUP BY t.payer_email, t.product_id , YEAR(t.date)";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadAverageLengthOfSubscription($start_date , $end_date, $p_id = 'all', $order = 'asc'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
				
			if($order == 'asc'){
				$sql = "SELECT
						t.payer_email as email,
						MIN(t.date) as date, 
						t.product_id as p_id,
						t.payment_value as price,
						t.trans_num as trans_num,
						t.sub_trans_num as sub_trans_num,
						p.name as product_name,
						p.recurring_cycle_3 as cycle
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y'  and p.total_occur >= '99'
						and (p.offer_trial = 'N' or p.offer_trial = '' or (p.offer_trial IS NULL and p.trial_price <= 0)) and p.is_free_product = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
			}else{
				$sql = "SELECT
						t.payer_email as email,
						t.product_id as p_id,
						t.trans_num as trans_num,
						t.payment_value as price,
						t.sub_trans_num as sub_trans_num,
						MAX(t.date) as date,
						p.name as product_name,
						p.recurring_cycle_3 as cycle
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and p.total_occur >= '99'
						and (p.offer_trial = 'N' or p.offer_trial = '' or (p.offer_trial IS NULL and p.trial_price <= 0)) and p.is_free_product = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";	
			}	
		
			if($p_id != 'all' && $p_id != '' && $p_id != '0'){
				$sql.=" AND t.product_id = $p_id ";		
			}	
			
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= "  GROUP BY t.payer_email, t.product_id ";
			
			logToFile("Dap_Reports.class:loadUserHasAccessBetweenDate sql: ".$sql);  
			$stmt = $dap_dbh->prepare($sql);
		
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
		
	public static function loadAverageLengthOfTrials($start_date , $end_date, $p_id = 'all', $order = 'asc'){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($order == 'asc'){
				$sql = "SELECT
						t.payer_email as email,
						MIN(t.date) as date, 
						t.product_id as p_id,
						t.payment_value as trial_price,
						t.trans_num as trans_num,
						t.sub_trans_num as sub_trans_num,
						p.name as product_name,
						p.recurring_cycle_3 as cycle,
						p.price as price
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' 
						and (p.offer_trial = 'Y' or p.offer_trial = '' or (p.offer_trial IS NULL and p.trial_price > 0)) and p.is_free_product = 'N' and
						p.total_occur >= 99 and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
			}else{
				$sql = "SELECT
						t.payer_email as email,
						t.product_id as p_id,
						t.trans_num as trans_num,
						t.payment_value as trial_price,
						t.sub_trans_num as sub_trans_num,
						MAX(t.date) as date,
						p.name as product_name,
						p.recurring_cycle_3 as cycle,
						p.price as price
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.is_recurring = 'Y' 
						and (p.offer_trial = 'Y' or p.offer_trial = '' or (p.offer_trial IS NULL and p.trial_price > 0)) and p.is_free_product = 'N' and
						p.total_occur >= 99 and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";	
			}	
		
			if($p_id != 'all' && $p_id != '' && $p_id != '0'){
				$sql.=" AND t.product_id = $p_id ";		
			}	
			
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur >= 99 and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= "  GROUP BY t.payer_email, t.product_id ";
			
			
			
			logToFile("Dap_Reports.class:loadUserHasAccessBetweenDate sql: ".$sql);  
			$stmt = $dap_dbh->prepare($sql);
		
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			$row = null;
			$stmt = null;
			$dap_dbh = null;
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
		
	public static function loadUniqueCustomersRevenueEarningsSummaryStatsPaymentPlanByMonth($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name as product_name, 
						t.date,
						t.payer_email as payer_email,
						t.product_id as p_id,
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.total_occur < '99' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur < '99' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				//$sql .= " GROUP BY t.product_id";	
				
				
				$sql .= "  GROUP BY t.payer_email,Month(t.date)";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadUniqueCustomersPaymentPlanByMonth($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						p.id,
						p.name as product_name, 
						t.date,
						t.payment_value as price,
						t.payer_email as payer_email,
						t.product_id as p_id
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.total_occur < '99' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur < '99' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				//$sql .= " GROUP BY t.product_id";	
				
				
			//	$sql .= "  GROUP BY t.product_id,Month(t.date)";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	
	public static function loadRevenueEarningsSummaryStatsPaymentPlanByMonth($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name as product_name, 
						t.date,
						t.product_id as p_id,
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.total_occur < '9999' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur < '9999' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				//$sql .= " GROUP BY t.product_id";	
				$sql .= "  GROUP BY Month(t.date)";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function loadRevenueEarningsSummaryStatsPaymentPlan($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name as product_name, 
						t.date,
						t.product_id as p_id,
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.total_occur < '9999' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur < '9999' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= " GROUP BY t.product_id";	
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
		
	public static function loadCustomersLifetimePurchaseSummaryStatsPaymentPlanWithTotalSales($customers_email = '') {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			
			
			/*	if($order == 'asc'){*/
				$sql = "SELECT
						YEAR(t.date) as ty,
						t.payer_email as email,
						t.payer_email as payer_email,
						t.date as date, 
						t.product_id as p_id,
						sum(t.payment_value) as price,
						t.trans_num as trans_num,
						t.sub_trans_num as sub_trans_num,
						p.name as product_name
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.total_occur < '9999' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup'
						";
			
					
					
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur < '9999' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup'
						)";
						
				$sql .= " and t.payer_email IN ($customers_email)";	
				
				$sql .= "  GROUP BY t.payer_email, YEAR(t.date)";
				
				//echo $sql;die;
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
		
	public static function loadUniqueCustomersEarningsSummaryStatsPaymentPlanWithTotalSales($start_date, $end_date, $group, $p_id = 'all', $order = 'asc') {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
			/*	if($order == 'asc'){*/
				$sql = "SELECT
						YEAR(t.date) as ty,
						t.payer_email as email,
						t.date as date, 
						t.product_id as p_id,
						sum(t.payment_value) as price,
						t.trans_num as trans_num,
						t.sub_trans_num as sub_trans_num,
						p.name as product_name
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y' and
						p.total_occur < '9999' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
			/*}else{
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						t.payer_email,
						MAX(t.date) as date, 
						t.product_id as p_id,
						p.name as product_name
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date' GROUP BY t.payer_email, t.product_id, YEAR(t.date),MONTH(t.date)";	
			}*/
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' and
							p.total_occur < '9999' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= "  GROUP BY t.payer_email, t.product_id , YEAR(t.date)";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadTotalSales($start_date, $end_date, $group, $p_id = 'all') {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
				$sql = "SELECT
						count(*) as total_sales,
						t.product_id as prod_id
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'Y'  
						and p.total_occur >= '99' 
						and	t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'Y' 
							and p.total_occur >= '99' 
							and t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= "  GROUP BY t.product_id";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
    
    
        public static function loadRevenueEarningsSummaryStatsByDate($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						
						p.id as p_id,
						p.name as product_name, 
						t.date,
						t.product_id as p_id,
						
						t.payer_email as payer_email,
						t.payment_value as price,
						
						(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'N' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
						
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	} 
     public static function loadRevenueEarningsSummaryStatsByMonth($start_date, $end_date, $group, $p_id = 'all') {
		try {
			logToFile("Start, end: $start_date, $end_date"); 
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						p.id,
						p.name as product_name, 
						t.date,
						t.product_id as p_id,
						
						sum(CASE WHEN t.payment_value > 0 THEN t.payment_value ELSE 0 end) as product_total_sales,
						sum(CASE WHEN t.payment_value > 0 THEN 1 ELSE 0 end) as num_sales,
						count(*) as total_transactions,
						sum(t.payment_value) as product_net_sales
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
						
				
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'N' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= " GROUP BY MONTH(t.date)";
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = null;
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}	
    
    
    public static function loadUniqueCustomersEarningsSummaryStatsByMonth($start_date, $end_date, $group, $p_id = 'all', $order = 'asc') {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			if($start_date == "") $start_date = date("m-d-Y");
			if($end_date == "") $end_date = date("m-d-Y");
			
		/*	if($order == 'asc'){*/
				$sql = "SELECT
						YEAR(t.date) as ty,
						MONTH(t.date) as tm,
						t.payer_email as payer_email,
						t.date as date, 
						t.product_id as p_id,
						t.trans_num as trans_num,
						t.sub_trans_num as sub_trans_num,
						t.payment_value as price,
						p.name as product_name
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date'";
			
					
				if($p_id != 'all' && $p_id != '' && $p_id != '0'){
					$sql.=" AND t.product_id = $p_id ";		
				}	
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'N' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
						)";
				
				$sql .= "  GROUP BY t.payer_email,Month(t.date)";
				
				
			$stmt = $dap_dbh->prepare($sql);
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}	
    
     public static function loadCustomersLifetimePurchaseSummaryStats($customers_email = '') {
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "SELECT
						YEAR(t.date) as ty,
						
						p.id,
						p.name as product_name, 
						t.date,
						t.product_id as p_id,
						t.payer_email as payer_email
						
					FROM
						dap_transactions t,
						dap_products p
					WHERE
						t.product_id = p.id and
						p.is_recurring = 'N' and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup'";
						
				
					
				
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t,
							dap_products p
						WHERE
							t.product_id = p.id and
							p.is_recurring = 'N' and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' 
							
						)";
						
				$sql .= " and t.payer_email IN ($customers_email)";	
				
				$sql .= " GROUP BY t.payer_email,YEAR(t.date)";
				
					
				
			$stmt = $dap_dbh->prepare($sql);
			
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray[] = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}	
	
	
	public static function getTotalPriceOfUser($email, $start_date , $end_date, $p_id){
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "SELECT
						SUM(t.payment_value) as user_total_price,
						count(*) as payment_num
					FROM
						dap_transactions t
					WHERE
						t.product_id = $p_id and
						t.payment_status in ('Completed') and
						t.trans_type <> 'subscr_signup' and
						t.date between '$start_date' and '$end_date' and t.payer_email = '$email'";
				
				$sql .= " and t.trans_num NOT IN
						(SELECT 
							t.sub_trans_num as sub_trans_num
						FROM
							dap_transactions t
						WHERE
							t.product_id = $p_id and
							t.payment_status in ('Refund') and
							t.trans_type <> 'subscr_signup' and
							t.date between '$start_date' and '$end_date'
							and t.payer_email = '$email'
						)";
						
				
				//$sql .= " GROUP BY t.payer_email";
				
				//echo $sql;	
				
			$stmt = $dap_dbh->prepare($sql);
			
			/*$stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
			$stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);*/
			$stmt->execute();
//			$resultsArray = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$resultsArray = $row;
			}
			
			return $resultsArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
}
?>
