<?php 
class Dap_Role{
	
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }
    
    function getName() {
        return $this->name;
    }
    function setName($o) {
        $this->name = $o;
    }
    
    function getDescription() {
        return $this->description;
    }
    function setDescription($o) {
        $this->description = $o;
    }
    	
       
    function create(){
	//	logToFile("Dap_Role.class.php: create method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "INSERT INTO dap_roles_master
					(name,description) VALUES
					(:name, :description)";
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':description', $this->getDescription(), PDO::PARAM_STR);
			$stmt->execute();
			return $dap_dbh->lastInsertId();
		}
		catch (PDOException $e) {
            logToFile("Dap_Role.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_Role.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_Role.class.php: exit ", LOG_DEBUG_DAP);
		exit;
	}
	
	function update(){
	//	logToFile("Dap_Role.class.php: update() method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_roles_master
					SET name = :name,description = :description WHERE id=:id";
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':description', $this->getDescription(), PDO::PARAM_STR);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_Role.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_Role.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		
		logToFile("Dap_Role.class.php: update() exit ", LOG_DEBUG_DAP);
	}
	
	
	function delete(){
	//	logToFile("Dap_Role.class.php: delete() method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "DELETE drm , dprm
					FROM 
						dap_roles_master AS drm
					LEFT JOIN 
						dap_product_role_mapping AS dprm ON drm.id = dprm.role_id
					WHERE 
						drm.id = :id";
			
			
		
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_Role.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_Role.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		
		logToFile("Dap_Role.class.php: delete() exit ", LOG_DEBUG_DAP);
	}
	
	
	public static function load(){
	//	logToFile("Dap_Role.class.php: load method called ", LOG_DEBUG_DAP);
		$rolesArray = array();
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_roles_master";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$roles = new Dap_Role();
				$roles->setId($row['id']);
				$roles->setName($row['name']);
				$roles->setDescription($row['description']);		
				$rolesArray[] = $roles;
			}
			
			return $rolesArray;
			
		}
		catch (PDOException $e) {
            logToFile("Dap_Role.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_Role.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_Role.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}

	public static function loadByID($id){
	//	logToFile("Dap_Role.class.php: load method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_roles_master WHERE id=:id";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$roles = new Dap_Role();
				$roles->setId($row['id']);
				$roles->setName($row['name']);
				$roles->setDescription($row['description']);		
			
			}
			
			return $roles;
			
		}
		catch (PDOException $e) {
            logToFile("Dap_Role.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_Role.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_Role.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	public static function loadByName($name , $id){
	//	logToFile("Dap_Role.class.php: load method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			if($id == ''){
				$sql = "SELECT * FROM dap_roles_master WHERE name=:name";		
			}else{
				$sql = "SELECT * FROM dap_roles_master WHERE name=:name AND id != :id";		
			}
			
			$stmt = $dap_dbh->prepare($sql);
			if($id != ''){
				$stmt->bindParam(':id', $id, PDO::PARAM_INT);	
			}
			$stmt->bindParam(':name', $name, PDO::PARAM_INT);
			$stmt->execute();
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$roles = new Dap_Role();
				$roles->setId($row['id']);
				$roles->setName($row['name']);
				$roles->setDescription($row['description']);		
			
			}
			
			return $roles;
			
		}
		catch (PDOException $e) {
            logToFile("Dap_Role.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_Role.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_Role.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	


}
