<?php 
class Dap_SPCSettings{
	
	var $id;
	var $name;
	var $value;
	var $last_updated_date;
	
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }
    function getName() {
        return $this->name;
    }
    function setName($o) {
        $this->name = $o;
    }
    function getValue() {
        return $this->value;
    }
    function setValue($o) {
        $this->value = $o;
    }
	function getLast_updated_date() {
        return $this->last_updated_date;
    }
    function setLast_updated_date($o) {
        $this->last_updated_date = $o;
    }
	
	
	function create(){
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "INSERT INTO dap_spc_settings
					(name,value, last_updated_date) VALUES
					(:name, :value, CURRENT_TIMESTAMP())";
			
			$stmt = $dap_dbh->prepare($sql);

			logToFile("Dap_SPCSettings.class.php: $sql", LOG_DEBUG_DAP);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->execute();
			return $dap_dbh->lastInsertId();
		}
		catch (PDOException $e) {
            logToFile("Dap_SPCSettings.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_SPCSettings.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		exit;
	}
	
	public static function loadAllSPCSettings(){
		$all_settings = "";
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_spc_settings";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$settings = new Dap_SPCSettings();
				$settings->setId($row['id']);
				$settings->setName($row['name']);
				$settings->setValue($row['value']);
				$settings->setLast_updated_date($row['last_updated_date']);
				$all_settings[] = $settings;
			}
			
			return $all_settings;
		}
		catch (PDOException $e) {
            logToFile("Dap_Dap_SPCSettingsGDPR.class.php: loadAllSPCSettings(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_SPCSettings.class.php: loadAllSPCSettings(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	function update(){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_spc_settings
					SET value = :value,last_updated_date = CURRENT_TIMESTAMP() 
					WHERE
					name = :name";
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_SPCSettings.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_SPCSettings.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	public static function loadSPCSettingByName($name){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_spc_settings WHERE name = '$name' ORDER BY id DESC";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$settings = new Dap_SPCSettings();
				$settings->setId($row['id']);
				$settings->setName($row['name']);
				$settings->setValue($row['value']);
				$settings->setLast_updated_date($row['last_updated_date']);
				return $settings;
			}

		}
		catch (PDOException $e) {
            logToFile("Dap_Dap_SPCSettingsGDPR.class.php: loadSPCSettingByName(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_SPCSettings.class.php: loadSPCSettingByName(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}
	
	public static function loadSPCSettingByValue($value){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_spc_settings WHERE value = '$value'";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$settings = new Dap_SPCSettings();
				$settings->setId($row['id']);
				$settings->setName($row['name']);
				$settings->setValue($row['value']);
				$settings->setLast_updated_date($row['last_updated_date']);
				return $settings;
			}
		}
		catch (PDOException $e) {
            logToFile("Dap_Dap_SPCSettingsGDPR.class.php: loadSPCSettingByValue(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_SPCSettings.class.php: loadSPCSettingByValue(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
	}

}// end of class
