<?php
 
class Dap_UsersLoginTracking extends Dap_Base {

	var $id;
   	var $user_id;
   	var $login_ip;
   	var $country;
   	var $action;
   	var $time;
   	
   	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
 	 
	function getUserId() {
		return $this->user_id;
	}
	function setUserId($o) {
		$this->user_id = $o;
	}
	
	function getLoginIP() {
		return $this->login_ip;
	}
	function setLoginIP($o) {
		$this->login_ip = $o;
	}

	function getCountry() {
		return $this->country;
	}
	function setCountry($o) {
		$this->country = $o;
	}
 
	function getAction() {
		return $this->action;
	}
	function setAction($o) {
		$this->action = $o;
	}

	function getTime() {
		return $this->time;
	}
	function setTime($o) {
		$this->time = $o;
	}
 
	public function create() {
		try {
			 
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "insert into dap_users_login_tracking 
						(user_id, login_ip, country, action)
					values 
						(:user_id, :login_ip, :country, :action)";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_STR);
			$stmt->bindParam(':login_ip', $this->getLoginIP(), PDO::PARAM_STR);
			$stmt->bindParam(':country', $this->getCountry(), PDO::PARAM_STR);
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);		
		 
			$stmt->execute();
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return ;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function load() {
		$users = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "SELECT * FROM dap_users_login_tracking";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
 
			while ($row = $stmt->fetch()) {
				$user = new Dap_UsersLoginTracking();
				$user->setCountry($row['country']);
				$users[] = $user;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $users;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadUserByUserId($user_id) {
		$user = NULL;
		try {
			$dap_dbh = Dap_Connection::getConnection();

			logToFile("loadUserByUserId: user_id=".$user_id,LOG_DEBUG_DAP);
		 
			$sql = "SELECT * FROM dap_users_login_tracking WHERE user_id =:user_id";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
			$stmt->execute();
 
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
							 
				$user = new Dap_UsersLoginTracking();
				$user->setUserId( stripslashes($row["user_id"]) );
				$user->setLoginIP( stripslashes($row["login_ip"]) );
				$user->setCountry( stripslashes($row["country"]) );
				$user->setAction( stripslashes($row["action"]) );
				$user->setTime( stripslashes($row["time"]) ); 			 
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $user;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadUserByCountry($country) {
		$user = NULL;
		try {
			$dap_dbh = Dap_Connection::getConnection(); 
		 
			$sql = "SELECT * FROM dap_users_login_tracking WHERE country =:country";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':country', $country, PDO::PARAM_STR);
			$stmt->execute();
 
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
							 
				$user = new Dap_UsersLoginTracking();
				$user->setUserId( stripslashes($row["user_id"]) );
				$user->setLoginIP( stripslashes($row["login_ip"]) );
				$user->setCountry( stripslashes($row["country"]) );
				$user->setAction( stripslashes($row["action"]) );
				$user->setTime( stripslashes($row["time"]) ); 			 
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $user;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadUserByCountryAndAction($country, $action) {
		$user = NULL;
		try {
			$dap_dbh = Dap_Connection::getConnection(); 
		 
			$sql = "SELECT * FROM dap_users_login_tracking WHERE country =:country AND action =:action ";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':country', $country, PDO::PARAM_STR);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
							 
				$user = new Dap_UsersLoginTracking();
				$user->setUserId( stripslashes($row["user_id"]) );
				$user->setLoginIP( stripslashes($row["login_ip"]) );
				$user->setCountry( stripslashes($row["country"]) );
				$user->setAction( stripslashes($row["action"]) );
				$user->setTime( stripslashes($row["time"]) ); 			 
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $user;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
 
 	public static function loadUserByUserIdAndAction($user_id, $action) {
		$user = NULL;
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "SELECT * FROM dap_users_login_tracking WHERE user_id =:user_id AND action=:action";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
							 
				$user = new Dap_UsersLoginTracking();
				$user->setUserId(stripslashes($row["user_id"]));
				$user->setLoginIP(stripslashes($row["login_ip"]));
				$user->setCountry(stripslashes($row["country"]));
				$user->setAction(stripslashes($row["action"]));
				$user->setTime(stripslashes($row["time"]) ); 			 
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $user;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadUserByAction($action) {
		$users = array();
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$sql = "SELECT * FROM dap_users_login_tracking WHERE action=:action";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			while ($row = $stmt->fetch()) {
				$user = new Dap_UsersLoginTracking();
				
				$user->setUserId($row['user_id']);
				$user->setLoginIP($row['login_ip']);
				$user->setCountry($row['country']);
				$user->setAction($row['action']);
				$user->setTime($row['time']);
				$users[] = $user;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $users;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	} 
	
	public static function loadUsersCountByCountry($country, $action, $days, $type) {
		
		try {
			$dap_dbh = Dap_Connection::getConnection(); 
			$users = array();
			
			if($type =="inactive"){
				$sql = "SELECT user_id FROM `dap_users_login_tracking` WHERE  country =:country AND action=:action AND time <= DATE_ADD(CURDATE(),INTERVAL -$days DAY) order by time asc";				
			}else{
				$sql = "SELECT user_id FROM `dap_users_login_tracking` WHERE  country =:country AND action=:action AND time >= DATE_SUB(CURDATE(),INTERVAL $days DAY) order by time asc";	
			}
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':country', $country, PDO::PARAM_STR);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			while($row = $stmt->fetch()) {
				$userArray = array();
				$userArray["id"] = $row["user_id"];
				$users[] = $userArray;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			 return count($users);
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadUsersCountByCountryAndByDate($country, $action,  $startdate, $enddate, $type) {
		
		try {
			$dap_dbh = Dap_Connection::getConnection(); 
			$users = array();
			
			$startdate = $startdate." 00:00:01";
			$enddate = $enddate." 23:59:59";
 
			if($type == "inactive"){
				$sql = "SELECT user_id FROM `dap_users_login_tracking` WHERE country =:country AND action=:action AND time NOT BETWEEN '$startdate' AND '$enddate' order by time asc";			 		
			 	
			}else{
				$sql = "SELECT user_id FROM `dap_users_login_tracking` WHERE country =:country AND action=:action AND time BETWEEN '$startdate' AND '$enddate' order by time asc";				 
			}
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':country', $country, PDO::PARAM_STR);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			while($row = $stmt->fetch()) {
				$userArray = array();
				$userArray["id"] = $row["user_id"];
				$users[] = $userArray;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			 return count($users);
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadUserByDays($action, $days, $type, $export) {
		logToFile("(Dap_UsersLoginTracking.loadUserByDays() enter");
		$users = array();
		$saveToFile="";
		$exportSQL="";
		$_SESSION["export_report"]="";
		
		
		try {
			$dap_dbh = Dap_Connection::getConnection();

			if($type == "inactive"){
				$sql = "SELECT * FROM `dap_users_login_tracking` WHERE action=:action AND time <= DATE_ADD(CURDATE(),INTERVAL -$days DAY) order by time asc";				
				$where = " action='$action' AND time <= DATE_ADD(CURDATE(),INTERVAL -$days DAY) order by time asc";				
			 	
			}else{
				$sql = "SELECT * FROM `dap_users_login_tracking` WHERE action=:action AND time >= DATE_SUB(CURDATE(),INTERVAL $days DAY) order by time asc";
				$where = " action='$action' AND time >= DATE_SUB(CURDATE(),INTERVAL $days DAY) order by time asc";
				
			}
			logToFile("(Dap_UsersLoginTracking.loadUserByDays() sql".$sql);
			
			//echo $sql;
			
			$exportSQL = "SELECT dap_users_login_tracking.user_id, dap_users.email, dap_users_login_tracking.login_ip, dap_users_login_tracking.country,
		dap_users_login_tracking.time FROM dap_users_login_tracking, dap_users WHERE dap_users_login_tracking.user_id = dap_users.id AND $where";
		
			$saveToFile.=$exportSQL;
			$saveToFile=$saveToFile . "|:|" . $exportSQL;
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			while ($row = $stmt->fetch()) {
				$user = new Dap_UsersLoginTracking();
				
				$user->setUserId($row['user_id']);
				$user->setLoginIP($row['login_ip']);
				$user->setCountry($row['country']);
				$user->setAction($row['action']);
				$user->setTime($row['time']);
				$users[] = $user;
			}
			

			logToFile("(Dap_UsersLoginTracking.loadUserByDays() count = " . count($users) . "export=". $export);
			
			 if(($export=="Y") && (count($users) > 0)) {
				 logToFile("(Dap_UsersLoginTracking.loadUserByDays() export=". $export);
				$type = ucfirst($type);
				$filename="exportLoginReportToCSV_".date("m-d-Y")."-".time().".csv";
				$csvFileName = DAP_ROOT.BULKFOLDER."/exportLoginReports".date("m-d-Y")."-".time().".csv";
				
				writeToFile($saveToFile,$csvFileName);
				
				$id=Dap_UsersLoginTracking::saveLoginLogoutReportExportQueryToCSV($csvFileName,$filename, $type);	
				$_SESSION["export_report"]=$id;
			}
			else {
				$_SESSION["export_report"]="";
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $users;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	} 
	
	 
	
	public static function loadUserByDates($action, $startdate, $enddate,$type, $export) {
		$users = array();
		$saveToFile="";
		$exportSQL="";
		$_SESSION["export_report"]="";
		try {
			$dap_dbh = Dap_Connection::getConnection();

			$startdate = $startdate." 00:00:01";
			$enddate = $enddate." 23:59:59";
 			
			if($type == "inactive"){
				$sql = "SELECT * FROM `dap_users_login_tracking` WHERE action='$action' AND time NOT BETWEEN '$startdate' AND '$enddate' order by time asc";			
				$where = "SELECT * FROM `dap_users_login_tracking` WHERE action='$action' AND time NOT BETWEEN '$startdate' AND '$enddate' order by time asc";			
			 	
			}else{
				$sql = "SELECT * FROM `dap_users_login_tracking` WHERE action='$action' AND time BETWEEN '$startdate' AND '$enddate' order by time asc";
				$where = "SELECT * FROM `dap_users_login_tracking` WHERE action='$action' AND time BETWEEN '$startdate' AND '$enddate' order by time asc";
				
			}
			 
			$saveToFile.=$exportSQL;
			$saveToFile=$saveToFile . "|:|" . $exportSQL;
			
			$stmt = $dap_dbh->prepare($sql);
			//$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
 
			while ($row = $stmt->fetch()) {
				$user = new Dap_UsersLoginTracking();
				
				$user->setUserId($row['user_id']);
				$user->setLoginIP($row['login_ip']);
				$user->setCountry($row['country']);
				$user->setAction($row['action']);
				$user->setTime($row['time']);
				$users[] = $user;
			}
			
			 if(($export=="Y") && (count($users) > 0)) {
				 logToFile("(Dap_UsersLoginTracking.loadUserByDays() export=". $export);
				$type = ucfirst($type);
				$filename="exportLoginReports".date("m-d-Y")."-".time().".csv";
				$csvFileName = DAP_ROOT.BULKFOLDER."/exportLoginReports".date("m-d-Y")."-".time().".csv";
				
				writeToFile($saveToFile,$csvFileName);
				
				$id=Dap_UsersLoginTracking::saveLoginLogoutReportExportQueryToCSV($csvFileName,$filename, $type);	
				$_SESSION["export_report"]=$id;
			}
			else {
				$_SESSION["export_report"]="";
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $users;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function saveLoginLogoutReportExportQueryToCSV($csvFileName,$filename, $type) {
		 logToFile("(Dap_UsersLoginTracking.saveLoginLogoutReportExportQueryToCSV() enters csvFileName".$csvFileName .", filename= ".$filename);
		try {
			$actionType = "EXPORTLOGINREPORTCSV";
		//	$payload = SITE_URL_DAP."/dap/bulk/". $filename;
			
			$payload = $csvFileName;
			
			$status = "NEW";
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
			//Insert into dap_mass_actions

			$sql = "insert into dap_mass_actions
									(actionType, actionKey, payload, status)
									values
									(:actionType, :key, :payload, 'NEW')";
									
			logToFile("(Dap_UsersLoginTracking.saveLoginLogoutReportExportQueryToCSV() sql= ".$sql);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
			$stmt->bindParam(':key', $key, PDO::PARAM_STR);
			$stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return $key;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}  
	

}
