<?php 
	include_once ("dap-config.php");
	if( !Dap_Session::isLoggedIn() ) { 
		//send viewer to login page
		header("Location:" . Dap_Config::get("LOGIN_URL"));
		exit;
	}
	
	$responseArray = array();
	$response = "";
	
	//Unset it so that the next time LiveLinks kicks in, it will do a WP sync
	if( isset($_SESSION["dap-wp-nosync"]) ) {
		unset($_SESSION["dap-wp-nosync"]);
	}
  
	$customArray = $_POST['custom'];
	/*	if ($customArray) {
		logToFile("userProfileSubmit.php: customNameValue: before explode", LOG_DEBUG_DAP);
		$custom = explode(",", $customArray);
		foreach($custom as $customNameValue) {
			logToFile("userProfileSubmit.php: customNameValue: " . $customNameValue, LOG_DEBUG_DAP);
		}
	}
	*/
	
	$userData = array();
	$customArray = array();
	
	if( !isset($_POST['u_opted_out']) || ($_POST['u_opted_out'] == "") ) {
		$_POST['u_opted_out'] = "N";
	}
				
	foreach ($_POST as $key => $value) {
		$value = stripslashes(trim($value));
		//$req .= "&$key=$value";
		if(stripos($key, "u_") !== false) {
		//	logToFile("userProfileSubmit.php: " . $key . "=" . $value);
			$key = str_replace("u_","",$key);
			$_POST[$key] = $value;
			$userData[$key] = $value;
		} else if(stripos($key, "custom_") !== false) {
		//	logToFile("userProfileSubmit.php: customArray: " . $key . "=" . $value);
			$key = str_replace("custom_","",$key);
			$customArray[] = $key."||".$value;
		}
	}
	
	/**
	logToFile("-------------------------------------------"); 			
	foreach ($userData as $key => $value) {
		logToFile("userProfileSubmit.php userData: " . $key . "=" . $value);
	}
	foreach ($customArray as $key => $value) {
		logToFile("userProfileSubmit.php customArray: " . $key . "=" . $value);
	}
	logToFile("-------------------------------------------"); 			
	*/
	
	$session = Dap_Session::getSession();
	$user = $session->getUser();
	
	$passwordChanged = false;
	$emailChanged = false;
	$userNameChanged = false;
	$notifyForGDPRNo = false;
	
	$currentPassword = $user->getPassword();
	$currentEmail = $user->getEmail();
	$currentUserName = $user->getUser_name();
		
	if ( 
			isset($_POST['user_name']) && 
			(trim($_POST['user_name']) != "") &&
			( trim($currentUserName) != trim($_POST['user_name']) )
		) {
		$userNameChanged = true;	
	
		//logToFile("userProfileSubmit.php: username $currentUserName changed to " . $_POST['user_name'],LOG_DEBUG_DAP);
		
		/*if (trim($currentUserName) != "") {
			logToFile("Sorry, cannot change username if already set. Please contact the site admin",LOG_DEBUG_DAP);
			$response = "Sorry, cannot change username if already set. Please contact the site admin";
			$responseArray['responseJSON'] = $response;
			$responseJSON = json_encode($responseArray);
			echo $responseJSON;
			return;
		}*/
		
	}
		
	if ( isset($_POST['password']) && ($_POST['password'] != "") && (trim($currentPassword) != trim($_POST['password'])) ) {
			//logToFile("userProfileSubmit.php: password $currentPassword changed to " . $_POST['password'],LOG_DEBUG_DAP);
			$passwordChanged = true;
	}
	
	if ( isset($_POST['email']) && (trim($currentEmail) != trim($_POST['email'])) ) {
		//logToFile("email $currentEmail changed to " . $_POST['email']); 
		$emailChanged = true;	
	}
	
	//$password = md5($password);
	if ($userNameChanged && $emailChanged) {
		$response = "Sorry, cannot change both username and email at the same time, please change one at a time";
		header("Location: " . $_POST['redirect'] . "?msg=$response");
		exit;
	}
	
	$userData["id"] = $user->getId();
	$userId = $user->getId();
	if(isset($userData["user_name"]) && ($userData["user_name"] == "") ) {
		unset($userData["user_name"]);
	}
	
	//if (isset($customArray)) $user->setUser_custom_fields($customArray);
	
	if (isset($userData["email"]) && ($userData["email"] == "") ) {
		$response = "Sorry, Email may not be blank";
		header("Location: " . $_POST['redirect'] . "?msg=$response");
		exit;
	}
	
	if(isset($userData["gdpr_consent"]) && $userData["gdpr_consent"] == "GDPR_CONSENT_NO"){
		logToFile( "userProfileSubmit.php: GDPR consent not given , so we will have to check that whether to notify admin or not");
		$notifyForGDPRNo = true;
	}
	
	
	try {
		Dap_User::updateUserProfile($userData,$customArray);
		$user = Dap_User::loadUserById($user->getId()); //reload User object
		$session->setUser($user);
		logToFile( "userProfileSubmit.php: user updated in dap");
		//echo "userProfileSubmit.php: user updated in dap"; exit;
		
		$response = "USER_PROFILE_SUCCESS_MESSAGE_USER";
	} catch (PDOException $e) {
		$response = $e->getMessage();
		$responseArray['responseJSON'] = $response;
		$responseJSON = json_encode($responseArray);
		echo $responseJSON;
		return;
	} catch (Exception $e) {
		$response = ERROR_GENERAL;
		$responseArray['responseJSON'] = $response;
		$responseJSON = json_encode($responseArray);
		echo $responseJSON;
		return;
	}


	//Update email in transaction if email changed
	if($emailChanged) {
		logToFile("email changed from $currentEmail to $email");
		Dap_Transactions::updateEmail($currentEmail,$userData["email"]);
	}
			
	if ($userNameChanged) {
		logToFile( "userProfileSubmit.php: UserName changed to " . $user_name);
		global $includeList;
		$includeList = array();
		registeredPlugins($includeList, $email, "Sync");
	
		foreach ($includeList as $key => $value) {
			logToFile( "userProfileSubmit.php: KEY=" . $key . ", VALUE=" . $value );
			
			include_once ($value);
			$forum = new Dap_Vbulletin();
			
			$newdap=new Dap_User();
			$newdap->setId($userId);
			$newdap->setUser_name($user_name);
			$newdap->setFirst_name($first_name);
			$newdap->setLast_name($last_name);
			$newdap->setEmail($email);
			$newdap->setPassword($password);

			$errmsg = $forum->SyncUser($userId, $productId, false, true, $user);

			if ($errmsg != NULL) {
				$response = "Sorry, could not register this username(=" . $user_name . ") to vbforum. Please contact the site admin or pick another username";
				logToFile("(userProfileSubmit.php): could not register user=" . $email . " and productId=" . $productId . " to vbforum",LOG_INFO_DAP);

				$user->setUser_name($currentUserName);			
				try {
					$user->update();
					logToFile("User: " . $username . " updated to original value",LOG_INFO_DAP);
				} catch (PDOException $e) {
					$response = ERROR_GENERAL;
					logToFile("User: " . $username . " could not be updated:  Exception: " . $response,LOG_INFO_DAP);
					//sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not reset username=" . $currentUserName, $response);
				} catch (Exception $e) {
					$response = ERROR_GENERAL;
					logToFile("User: " . $username . " could not be updated:  Exception: " . $response,LOG_INFO_DAP);
					//sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not reset username=" . $currentUserName, $response);
				}
					
			}
			else {
				logToFile("(userProfileSubmit.php): VB Forum successfully updated for DAP User=" . $email . " and productId=" . $productId,LOG_INFO_DAP);
			}
		}
	
	}
	else if (($passwordChanged || $emailChanged) && ($user_name != "")) {
		logToFile("userProfileSubmit.php: password or email changed ",LOG_DEBUG_DAP);
	
		global $includeList;
		$includeList = array();
		registeredPlugins($includeList, $email, "Update");
	
		foreach ($includeList as $key => $value) {
			logToFile( "userProfileSubmit.php: KEY=" . $key . ", VALUE=" . $value );
			
			include_once ($value);
			$forum = new Dap_Vbulletin();
			$errmsg = $forum->user($user, $productId, "", "Y");

			if ($errmsg != NULL) {
				logToFile("(userProfileSubmit.php): could not update forum for user=" . $email . " and productId=" . $productId,LOG_INFO_DAP);
				$response = "Sorry, email already in use in VB. Please try using another email Id";
				$user->setEmail($currentEmail);			
				try {
					$user->update();
					logToFile("User: " . $email . " updated to original value of " . $currentEmail,LOG_INFO_DAP);
				} catch (PDOException $e) {
					$response = ERROR_GENERAL;
					logToFile("User: " . $email . " could not be reset:  Exception: " . $response,LOG_INFO_DAP);
					//sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not reset username=" . $currentUserName, $response);
				} catch (Exception $e) {
					$response = ERROR_GENERAL;
					logToFile("User: " . $email . " could not be reset:  Exception: " . $response,LOG_INFO_DAP);
					//sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not reset username=" . $currentUserName, $response);
				}
			}
			else {			
				logToFile("(userProfileSubmit.php): Forum successfully updated for DAP User=" . $email . " and productId=" . $productId,LOG_INFO_DAP);
			}
		}
	}
	
	if($notifyForGDPRNo){
		try{
			$gdpr_settings = Dap_GDPR::load();
			if(isset($gdpr_settings) && $gdpr_settings->id !=""){
				$send_admin_email = $gdpr_settings->getSend_admin_email();
				
				if($send_admin_email == "Y"){
					logToFile("userProfileSubmit.php: GDPR settings say to notify admin for GDPRConsent not given",LOG_INFO_DAP);
					$subject = '[DAP GDPR Decline Notification] User declined GDPR Terms on the My Profile page';
					$msg = "This user declined to give GDPR consent:".
							"Email: ".$user->getEmail().", Fistname:".$user->getFirst_name().", Lastname: ".$user->getLast_name().", Page: ".$_SERVER['HTTP_HOST'].$_POST['redirect'];
							
					$adminEmail = Dap_Config::get('ADMIN_EMAIL');
					if($adminEmail!="")
							sendEmail($adminEmail, $subject, $msg);

				}
				else{
					logToFile("userProfileSubmit.php: GDPR settings say not to notify admin for GDPRConsent not given",LOG_INFO_DAP);
				}
			}
		}
		catch(Exception $e){
			logToFile("userProfileSubmit.php: Exception while getting gdpr_settings ".$e->getMessge(),LOG_INFO_DAP);
		}
		
	}
		
	header("Location: " . $_POST['redirect'] . "?msg=$response");

?>
